/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr.bridj;

import org.bridj.Pointer;
import org.geotools.data.ogr.bridj.OgrLibrary;

class OGRUtils {
    private static boolean HAS_L_GETNAME;

    OGRUtils() {
    }

    public static void releaseDataSource(Pointer dataSet) {
        if (dataSet != null) {
            OgrLibrary.OGRReleaseDataSource(dataSet);
            dataSet.release();
        }
    }

    public static void releaseLayer(Pointer layer) {
        if (layer != null) {
            layer.release();
        }
    }

    public static void releaseDefinition(Pointer definition) {
        if (definition != null) {
            definition.release();
        }
    }

    public static void releaseSpatialReference(Pointer spatialReference) {
        if (spatialReference != null) {
            spatialReference.release();
        }
    }

    public static String getCString(Pointer<Byte> ptr) {
        if (ptr == null) {
            return null;
        }
        return ptr.getCString();
    }

    public static String getLayerName(Pointer layer) {
        Pointer<Byte> namePtr = null;
        try {
            if (HAS_L_GETNAME) {
                namePtr = OgrLibrary.OGR_L_GetName(layer);
            }
        }
        catch (Exception e) {
            HAS_L_GETNAME = false;
        }
        if (namePtr == null) {
            Pointer<?> layerDefinition = OgrLibrary.OGR_L_GetLayerDefn(layer);
            namePtr = OgrLibrary.OGR_FD_GetName(layerDefinition);
        }
        return OGRUtils.getCString(namePtr);
    }
}

