/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr.bridj;

import org.bridj.BridJ;
import org.geotools.data.ogr.bridj.OgrLibrary;

class GdalInit {
    private static volatile String NATIVE_NAME;

    GdalInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() {
        if (NATIVE_NAME != null) return;
        Class<GdalInit> clazz = GdalInit.class;
        synchronized (GdalInit.class) {
            if (NATIVE_NAME != null) return;
            NATIVE_NAME = System.getProperty("GDAL_LIBRARY_NAME");
            if (NATIVE_NAME != null && !NATIVE_NAME.isEmpty()) {
                if (GdalInit.checkNativeName(NATIVE_NAME)) return;
                throw new RuntimeException("Failed to bind to user specified gdal library named: " + NATIVE_NAME);
            } else {
                if (GdalInit.checkNativeName("gdal") || GdalInit.checkNativeName("gdal_fw")) return;
                int x = 1;
                for (int y = 10; y >= 0; --y) {
                    if (GdalInit.checkNativeName("gdal" + x + "." + y)) {
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                    for (int z = 5; z >= 0; --z) {
                        if (!GdalInit.checkNativeName("gdal" + x + "." + y + "." + z)) continue;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                }
                throw new RuntimeException("Failed to automatically guess the gdal library name, please set the GDAL_LIBRARY_NAME system variable");
            }
        }
    }

    static boolean checkNativeName(String name) {
        try {
            if (BridJ.getNativeLibrary(name) != null) {
                GdalInit.registerAlias(name);
                OgrLibrary.OGRGetDriverCount();
                NATIVE_NAME = name;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void registerAlias(String name) {
        System.out.println("Registered library as " + name);
        BridJ.addNativeLibraryAlias("ogr", name);
        BridJ.addNativeLibraryAlias("osr", name);
        BridJ.addNativeLibraryAlias("cplError", name);
        BridJ.addNativeLibraryAlias("gdal", name);
    }
}

