/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ogr.bridj;

import java.io.IOException;
import org.bridj.Pointer;
import org.geotools.data.ogr.OGR;
import org.geotools.data.ogr.bridj.BridjUtilities;
import org.geotools.data.ogr.bridj.CplErrorLibrary;
import org.geotools.data.ogr.bridj.GdalInit;
import org.geotools.data.ogr.bridj.OGREnvelope;
import org.geotools.data.ogr.bridj.OGRUtils;
import org.geotools.data.ogr.bridj.OgrLibrary;
import org.geotools.data.ogr.bridj.OsrLibrary;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BridjOGR
implements OGR {
    @Override
    public int GetDriverCount() {
        return OgrLibrary.OGRGetDriverCount();
    }

    @Override
    public Object GetDriver(int i) {
        return OgrLibrary.OGRGetDriver(i);
    }

    @Override
    public Object GetDriverByName(String name) {
        return OgrLibrary.OGRGetDriverByName(Pointer.pointerToCString(name));
    }

    @Override
    public Object OpenShared(String dataSourceName, int mode) {
        return OgrLibrary.OGROpenShared(Pointer.pointerToCString(dataSourceName), mode, null);
    }

    @Override
    public Object Open(String dataSourceName, int mode) {
        return OgrLibrary.OGROpen(Pointer.pointerToCString(dataSourceName), mode, null);
    }

    @Override
    public void CheckError(int code) throws IOException {
        if (code == 0) {
            return;
        }
        String error = BridjUtilities.getCString(CplErrorLibrary.CPLGetLastErrorMsg());
        switch (code) {
            case 5: {
                throw new IOException("OGR reported a currupt data error: " + error);
            }
            case 6: {
                throw new IOException("OGR reported a generic failure: " + error);
            }
            case 8: {
                throw new IOException("OGR reported an invalid handle error: " + error);
            }
            case 1: {
                throw new IOException("OGR reported not enough data was provided in the last call: " + error);
            }
            case 2: {
                throw new IOException("OGR reported not enough memory is available: " + error);
            }
            case 3: {
                throw new IOException("OGR reported a unsupported geometry type error: " + error);
            }
            case 4: {
                throw new IOException("OGR reported a unsupported operation error: " + error);
            }
            case 7: {
                throw new IOException("OGR reported a unsupported SRS error: " + error);
            }
        }
        throw new IOException("OGR reported an unrecognized error code: " + code);
    }

    @Override
    public String GetLastErrorMsg() {
        return BridjUtilities.getCString(CplErrorLibrary.CPLGetLastErrorMsg());
    }

    @Override
    public String DriverGetName(Object driver) {
        return BridjUtilities.getCString(OgrLibrary.OGR_Dr_GetName((Pointer)driver));
    }

    @Override
    public Object DriverOpen(Object driver, String dataSourceName, int mode) {
        return OgrLibrary.OGR_Dr_Open((Pointer)driver, Pointer.pointerToCString(dataSourceName), mode);
    }

    @Override
    public Object DriverCreateDataSource(Object driver, String dataSourceName, String[] opts) {
        return OgrLibrary.OGR_Dr_CreateDataSource((Pointer)driver, Pointer.pointerToCString(dataSourceName), BridjUtilities.pointerToCStrings(opts));
    }

    @Override
    public void DriverRelease(Object driver) {
        ((Pointer)driver).release();
    }

    @Override
    public Object DataSourceGetDriver(Object dataSource) {
        return OgrLibrary.OGR_DS_GetDriver((Pointer)dataSource);
    }

    @Override
    public int DataSourceGetLayerCount(Object dataSource) {
        return OgrLibrary.OGR_DS_GetLayerCount((Pointer)dataSource);
    }

    @Override
    public Object DataSourceGetLayer(Object dataSource, int i) {
        return OgrLibrary.OGR_DS_GetLayer((Pointer)dataSource, i);
    }

    @Override
    public Object DataSourceGetLayerByName(Object dataSource, String name) {
        return OgrLibrary.OGR_DS_GetLayerByName((Pointer)dataSource, Pointer.pointerToCString(name));
    }

    @Override
    public void DataSourceRelease(Object dataSource) {
        OGRUtils.releaseDataSource((Pointer)dataSource);
    }

    @Override
    public Object DataSourceCreateLayer(Object dataSource, String name, Object spatialReference, long geomType, String[] opts) {
        return OgrLibrary.OGR_DS_CreateLayer((Pointer)dataSource, Pointer.pointerToCString(name), (Pointer)spatialReference, OgrLibrary.OGRwkbGeometryType.fromValue(geomType), BridjUtilities.pointerToCStrings(opts));
    }

    @Override
    public Object DataSourceExecuteSQL(Object dataSource, String sql, Object spatialFilter) {
        return OgrLibrary.OGR_DS_ExecuteSQL((Pointer)dataSource, Pointer.pointerToCString(sql), (Pointer)spatialFilter, null);
    }

    @Override
    public Object LayerGetLayerDefn(Object layer) {
        return OgrLibrary.OGR_L_GetLayerDefn((Pointer)layer);
    }

    @Override
    public int LayerGetFieldCount(Object layerDefn) {
        return OgrLibrary.OGR_FD_GetFieldCount((Pointer)layerDefn);
    }

    @Override
    public Object LayerGetFieldDefn(Object layerDefn, int i) {
        return OgrLibrary.OGR_FD_GetFieldDefn((Pointer)layerDefn, i);
    }

    @Override
    public String LayerGetName(Object layer) {
        return BridjUtilities.getCString(OgrLibrary.OGR_L_GetName((Pointer)layer));
    }

    @Override
    public long LayerGetGeometryType(Object layerDefn) {
        return OgrLibrary.OGR_FD_GetGeomType((Pointer)layerDefn).value();
    }

    @Override
    public Object LayerGetSpatialRef(Object layer) {
        return OgrLibrary.OGR_L_GetSpatialRef((Pointer)layer);
    }

    @Override
    public Object LayerGetExtent(Object layer) {
        Pointer<OGREnvelope> boundsPtr = Pointer.allocate(OGREnvelope.class);
        int code = OgrLibrary.OGR_L_GetExtent((Pointer)layer, boundsPtr, 0);
        if (code == 6) {
            return null;
        }
        return boundsPtr;
    }

    @Override
    public long LayerGetFeatureCount(Object layer) {
        return OgrLibrary.OGR_L_GetFeatureCount((Pointer)layer, 0);
    }

    @Override
    public void LayerRelease(Object layer) {
        OGRUtils.releaseLayer((Pointer)layer);
    }

    @Override
    public void LayerReleaseLayerDefn(Object layerDefn) {
        OGRUtils.releaseDefinition((Pointer)layerDefn);
    }

    @Override
    public boolean LayerCanDeleteFeature(Object layer) {
        return OgrLibrary.OGR_L_TestCapability((Pointer)layer, Pointer.pointerToCString("DeleteFeature")) != 0;
    }

    @Override
    public boolean LayerCanWriteRandom(Object layer) {
        return OgrLibrary.OGR_L_TestCapability((Pointer)layer, Pointer.pointerToCString("RandomWrite")) != 0;
    }

    @Override
    public boolean LayerCanWriteSequential(Object layer) {
        return OgrLibrary.OGR_L_TestCapability((Pointer)layer, Pointer.pointerToCString("SequentialWrite")) != 0;
    }

    @Override
    public boolean LayerCanCreateField(Object layer) {
        return OgrLibrary.OGR_L_TestCapability((Pointer)layer, Pointer.pointerToCString("CreateField")) != 0;
    }

    @Override
    public boolean LayerCanIgnoreFields(Object layer) {
        return OgrLibrary.OGR_L_TestCapability((Pointer)layer, Pointer.pointerToCString("IgnoreFields")) != 0;
    }

    @Override
    public void LayerCreateField(Object layer, Object fieldDefn, int approx) {
        OgrLibrary.OGR_L_CreateField((Pointer)layer, (Pointer)fieldDefn, approx);
    }

    @Override
    public void LayerSyncToDisk(Object layer) {
        OgrLibrary.OGR_L_SyncToDisk((Pointer)layer);
    }

    @Override
    public Object LayerNewFeature(Object layerDefn) {
        return OgrLibrary.OGR_F_Create((Pointer)layerDefn);
    }

    @Override
    public ReferencedEnvelope toEnvelope(Object extent, CoordinateReferenceSystem crs) {
        OGREnvelope bounds = (OGREnvelope)((Pointer)extent).get();
        return new ReferencedEnvelope(bounds.MinX(), bounds.MaxX(), bounds.MinY(), bounds.MaxY(), crs);
    }

    @Override
    public void LayerSetSpatialFilter(Object layer, Object geometry) {
        OgrLibrary.OGR_L_SetSpatialFilter((Pointer)layer, (Pointer)geometry);
    }

    @Override
    public void LayerSetAttributeFilter(Object layer, String attFilter) {
        OgrLibrary.OGR_L_SetAttributeFilter((Pointer)layer, Pointer.pointerToCString(attFilter));
    }

    @Override
    public int LayerSetIgnoredFields(Object layer, String[] fields) {
        Pointer<Pointer<Byte>> ifPtr = BridjUtilities.pointerToCStrings(fields);
        return OgrLibrary.OGR_L_SetIgnoredFields((Pointer)layer, ifPtr);
    }

    @Override
    public void LayerResetReading(Object layer) {
        OgrLibrary.OGR_L_ResetReading((Pointer)layer);
    }

    @Override
    public Object LayerGetNextFeature(Object layer) {
        return OgrLibrary.OGR_L_GetNextFeature((Pointer)layer);
    }

    @Override
    public boolean LayerDeleteFeature(Object layer, long fid) {
        return OgrLibrary.OGR_L_DeleteFeature((Pointer)layer, fid) == 0;
    }

    @Override
    public int LayerSetFeature(Object layer, Object feature) {
        return OgrLibrary.OGR_L_SetFeature((Pointer)layer, (Pointer)feature);
    }

    @Override
    public int LayerCreateFeature(Object layer, Object feature) {
        return OgrLibrary.OGR_L_CreateFeature((Pointer)layer, (Pointer)feature);
    }

    @Override
    public String LayerGetFIDColumnName(Object layer) {
        return BridjUtilities.getCString(OgrLibrary.OGR_L_GetFIDColumn((Pointer)layer));
    }

    @Override
    public String FieldGetName(Object field) {
        return BridjUtilities.getCString(OgrLibrary.OGR_Fld_GetNameRef((Pointer)field));
    }

    @Override
    public long FieldGetType(Object field) {
        return OgrLibrary.OGR_Fld_GetType((Pointer)field).value();
    }

    @Override
    public int FieldGetWidth(Object field) {
        return OgrLibrary.OGR_Fld_GetWidth((Pointer)field);
    }

    @Override
    public void FieldSetWidth(Object field, int width) {
        OgrLibrary.OGR_Fld_SetWidth((Pointer)field, width);
    }

    @Override
    public void FieldSetJustifyRight(Object field) {
        OgrLibrary.OGR_Fld_SetJustify((Pointer)field, OgrLibrary.OGRJustification.OJRight);
    }

    @Override
    public void FieldSetPrecision(Object field, int precision) {
        OgrLibrary.OGR_Fld_SetPrecision((Pointer)field, 15);
    }

    @Override
    public boolean FieldIsIntegerType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTInteger.value();
    }

    @Override
    public boolean FieldIsRealType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTReal.value();
    }

    @Override
    public boolean FieldIsBinaryType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTBinary.value();
    }

    @Override
    public boolean FieldIsDateType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTDate.value();
    }

    @Override
    public boolean FieldIsTimeType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTTime.value();
    }

    @Override
    public boolean FieldIsDateTimeType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTDateTime.value();
    }

    @Override
    public boolean FieldIsIntegerListType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTIntegerList.value();
    }

    @Override
    public boolean FieldIsRealListType(long type) {
        return type == OgrLibrary.OGRFieldType.OFTRealList.value();
    }

    @Override
    public Object CreateStringField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTString);
    }

    @Override
    public Object CreateIntegerField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTInteger);
    }

    @Override
    public Object CreateRealField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTReal);
    }

    @Override
    public Object CreateBinaryField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTBinary);
    }

    @Override
    public Object CreateDateField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTDate);
    }

    @Override
    public Object CreateTimeField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTTime);
    }

    @Override
    public Object CreateDateTimeField(String name) {
        return OgrLibrary.OGR_Fld_Create(Pointer.pointerToCString(name), OgrLibrary.OGRFieldType.OFTDateTime);
    }

    @Override
    public long FeatureGetFID(Object feature) {
        return OgrLibrary.OGR_F_GetFID((Pointer)feature);
    }

    @Override
    public boolean FeatureIsFieldSet(Object feature, int i) {
        return OgrLibrary.OGR_F_IsFieldSet((Pointer)feature, i) != 0;
    }

    @Override
    public void FeatureSetGeometryDirectly(Object feature, Object geometry) {
        OgrLibrary.OGR_F_SetGeometryDirectly((Pointer)feature, (Pointer)geometry);
    }

    @Override
    public Object FeatureGetGeometry(Object feature) {
        return OgrLibrary.OGR_F_GetGeometryRef((Pointer)feature);
    }

    @Override
    public void FeatureUnsetField(Object feature, int i) {
        OgrLibrary.OGR_F_UnsetField((Pointer)feature, i);
    }

    @Override
    public void FeatureSetFieldInteger(Object feature, int field, int value) {
        OgrLibrary.OGR_F_SetFieldInteger((Pointer)feature, field, value);
    }

    @Override
    public void FeatureSetFieldDouble(Object feature, int field, double value) {
        OgrLibrary.OGR_F_SetFieldDouble((Pointer)feature, field, value);
    }

    @Override
    public void FeatureSetFieldBinary(Object feature, int field, int length, byte[] value) {
        OgrLibrary.OGR_F_SetFieldBinary((Pointer)feature, field, value.length, Pointer.pointerToBytes(value));
    }

    @Override
    public void FeatureSetFieldDateTime(Object feature, int field, int year, int month, int day, int hour, int minute, int second, int tz) {
        OgrLibrary.OGR_F_SetFieldDateTime((Pointer)feature, field, year, month, day, hour, minute, second, tz);
    }

    @Override
    public void FeatureSetFieldString(Object feature, int field, String str) {
        OgrLibrary.OGR_F_SetFieldString((Pointer)feature, field, Pointer.pointerToCString(str));
    }

    @Override
    public String FeatureGetFieldAsString(Object feature, int i) {
        return BridjUtilities.getCString(OgrLibrary.OGR_F_GetFieldAsString((Pointer)feature, i));
    }

    @Override
    public int FeatureGetFieldAsInteger(Object feature, int i) {
        return OgrLibrary.OGR_F_GetFieldAsInteger((Pointer)feature, i);
    }

    @Override
    public double FeatureGetFieldAsDouble(Object feature, int i) {
        return OgrLibrary.OGR_F_GetFieldAsDouble((Pointer)feature, i);
    }

    @Override
    public void FeatureGetFieldAsDateTime(Object feature, int i, int[] yeara, int[] montha, int[] daya, int[] houra, int[] minutea, int[] seconda, int[] tzFlag) {
        Pointer<Integer> year = Pointer.allocateInt();
        Pointer<Integer> month = Pointer.allocateInt();
        Pointer<Integer> day = Pointer.allocateInt();
        Pointer<Integer> hour = Pointer.allocateInt();
        Pointer<Integer> minute = Pointer.allocateInt();
        Pointer<Integer> second = Pointer.allocateInt();
        Pointer<Integer> timeZone = Pointer.allocateInt();
        OgrLibrary.OGR_F_GetFieldAsDateTime((Pointer)feature, i, year, month, day, hour, minute, second, timeZone);
        yeara[0] = year.getInt();
        montha[0] = month.getInt();
        daya[0] = day.getInt();
        houra[0] = hour.getInt();
        minutea[0] = minute.getInt();
        seconda[0] = second.getInt();
        tzFlag[0] = timeZone.getInt();
    }

    @Override
    public void FeatureDestroy(Object feature) {
        OgrLibrary.OGR_F_Destroy((Pointer)feature);
    }

    @Override
    public long GetPointType() {
        return OgrLibrary.OGRwkbGeometryType.wkbPoint.value();
    }

    @Override
    public long GetPoint25DType() {
        return OgrLibrary.OGRwkbGeometryType.wkbPoint25D.value();
    }

    @Override
    public long GetLinearRingType() {
        return OgrLibrary.OGRwkbGeometryType.wkbLinearRing.value();
    }

    @Override
    public long GetLineStringType() {
        return OgrLibrary.OGRwkbGeometryType.wkbLineString.value();
    }

    @Override
    public long GetLineString25DType() {
        return OgrLibrary.OGRwkbGeometryType.wkbLineString25D.value();
    }

    @Override
    public long GetPolygonType() {
        return OgrLibrary.OGRwkbGeometryType.wkbPolygon.value();
    }

    @Override
    public long GetPolygon25DType() {
        return OgrLibrary.OGRwkbGeometryType.wkbPolygon25D.value();
    }

    @Override
    public long GetMultiPointType() {
        return OgrLibrary.OGRwkbGeometryType.wkbMultiPoint.value();
    }

    @Override
    public long GetMultiLineStringType() {
        return OgrLibrary.OGRwkbGeometryType.wkbMultiLineString.value();
    }

    @Override
    public long GetMultiLineString25DType() {
        return OgrLibrary.OGRwkbGeometryType.wkbMultiLineString25D.value();
    }

    @Override
    public long GetMultiPolygonType() {
        return OgrLibrary.OGRwkbGeometryType.wkbMultiPolygon.value();
    }

    @Override
    public long GetMultiPolygon25DType() {
        return OgrLibrary.OGRwkbGeometryType.wkbMultiPolygon25D.value();
    }

    @Override
    public long GetGeometryCollectionType() {
        return OgrLibrary.OGRwkbGeometryType.wkbGeometryCollection.value();
    }

    @Override
    public long GetGeometryCollection25DType() {
        return OgrLibrary.OGRwkbGeometryType.wkbGeometryCollection25D.value();
    }

    @Override
    public long GetGeometryNoneType() {
        return OgrLibrary.OGRwkbGeometryType.wkbNone.value();
    }

    @Override
    public long GetGeometryUnknownType() {
        return OgrLibrary.OGRwkbGeometryType.wkbUnknown.value();
    }

    @Override
    public int GeometryGetWkbSize(Object geom) {
        return OgrLibrary.OGR_G_WkbSize((Pointer)geom);
    }

    @Override
    public int GeometryExportToWkb(Object geom, byte[] wkb) {
        Pointer<Byte> p = Pointer.pointerToBytes(wkb);
        int ret = OgrLibrary.OGR_G_ExportToWkb((Pointer)geom, OgrLibrary.OGRwkbByteOrder.wkbXDR, p);
        System.arraycopy(p.getBytes(), 0, wkb, 0, wkb.length);
        return ret;
    }

    @Override
    public Object GeometryCreateFromWkb(byte[] wkb, int[] ret) {
        Pointer<Pointer<?>> ptr = Pointer.allocatePointer();
        ret[0] = OgrLibrary.OGR_G_CreateFromWkb(Pointer.pointerToBytes(wkb), null, ptr, wkb.length);
        return ptr.getPointer(Pointer.class);
    }

    @Override
    public String GeometryExportToWkt(Object geom, int[] ret) {
        Pointer<Pointer<Byte>> wktPtr = Pointer.allocatePointer(Byte.class);
        ret[0] = OgrLibrary.OGR_G_ExportToWkt((Pointer)geom, wktPtr);
        return BridjUtilities.getCString(wktPtr.getPointer(Byte.class));
    }

    @Override
    public Object GeometryCreateFromWkt(String wkt, int[] ret) {
        Pointer<Pointer<Byte>> ptr = Pointer.pointerToPointer(Pointer.pointerToCString(wkt));
        Pointer<Pointer<?>> geom = Pointer.allocatePointer();
        ret[0] = OgrLibrary.OGR_G_CreateFromWkt(ptr, null, geom);
        return geom.getPointer(Pointer.class);
    }

    @Override
    public void GeometryDestroy(Object geometry) {
        OgrLibrary.OGR_G_DestroyGeometry((Pointer)geometry);
    }

    @Override
    public String SpatialRefGetAuthorityCode(Object spatialRef, String authority) {
        return BridjUtilities.getCString(OsrLibrary.OSRGetAuthorityCode((Pointer)spatialRef, Pointer.pointerToCString(authority)));
    }

    @Override
    public String SpatialRefExportToWkt(Object spatialRef) {
        Pointer<Pointer<Byte>> wktPtr = Pointer.allocatePointer(Byte.class);
        OsrLibrary.OSRExportToWkt((Pointer)spatialRef, wktPtr);
        return BridjUtilities.getCString(wktPtr.getPointer(Byte.class));
    }

    @Override
    public void SpatialRefRelease(Object spatialRef) {
        OGRUtils.releaseSpatialReference((Pointer)spatialRef);
    }

    @Override
    public Object NewSpatialRef(String wkt) {
        return OsrLibrary.OSRNewSpatialReference(Pointer.pointerToCString(wkt));
    }

    static {
        GdalInit.init();
        if (OgrLibrary.OGRGetDriverCount() == 0) {
            OgrLibrary.OGRRegisterAll();
        }
    }
}

