/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property.old;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListener;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.property.old.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;

public class PropertyFeatureStore
extends AbstractFeatureLocking {
    String typeName;
    SimpleFeatureType featureType;
    PropertyDataStore store;
    long cacheTimestamp = 0L;
    ReferencedEnvelope cacheBounds = null;
    int cacheCount = -1;
    FeatureListener watcher = new FeatureListener(){

        @Override
        public void changed(FeatureEvent featureEvent) {
            if (PropertyFeatureStore.this.cacheBounds != null) {
                if (featureEvent.getType() == FeatureEvent.Type.ADDED) {
                    PropertyFeatureStore.this.cacheBounds.expandToInclude(featureEvent.getBounds());
                } else {
                    PropertyFeatureStore.this.cacheBounds = null;
                }
            }
            PropertyFeatureStore.this.cacheCount = -1;
        }
    };

    PropertyFeatureStore(PropertyDataStore propertyDataStore, String typeName) throws IOException {
        super(Collections.singleton(Hints.FEATURE_DETACHED));
        this.store = propertyDataStore;
        this.typeName = typeName;
        this.featureType = this.store.getSchema(typeName);
        this.store.listenerManager.addFeatureListener(this, this.watcher);
        this.queryCapabilities = new QueryCapabilities(){

            @Override
            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }

    @Override
    public PropertyDataStore getDataStore() {
        return this.store;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
        this.store.listenerManager.addFeatureListener(this, listener);
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
        this.store.listenerManager.removeFeatureListener(this, listener);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public int getCount(Query query) throws IOException {
        if (Filter.INCLUDE == query.getFilter() && this.getTransaction() == Transaction.AUTO_COMMIT) {
            File file = new File(this.store.directory, this.typeName + ".properties");
            if (this.cacheCount == -1 || file.lastModified() != this.cacheTimestamp) {
                this.cacheCount = PropertyDataStore.countFile(file);
                this.cacheTimestamp = file.lastModified();
            }
            if (query.getMaxFeatures() >= 0) {
                return Math.min(this.cacheCount, query.getMaxFeatures());
            }
            return this.cacheCount;
        }
        return -1;
    }

    @Override
    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            return this.getBounds();
        }
        ReferencedEnvelope result = this.getBoundsInternal(query);
        return result;
    }

    ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope result;
        block3: {
            SimpleFeatureCollection fc = this.getFeatures(query);
            SimpleFeatureIterator fi = null;
            result = ReferencedEnvelope.create(this.getSchema().getCoordinateReferenceSystem());
            try {
                fi = fc.features();
                while (fi.hasNext()) {
                    SimpleFeature f = (SimpleFeature)fi.next();
                    BoundingBox featureBoundingBox = f.getBounds();
                    if (f == null || featureBoundingBox == null) continue;
                    ReferencedEnvelope featureBounds = ReferencedEnvelope.reference(featureBoundingBox);
                    result.expandToInclude(featureBounds);
                }
            }
            catch (Exception e) {
                if (fi == null) break block3;
                fi.close();
            }
        }
        return result;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        File file = new File(this.store.directory, this.typeName + ".properties");
        if (this.cacheBounds != null && file.lastModified() == this.cacheTimestamp) {
            return this.cacheBounds;
        }
        try {
            this.cacheBounds = this.getBoundsInternal(Query.ALL);
            this.cacheTimestamp = file.lastModified();
            return this.cacheBounds;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

