/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property.old;

import java.io.File;
import java.io.IOException;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.FeatureListener;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.property.old.PropertyDataStore;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

public class PropertyFeatureSource
extends AbstractFeatureSource {
    String typeName;
    SimpleFeatureType featureType;
    PropertyDataStore store;
    long cacheTimestamp = 0L;
    ReferencedEnvelope cacheBounds = null;

    PropertyFeatureSource(PropertyDataStore propertyDataStore, String typeName) throws IOException {
        this.store = propertyDataStore;
        this.typeName = typeName;
        this.featureType = this.store.getSchema(typeName);
        this.queryCapabilities = new QueryCapabilities(){

            @Override
            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
        this.hints.add(Hints.FEATURE_DETACHED);
    }

    @Override
    public PropertyDataStore getDataStore() {
        return this.store;
    }

    @Override
    public void addFeatureListener(FeatureListener listener) {
        this.store.listenerManager.addFeatureListener(this, listener);
    }

    @Override
    public void removeFeatureListener(FeatureListener listener) {
        this.store.listenerManager.removeFeatureListener(this, listener);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.featureType;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        File file = new File(this.store.directory, this.typeName + ".properties");
        if (this.cacheBounds != null && file.lastModified() == this.cacheTimestamp) {
            return this.cacheBounds;
        }
        try {
            this.cacheBounds = this.getFeatures().getBounds();
            this.cacheTimestamp = file.lastModified();
            return this.cacheBounds;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

