/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property.old;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.property.old.PropertyDataStore;

public class PropertyDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param DIRECTORY = new DataAccessFactory.Param("directory", File.class, "Directory containting property files", true);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "namespace of datastore", false);

    public DataStore createDataStore(Map params) throws IOException {
        File dir = this.directoryLookup(params);
        String namespaceURI = (String)NAMESPACE.lookUp(params);
        if (dir.exists() && dir.isDirectory()) {
            return new PropertyDataStore(dir, namespaceURI);
        }
        throw new IOException("Directory is required");
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        File dir = (File)DIRECTORY.lookUp(params);
        if (dir.exists()) {
            throw new IOException(dir + " already exists");
        }
        boolean created = dir.mkdir();
        if (!created) {
            throw new IOException("Could not create the directory" + dir);
        }
        String namespaceURI = (String)NAMESPACE.lookUp(params);
        return new PropertyDataStore(dir, namespaceURI);
    }

    @Override
    public String getDisplayName() {
        return "Properties Old";
    }

    @Override
    public String getDescription() {
        return "Allows access to Java Property files containing Feature information";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DIRECTORY, NAMESPACE};
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public boolean canProcess(Map params) {
        try {
            this.directoryLookup(params);
            return true;
        }
        catch (Exception erp) {
            return false;
        }
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    private File directoryLookup(Map params) throws IOException, FileNotFoundException, IllegalArgumentException {
        File directory = (File)DIRECTORY.lookUp(params);
        if (!directory.exists()) {
            File currentDir = new File(System.getProperty("user.dir"));
            directory = new File(currentDir, (String)params.get(PropertyDataStoreFactory.DIRECTORY.key));
            if (!directory.exists()) {
                throw new FileNotFoundException(directory.getAbsolutePath());
            }
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
            }
        } else if (!directory.isDirectory()) {
            if (directory.getPath().endsWith(".properties")) {
                return directory.getParentFile();
            }
            throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
        }
        return directory;
    }
}

