/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property.old;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.property.old.PropertyFeatureReader;
import org.geotools.data.property.old.PropertyFeatureSource;
import org.geotools.data.property.old.PropertyFeatureStore;
import org.geotools.data.property.old.PropertyFeatureWriter;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTReader2;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class PropertyDataStore
extends AbstractDataStore {
    protected File directory;
    protected String namespaceURI;
    int cacheCount;
    long cacheTimestamp;

    public PropertyDataStore(File dir) {
        this(dir, null);
    }

    public PropertyDataStore(File dir, String namespaceURI) {
        super(true);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        if (namespaceURI == null) {
            namespaceURI = dir.getName();
        }
        this.directory = dir;
        this.namespaceURI = namespaceURI;
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        File file = new File(this.directory, typeName + ".properties");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write("_=");
        writer.write(DataUtilities.spec((FeatureType)featureType));
        writer.flush();
        writer.close();
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from Directory " + this.directory);
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        info.setSource(this.directory.toURI());
        try {
            info.setPublisher(new URI(System.getProperty("user.name")));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return info;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    @Override
    public String[] getTypeNames() {
        String[] list = this.directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].substring(0, list[i].lastIndexOf(46));
        }
        return list;
    }

    @Override
    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add(new NameImpl(this.namespaceURI, typeName));
        }
        return names;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        String typeSpec = this.property(typeName, "_");
        try {
            return DataUtilities.createType(this.namespaceURI, typeName, typeSpec);
        }
        catch (SchemaException e) {
            e.printStackTrace();
            throw new DataSourceException(typeName + " schema not available", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String property(String typeName, String key) throws IOException {
        File file = new File(this.directory, typeName + ".properties");
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(key + "=")) {
                    String string = line.substring(key.length() + 1);
                    return string;
                }
                line = reader.readLine();
            }
        }
        return null;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        PropertyFeatureReader reader = new PropertyFeatureReader(this.directory, typeName);
        Object toleranceHint = query.getHints().get((Object)Hints.LINEARIZATION_TOLERANCE);
        if (toleranceHint instanceof Double) {
            double tolerance = (Double)toleranceHint;
            reader.setWKTReader(new WKTReader2(tolerance));
        }
        return reader;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        return new PropertyFeatureReader(this.directory, typeName);
    }

    @Override
    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return new PropertyFeatureWriter(this, typeName);
    }

    @Override
    protected int getCount(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            String typeName = query.getTypeName();
            File file = new File(this.directory, typeName + ".properties");
            if (this.cacheCount != -1 && file.lastModified() == this.cacheTimestamp) {
                return this.cacheCount;
            }
            this.cacheCount = PropertyDataStore.countFile(file);
            this.cacheTimestamp = file.lastModified();
            return this.cacheCount;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int countFile(File file) {
        BufferedReader reader = null;
        try {
            String line;
            int skip = 1;
            reader = new LineNumberReader(new FileReader(file));
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                if (line.startsWith("#") || line.startsWith("!")) {
                    ++skip;
                }
                if (!line.endsWith("\\")) continue;
                ++skip;
            }
            int n = ((LineNumberReader)reader).getLineNumber() - skip;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        File file = new File(this.directory, typeName + ".properties");
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (file.canWrite()) {
            return new PropertyFeatureStore(this, typeName);
        }
        return new PropertyFeatureSource(this, typeName);
    }
}

