/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property.old;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.geotools.data.AttributeWriter;
import org.geotools.data.DataUtilities;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;

public class PropertyAttributeWriter
implements AttributeWriter {
    BufferedWriter writer;
    SimpleFeatureType type;

    public PropertyAttributeWriter(File file, SimpleFeatureType featureType) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
        this.type = featureType;
        this.writer.write("_=");
        this.writer.write(DataUtilities.spec((FeatureType)this.type));
    }

    @Override
    public int getAttributeCount() {
        return this.type.getAttributeCount();
    }

    @Override
    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        return this.type.getDescriptor(index);
    }

    @Override
    public boolean hasNext() throws IOException {
        return false;
    }

    @Override
    public void next() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.newLine();
        this.writer.flush();
    }

    public void writeFeatureID(String fid) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.write(fid);
    }

    @Override
    public void write(int position, Object attribute) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        this.writer.write(position == 0 ? "=" : "|");
        if (attribute == null) {
            this.writer.write("<null>");
        } else if (attribute instanceof String) {
            String txt = this.encodeString((String)attribute);
            this.writer.write(txt);
        } else if (attribute instanceof Geometry) {
            Geometry geometry = (Geometry)attribute;
            String txt = geometry.toText();
            txt = this.encodeString(txt);
            this.writer.write(txt);
        } else {
            String txt = Converters.convert(attribute, String.class);
            if (txt == null) {
                txt = attribute.toString();
            }
            txt = this.encodeString(txt);
            this.writer.write(txt);
        }
    }

    String encodeString(String txt) {
        txt = txt.replace("|", "\\|");
        txt = txt.replace("\n", "\\n");
        txt = txt.replace("\r", "\\r");
        return txt;
    }

    @Override
    public void close() throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has already been closed");
        }
        this.writer.close();
        this.writer = null;
        this.type = null;
    }

    public void echoLine(String line) throws IOException {
        if (this.writer == null) {
            throw new IOException("Writer has been closed");
        }
        if (line == null) {
            return;
        }
        this.writer.write(line);
    }
}

