/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.util.Parameter;

public class NetcdfDatasetInfo
implements AutoCloseable {
    private NetcdfDataset ds;
    private CoordSysBuilderIF builder;

    public NetcdfDatasetInfo(String location) throws IOException {
        this.ds = NetcdfDataset.openDataset(location, false, null);
        this.builder = this.ds.enhance();
    }

    public NetcdfDatasetInfo(NetcdfDataset ds) throws IOException {
        File loc = new File(ds.getLocation());
        if (loc.exists()) {
            this.ds = NetcdfDataset.openDataset(ds.getLocation(), false, null);
            this.builder = this.ds.enhance();
        } else {
            this.ds = ds;
            this.builder = ds.enhance();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public String getParseInfo() {
        return this.builder == null ? "" : this.builder.getParseInfo();
    }

    public String getUserAdvice() {
        return this.builder == null ? "" : this.builder.getUserAdvice();
    }

    public String getConventionUsed() {
        return this.builder == null ? "None" : this.builder.getConventionUsed();
    }

    public String writeXML() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.makeDocument());
    }

    public GridCoordSys getGridCoordSys(VariableEnhanced ve) {
        List<CoordinateSystem> csList = ve.getCoordinateSystems();
        for (CoordinateSystem cs : csList) {
            if (!GridCoordSys.isGridCoordSys(null, cs, ve)) continue;
            return new GridCoordSys(cs, null);
        }
        return null;
    }

    public void writeXML(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeDocument(), os);
    }

    public Document makeDocument() {
        String string;
        GridCoordSys gcs;
        VariableEnhanced ve;
        Element rootElem = new Element("netcdfDatasetInfo");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.ds.getLocation());
        rootElem.addContent((Content)new Element("convention").setAttribute("name", this.getConventionUsed()));
        int nDataVariables = 0;
        int nOtherVariables = 0;
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        int nCoordAxes = axes.size();
        for (CoordinateAxis coordinateAxis : axes) {
            CoordinateAxis1D axis1D;
            Element element = new Element("axis");
            rootElem.addContent((Content)element);
            element.setAttribute("name", coordinateAxis.getFullName());
            element.setAttribute("decl", this.getDecl(coordinateAxis));
            if (coordinateAxis.getAxisType() != null) {
                element.setAttribute("type", coordinateAxis.getAxisType().toString());
            }
            if (coordinateAxis.getUnitsString() != null) {
                element.setAttribute("units", coordinateAxis.getUnitsString());
                element.setAttribute("udunits", this.isUdunits(coordinateAxis.getUnitsString()));
            }
            if (!(coordinateAxis instanceof CoordinateAxis1D) || !(axis1D = (CoordinateAxis1D)coordinateAxis).isRegular()) continue;
            element.setAttribute("regular", ucar.unidata.util.Format.d(axis1D.getIncrement(), 5));
        }
        List<CoordinateSystem> csList = this.ds.getCoordinateSystems();
        for (CoordinateSystem coordinateSystem : csList) {
            Element csElem;
            if (GridCoordSys.isGridCoordSys(null, coordinateSystem, null)) {
                GridCoordSys gcs2 = new GridCoordSys(coordinateSystem, null);
                csElem = new Element("gridCoordSystem");
                csElem.setAttribute("name", coordinateSystem.getName());
                csElem.setAttribute("horizX", gcs2.getXHorizAxis().getFullName());
                csElem.setAttribute("horizY", gcs2.getYHorizAxis().getFullName());
                if (gcs2.hasVerticalAxis()) {
                    csElem.setAttribute("vertical", gcs2.getVerticalAxis().getFullName());
                }
                if (gcs2.hasTimeAxis()) {
                    csElem.setAttribute("time", coordinateSystem.getTaxis().getFullName());
                }
            } else {
                csElem = new Element("coordSystem");
                csElem.setAttribute("name", coordinateSystem.getName());
            }
            List<CoordinateTransform> coordTransforms = coordinateSystem.getCoordinateTransforms();
            for (CoordinateTransform coordinateTransform : coordTransforms) {
                Element ctElem = new Element("coordTransform");
                csElem.addContent((Content)ctElem);
                ctElem.setAttribute("name", coordinateTransform.getName());
                ctElem.setAttribute("type", coordinateTransform.getTransformType().toString());
            }
            rootElem.addContent((Content)csElem);
        }
        List<CoordinateTransform> list = this.ds.getCoordinateTransforms();
        for (CoordinateTransform ct : list) {
            Element ctElem = new Element("coordTransform");
            rootElem.addContent((Content)ctElem);
            ctElem.setAttribute("name", ct.getName());
            ctElem.setAttribute("type", ct.getTransformType().toString());
            List<Parameter> params = ct.getParameters();
            for (Parameter pp : params) {
                Element ppElem = new Element("param");
                ctElem.addContent((Content)ppElem);
                ppElem.setAttribute("name", pp.getName());
                ppElem.setAttribute("value", pp.getStringValue());
            }
        }
        for (Variable var : this.ds.getVariables()) {
            ve = (VariableEnhanced)((Object)var);
            if (ve instanceof CoordinateAxis || null == (gcs = this.getGridCoordSys(ve))) continue;
            ++nDataVariables;
            Element element = new Element("grid");
            rootElem.addContent((Content)element);
            element.setAttribute("name", ve.getFullName());
            element.setAttribute("decl", this.getDecl(ve));
            if (ve.getUnitsString() != null) {
                element.setAttribute("units", ve.getUnitsString());
                element.setAttribute("udunits", this.isUdunits(ve.getUnitsString()));
            }
            element.setAttribute("coordSys", gcs.getName());
        }
        for (Variable var : this.ds.getVariables()) {
            ve = (VariableEnhanced)((Object)var);
            if (ve instanceof CoordinateAxis || null != (gcs = this.getGridCoordSys(ve))) continue;
            ++nOtherVariables;
            Element element = new Element("variable");
            rootElem.addContent((Content)element);
            element.setAttribute("name", ve.getFullName());
            element.setAttribute("decl", this.getDecl(ve));
            if (ve.getUnitsString() != null) {
                element.setAttribute("units", ve.getUnitsString());
                element.setAttribute("udunits", this.isUdunits(ve.getUnitsString()));
            }
            element.setAttribute("coordSys", this.getCoordSys(ve));
        }
        if (nDataVariables > 0) {
            rootElem.addContent((Content)new Element("userAdvice").addContent("Dataset contains useable gridded data."));
            if (nOtherVariables > 0) {
                rootElem.addContent((Content)new Element("userAdvice").addContent("Some variables are not gridded fields; check that is what you expect."));
            }
        } else if (nCoordAxes == 0) {
            rootElem.addContent((Content)new Element("userAdvice").addContent("No Coordinate Axes were found."));
        } else {
            rootElem.addContent((Content)new Element("userAdvice").addContent("No gridded data variables were found."));
        }
        if ((string = this.getUserAdvice()).length() > 0) {
            StringTokenizer toker = new StringTokenizer(string, "\n");
            while (toker.hasMoreTokens()) {
                rootElem.addContent((Content)new Element("userAdvice").addContent(toker.nextToken()));
            }
        }
        return doc;
    }

    private String getDecl(VariableEnhanced ve) {
        Formatter sb = new Formatter();
        sb.format("%s ", ve.getDataType().toString());
        ve.getNameAndDimensions(sb, true, true);
        return sb.toString();
    }

    private String getCoordSys(VariableEnhanced ve) {
        List<CoordinateSystem> csList = ve.getCoordinateSystems();
        if (csList.size() == 1) {
            CoordinateSystem cs = csList.get(0);
            return cs.getName();
        }
        if (csList.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < csList.size(); ++i) {
                CoordinateSystem cs = csList.get(i);
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(cs.getName());
            }
            return sb.toString();
        }
        return " ";
    }

    private String isUdunits(String unit) {
        try {
            new DateUnit(unit);
            return "date";
        }
        catch (Exception exception) {
            SimpleUnit su = SimpleUnit.factory(unit);
            if (null == su) {
                return "false";
            }
            return su.getCanonicalString();
        }
    }

    public static void main(String[] args) throws IOException {
        String url = "C:/data/badmodels/RUC_CONUS_80km_20051211_1900.nc";
        try (NetcdfDatasetInfo info = new NetcdfDatasetInfo(url);){
            String infoString = info.writeXML();
            System.out.println(infoString);
        }
    }
}

