/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.csw.bindings;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.cat.csw20.Csw20Factory;
import net.opengis.cat.csw20.RecordType;
import net.opengis.cat.csw20.SimpleLiteral;
import net.opengis.ows10.WGS84BoundingBoxType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.geotools.csw.CSW;
import org.geotools.csw.DC;
import org.geotools.csw.DCT;
import org.geotools.ows.OWS;
import org.geotools.xml.ComplexEMFBinding;

public class RecordBinding
extends ComplexEMFBinding {
    public RecordBinding() {
        super((EFactory)Csw20Factory.eINSTANCE, CSW.RecordType);
    }

    public List getProperties(Object object, XSDElementDeclaration element) throws Exception {
        RecordType record = (RecordType)object;
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        XSDParticle previous = null;
        String previousName = null;
        for (SimpleLiteral sl : record.getDCElement()) {
            XSDParticle particle;
            XSDSchema dctSchema = DCT.getInstance().getSchema();
            XSDElementDeclaration declaration = dctSchema.resolveElementDeclaration(sl.getName());
            if (declaration.getTypeDefinition() == null) {
                XSDSchema dcSchema = DC.getInstance().getSchema();
                declaration = dcSchema.resolveElementDeclaration(sl.getName());
            }
            if (declaration == null) continue;
            if (previousName != null && sl.getName().equals(previousName)) {
                particle = previous;
            } else {
                previous = particle = this.buildParticle(declaration);
                previousName = sl.getName();
            }
            result.add(new Object[]{particle, sl});
        }
        if (record.getBoundingBox() != null && record.getBoundingBox().size() > 0) {
            for (Object box : record.getBoundingBox()) {
                XSDElementDeclaration bboxElement = box instanceof WGS84BoundingBoxType ? OWS.getInstance().getSchema().resolveElementDeclaration("WGS84BoundingBox") : OWS.getInstance().getSchema().resolveElementDeclaration("BoundingBox");
                XSDParticle particle = this.buildParticle(bboxElement);
                result.add(new Object[]{particle, box});
            }
        }
        return result;
    }

    private XSDParticle buildParticle(XSDElementDeclaration declaration) {
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)declaration);
        particle.setMinOccurs(0);
        particle.setMaxOccurs(-1);
        return particle;
    }

    public Object getProperty(Object object, QName name) throws Exception {
        return null;
    }
}

