/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.aggregate.FeatureQueue;
import org.geotools.data.simple.SimpleFeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class QueueReader
implements SimpleFeatureReader {
    private FeatureQueue queue;
    private SimpleFeatureType target;
    private SimpleFeature next;

    public QueueReader(FeatureQueue queue, SimpleFeatureType target) {
        this.queue = queue;
        this.target = target;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.target;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.next != null && this.next != FeatureQueue.END_MARKER) {
            return true;
        }
        this.checkException();
        try {
            while (this.next == null || this.next == FeatureQueue.END_MARKER) {
                if (this.queue.isDone()) {
                    return false;
                }
                this.next = (SimpleFeature)this.queue.take();
                this.checkException();
            }
        }
        catch (InterruptedException ie) {
            throw new IOException("Error while waiting for next feature", ie);
        }
        return true;
    }

    void checkException() throws IOException {
        Exception e = this.queue.getException();
        if (e != null) {
            throw new IOException("Data retrieval failed", e);
        }
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException("No more features to be read");
        }
        this.checkException();
        SimpleFeature result = null;
        result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.queue.shutDown();
        while (!this.queue.isDone()) {
            this.queue.clear();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

