/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.data.DataUtilities;
import org.geotools.data.aggregate.FeatureCallable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class FeatureQueue
extends ArrayBlockingQueue<SimpleFeature> {
    private static final long serialVersionUID = -8717436655125657625L;
    static final SimpleFeature END_MARKER;
    Exception exception;
    ConcurrentHashMap<FeatureCallable, FeatureCallable> sources = new ConcurrentHashMap();

    public FeatureQueue(int sourceCount) {
        super(100);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        if (exception != null) {
            this.shutDown();
            this.exception = exception;
        }
    }

    public boolean isDone() {
        return this.sources.size() == 0 && this.size() == 0;
    }

    public synchronized void addSource(FeatureCallable source) {
        this.sources.put(source, source);
    }

    public void sourceComplete(FeatureCallable source) {
        this.sources.remove(source);
    }

    public void shutDown() {
        for (FeatureCallable fc : this.sources.keySet()) {
            fc.shutdown();
        }
    }

    static {
        try {
            SimpleFeatureType endMarkerType = DataUtilities.createType("END_MARKER", "id:String");
            END_MARKER = new SimpleFeatureImpl(new Object[]{"end"}, endMarkerType, CommonFactoryFinder.getFilterFactory(null).featureId("END_ID"), false);
        }
        catch (SchemaException e) {
            throw new RuntimeException("Unexpected error occurred creating the end marker", e);
        }
    }
}

