/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.aggregate.AggregateTypeConfiguration;
import org.geotools.data.aggregate.AggregatingDataStore;
import org.geotools.data.aggregate.FeatureQueue;
import org.geotools.data.aggregate.MissingPropertiesEraser;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

class FeatureCallable
implements Callable<Void> {
    static final Logger LOGGER = Logging.getLogger(FeatureCallable.class);
    Query query;
    AggregatingDataStore store;
    Name storeName;
    String typeName;
    FeatureQueue queue;
    SimpleFeatureBuilder builder;
    private boolean stopped = false;

    public FeatureCallable(AggregatingDataStore store, Query query, Name storeName, String typeName, FeatureQueue queue, SimpleFeatureType target) {
        this.store = store;
        this.query = query;
        this.storeName = storeName;
        this.typeName = typeName;
        this.queue = queue;
        this.builder = new SimpleFeatureBuilder(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        FeatureIterator fi = null;
        int storeId = -1;
        try {
            DataStore ds = this.store.getStore(this.storeName, this.store.isTolerant());
            AggregateTypeConfiguration config = this.store.getConfigurations().get(this.builder.getFeatureType().getTypeName());
            storeId = config.getStoreIndex(this.storeName);
            SimpleFeatureSource source = ds.getFeatureSource(this.typeName);
            Query q = new Query(this.query);
            q.setTypeName(this.typeName);
            q.setSortBy(null);
            Filter originalFilter = q.getFilter();
            if (originalFilter != null && !Filter.INCLUDE.equals(originalFilter)) {
                FilterAttributeExtractor extractor = new FilterAttributeExtractor();
                originalFilter.accept((FilterVisitor)extractor, null);
                Set<String> filterNames = extractor.getAttributeNameSet();
                Set<String> sourceNames = this.getSourceAttributes(source);
                if (!sourceNames.containsAll(filterNames)) {
                    MissingPropertiesEraser eraser = new MissingPropertiesEraser(sourceNames);
                    Filter erased = (Filter)originalFilter.accept((FilterVisitor)eraser, null);
                    q.setFilter(erased);
                }
            }
            this.fixupProperties(q, this.builder.getFeatureType(), this.getSourceAttributes(source));
            fi = source.getFeatures(q).features();
            while (fi.hasNext() && !this.stopped) {
                SimpleFeature feature = (SimpleFeature)fi.next();
                for (AttributeDescriptor ad : this.builder.getFeatureType().getAttributeDescriptors()) {
                    String attribute = ad.getLocalName();
                    Object attValue = feature.getAttribute(attribute);
                    if (attValue == null) continue;
                    this.builder.set(attribute, attValue);
                }
                String id = feature.getID();
                if (id.startsWith(this.typeName)) {
                    id = id.substring(this.typeName.length() + 1);
                }
                id = this.builder.getFeatureType().getTypeName() + "." + storeId + "." + id;
                SimpleFeature sf = this.builder.buildFeature(id);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Adding a new feature {0} from store {1}", new Object[]{sf, storeId});
                }
                this.queue.put(sf);
            }
        }
        catch (Exception e) {
            String message = "Failed to retrieve features on " + this.storeName + "/" + this.typeName;
            if (this.store.isTolerant()) {
                AggregatingDataStore.LOGGER.log(Level.WARNING, message, e);
                Void void_ = null;
                return void_;
            }
            this.queue.setException(e);
        }
        finally {
            LOGGER.log(Level.FINE, "Adding the end marker for store {0}", storeId);
            this.queue.sourceComplete(this);
            this.queue.put(FeatureQueue.END_MARKER);
            if (fi != null) {
                fi.close();
            }
        }
        return null;
    }

    void fixupProperties(Query q, SimpleFeatureType featureType, Set<String> sourceNames) {
        if (q.getPropertyNames() != null) {
            if (q.getPropertyNames().length > 0) {
                ArrayList<String> filtered = new ArrayList<String>();
                for (String name : q.getPropertyNames()) {
                    if (!sourceNames.contains(name)) continue;
                    filtered.add(name);
                }
                String[] filteredArray = filtered.toArray(new String[filtered.size()]);
                q.setPropertyNames(filteredArray);
            }
        } else {
            ArrayList<String> filtered = new ArrayList<String>();
            for (String name : sourceNames) {
                if (featureType.getDescriptor(name) == null) continue;
                filtered.add(name);
            }
            String[] filteredArray = filtered.toArray(new String[filtered.size()]);
            q.setPropertyNames(filteredArray);
        }
    }

    private Set<String> getSourceAttributes(SimpleFeatureSource source) {
        HashSet<String> result = new HashSet<String>();
        for (AttributeDescriptor ad : ((SimpleFeatureType)source.getSchema()).getAttributeDescriptors()) {
            result.add(ad.getLocalName());
        }
        return result;
    }

    public void shutdown() {
        this.stopped = true;
    }
}

