/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.aggregate.AggregatingDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.type.Name;

class CountCallable
implements Callable<Long> {
    Query query;
    AggregatingDataStore store;
    Name storeName;
    String typeName;

    public CountCallable(AggregatingDataStore store, Query query, Name storeName, String typeName) {
        this.store = store;
        this.query = query;
        this.storeName = storeName;
        this.typeName = typeName;
    }

    @Override
    public Long call() throws Exception {
        try {
            DataStore ds = this.store.getStore(this.storeName, this.store.isTolerant());
            SimpleFeatureSource source = ds.getFeatureSource(this.typeName);
            Query q = new Query(this.query);
            q.setTypeName(this.typeName);
            return source.getCount(q);
        }
        catch (Exception e) {
            String message = "Failed to count on " + this.storeName + "/" + this.typeName;
            if (this.store.isTolerant()) {
                AggregatingDataStore.LOGGER.log(Level.WARNING, message, e);
                return 0L;
            }
            throw new IOException(message, e);
        }
    }
}

