/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.aggregate.AggregatingDataStore;
import org.geotools.data.aggregate.FeatureCallable;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;

class BoundsCallable
implements Callable<ReferencedEnvelope> {
    static final Logger LOGGER = Logging.getLogger(FeatureCallable.class);
    Query query;
    AggregatingDataStore store;
    Name storeName;
    String typeName;

    public BoundsCallable(AggregatingDataStore store, Query query, Name storeName, String typeName) {
        this.store = store;
        this.query = query;
        this.storeName = storeName;
        this.typeName = typeName;
    }

    @Override
    public ReferencedEnvelope call() throws Exception {
        try {
            DataStore ds = this.store.getStore(this.storeName, this.store.isTolerant());
            SimpleFeatureSource source = ds.getFeatureSource(this.typeName);
            Query q = new Query(this.query);
            q.setTypeName(this.typeName);
            ReferencedEnvelope env = source.getBounds(q);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Retrieved bounds {0} form store {1}", new Object[]{env, this.storeName});
            }
            return env;
        }
        catch (Exception e) {
            String message = "Failed to get the bounds on " + this.storeName + "/" + this.typeName;
            if (this.store.isTolerant()) {
                AggregatingDataStore.LOGGER.log(Level.WARNING, message, e);
                return null;
            }
            throw new IOException(message, e);
        }
    }
}

