/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.aggregate.AggregateTypeConfiguration;
import org.geotools.data.aggregate.AggregatingDataStore;
import org.geotools.data.aggregate.BoundsCallable;
import org.geotools.data.aggregate.CountCallable;
import org.geotools.data.aggregate.FeatureCallable;
import org.geotools.data.aggregate.FeatureQueue;
import org.geotools.data.aggregate.QueueReader;
import org.geotools.data.aggregate.SourceType;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

class AggregatingFeatureSource
extends ContentFeatureSource {
    AggregateTypeConfiguration config;

    public AggregatingFeatureSource(ContentEntry entry, AggregatingDataStore store, AggregateTypeConfiguration config) {
        super(entry, null);
        this.config = config;
    }

    public AggregatingDataStore getStore() {
        return (AggregatingDataStore)this.getEntry().getDataStore();
    }

    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        AggregatingDataStore store = this.getStore();
        ArrayList<Future<ReferencedEnvelope>> allBounds = new ArrayList<Future<ReferencedEnvelope>>();
        for (SourceType st : this.config.getSourceTypes()) {
            Future<ReferencedEnvelope> future = store.submit(new BoundsCallable(store, query, st.getStoreName(), st.getTypeName()));
            allBounds.add(future);
        }
        ReferencedEnvelope result = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
        for (Future future : allBounds) {
            try {
                ReferencedEnvelope bound = (ReferencedEnvelope)((Object)future.get());
                if (bound == null) continue;
                Envelope env = new Envelope((Envelope)bound);
                result.expandToInclude(env);
            }
            catch (Exception e) {
                throw new IOException("Failed to get the envelope from a delegate store", e);
            }
        }
        if (result.isNull()) {
            return null;
        }
        return result;
    }

    @Override
    protected int getCountInternal(Query query) throws IOException {
        AggregatingDataStore store = this.getStore();
        ArrayList<Future<Long>> counts = new ArrayList<Future<Long>>();
        for (SourceType st : this.config.getSourceTypes()) {
            Query q = new Query(query);
            q.setMaxFeatures(Integer.MAX_VALUE);
            q.setStartIndex(0);
            Future<Long> future = store.submit(new CountCallable(store, q, st.getStoreName(), st.getTypeName()));
            counts.add(future);
        }
        long total = 0L;
        for (Future future : counts) {
            try {
                long count = (Long)future.get();
                if (count > 0L) {
                    total += count;
                    continue;
                }
                return -1;
            }
            catch (Exception e) {
                throw new IOException("Failed to count on a delegate store", e);
            }
        }
        return (int)total;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        try {
            Query psQuery = new Query(query);
            Name psName = this.config.getPrimarySourceType().getStoreName();
            psQuery.setTypeName(this.config.getPrimarySourceType().getTypeName());
            DataStore ps = this.getStore().getStore(psName, false);
            SimpleFeatureType target = (SimpleFeatureType)DataUtilities.createView(ps, psQuery).getSchema();
            target = this.retypeNameSchema(target);
            FeatureQueue queue = new FeatureQueue(this.config.getSourceTypes().size());
            AggregatingDataStore store = this.getStore();
            for (SourceType st : this.config.getSourceTypes()) {
                FeatureCallable fc = new FeatureCallable(store, query, st.getStoreName(), st.getTypeName(), queue, target);
                queue.addSource(fc);
                store.submit(fc);
            }
            QueueReader reader = new QueueReader(queue, target);
            return reader;
        }
        catch (SchemaException e) {
            throw new IOException("Failed to compute target feature type", e);
        }
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        Name ps = this.config.getPrimarySourceType().getStoreName();
        DataStore store = this.getStore().getStore(ps, false);
        SimpleFeatureType schema = store.getSchema(this.config.getPrimarySourceType().getTypeName());
        if (schema == null) {
            throw new IOException("Could not find feature type " + schema + " in the primary store");
        }
        schema = this.retypeNameSchema(schema);
        return schema;
    }

    private SimpleFeatureType retypeNameSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init(schema);
        tb.setName(this.config.getName());
        tb.setNamespaceURI(this.getStore().getNamespaceURI());
        schema = tb.buildFeatureType();
        return schema;
    }

    @Override
    protected boolean canFilter() {
        return true;
    }

    @Override
    protected boolean canRetype() {
        return true;
    }
}

