/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.TransformerException;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.Repository;
import org.geotools.data.aggregate.AggregateTypeConfiguration;
import org.geotools.data.aggregate.AggregateTypeEncoder;
import org.geotools.data.aggregate.AggregateTypeParser;
import org.geotools.data.aggregate.AggregatingDataStore;
import org.geotools.util.KVP;

public class AggregatingDataStoreFactory
extends AbstractDataStoreFactory {
    public static final DataAccessFactory.Param REPOSITORY_PARAM = new DataAccessFactory.Param("repository", (Class<?>)Repository.class, "The repository that will provide the store intances", true, (Object)null, (Map<String, ?>)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param STORES_PARAM = new DataAccessFactory.Param("stores", (Class<?>)String[].class, "List of data stores to connect to", false, (Object)null, (Map<String, ?>)new KVP(new Object[]{"element", String.class}));
    public static final DataAccessFactory.Param TOLERATE_CONNECTION_FAILURE = new DataAccessFactory.Param("tolerate connection failure", Boolean.class, "Is failure to connect to a store tolerated", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);
    public static final DataAccessFactory.Param PARALLELISM = new DataAccessFactory.Param("parallelism", Integer.class, "Number of allowed concurrent queries on the delegate stores (unlimited by default)", false, (Object)new Integer(-1));
    public static final DataAccessFactory.Param CONFIGURATION = new DataAccessFactory.Param("configuration", URL.class, "Location of the aggregated type configuration file", false, null);
    public static final DataAccessFactory.Param CONFIGURATION_XML = new DataAccessFactory.Param("configuration xml", String.class, "The aggregated type configuration, as a xml document in a string", false, null);

    @Override
    public String getDisplayName() {
        return "Aggregating data store";
    }

    @Override
    public String getDescription() {
        return "Aggregates homologous feature types from separate data stores";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{REPOSITORY_PARAM, NAMESPACE, CONFIGURATION, TOLERATE_CONNECTION_FAILURE, PARALLELISM};
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    @Override
    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        String configurationXml;
        Repository repository = this.lookup(REPOSITORY_PARAM, params, Repository.class);
        String[] stores = this.lookup(STORES_PARAM, params, String[].class);
        boolean tolerant = this.lookup(TOLERATE_CONNECTION_FAILURE, params, Boolean.class);
        String namespace = this.lookup(NAMESPACE, params, String.class);
        int parallelism = this.lookup(PARALLELISM, params, Integer.class);
        ExecutorService executor = parallelism <= 0 ? Executors.newCachedThreadPool() : Executors.newFixedThreadPool(parallelism);
        List<AggregateTypeConfiguration> configs = null;
        URL configuration = this.lookup(CONFIGURATION, params, URL.class);
        if (configuration != null) {
            configs = new AggregateTypeParser().parseConfigurations(configuration.openStream());
        }
        if ((configurationXml = this.lookup(CONFIGURATION_XML, params, String.class)) != null && !"".equals(configurationXml.trim())) {
            configs = new AggregateTypeParser().parseConfigurations(new ByteArrayInputStream(configurationXml.getBytes()));
        }
        AggregatingDataStore store = new AggregatingDataStore(repository, executor);
        store.setNamespaceURI(namespace);
        store.setTolerant(tolerant);
        if (stores != null) {
            store.autoConfigureStores(Arrays.asList(stores));
        }
        if (configs != null) {
            for (AggregateTypeConfiguration config : configs) {
                store.addType(config);
            }
        }
        return store;
    }

    public List<AggregateTypeConfiguration> parseConfiguration(String xml) throws IOException {
        if (xml != null && !"".equals(xml.trim())) {
            return new AggregateTypeParser().parseConfigurations(new ByteArrayInputStream(xml.getBytes()));
        }
        return null;
    }

    public String encodeConfiguration(List<AggregateTypeConfiguration> configs) throws IOException {
        try {
            AggregateTypeEncoder encoder = new AggregateTypeEncoder();
            encoder.setIndentation(2);
            return encoder.transform(configs);
        }
        catch (TransformerException e) {
            throw new IOException("Failed to encode the configuration back in xml", e);
        }
    }

    @Override
    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return this.createDataStore((Map)params);
    }

    <T> T lookup(DataAccessFactory.Param param, Map<String, Serializable> params, Class<T> target) throws IOException {
        Object result = param.lookUp(params);
        if (result == null) {
            return param.getDefaultValue();
        }
        return (T)result;
    }
}

