/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.geotools.data.DataStore;
import org.geotools.data.Repository;
import org.geotools.data.aggregate.AggregateTypeConfiguration;
import org.geotools.data.aggregate.AggregatingFeatureSource;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;

public class AggregatingDataStore
extends ContentDataStore {
    static final Logger LOGGER = Logging.getLogger(AggregatingDataStore.class);
    Repository repository;
    boolean tolerant;
    Map<String, AggregateTypeConfiguration> typeMap = new LinkedHashMap<String, AggregateTypeConfiguration>();
    ExecutorService executor;

    public AggregatingDataStore(Repository repository, ExecutorService executor) {
        this.repository = repository;
        this.executor = executor;
    }

    public boolean isTolerant() {
        return this.tolerant;
    }

    public void setTolerant(boolean tolerant) {
        this.tolerant = tolerant;
    }

    @Override
    protected List<Name> createTypeNames() throws IOException {
        ArrayList<Name> result = new ArrayList<Name>();
        for (String name : this.typeMap.keySet()) {
            result.add(new NameImpl(this.namespaceURI, name));
        }
        return result;
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        String name = entry.getName().getLocalPart();
        AggregateTypeConfiguration config = this.typeMap.get(name);
        if (config == null) {
            throw new IOException("Aggregating configuration for type " + name + " was not found");
        }
        return new AggregatingFeatureSource(entry, this, config);
    }

    public void autoConfigureStores(List<String> storeNames) throws IOException {
        if (storeNames == null || storeNames.size() == 0) {
            return;
        }
        LinkedHashMap<String, Set> allNames = new LinkedHashMap<String, Set>();
        for (String storeName : storeNames) {
            DataStore store = this.getStore(storeName, this.tolerant);
            if (store != null) {
                LinkedHashSet<String> typeNames = new LinkedHashSet<String>(Arrays.asList(store.getTypeNames()));
                allNames.put(storeName, typeNames);
                continue;
            }
            allNames.put(storeName, Collections.EMPTY_SET);
        }
        for (int i = 0; i < storeNames.size(); ++i) {
            String storeName;
            storeName = storeNames.get(i);
            Set baseNames = (Set)allNames.get(storeName);
            for (String baseName : baseNames) {
                AggregateTypeConfiguration config = new AggregateTypeConfiguration(baseName);
                config.addSourceType(storeName, baseName);
                for (int j = i + 1; j < storeNames.size(); ++j) {
                    String otherStore = storeNames.get(j);
                    if (!((Set)allNames.get(otherStore)).remove(baseName)) continue;
                    config.addSourceType(otherStore, baseName);
                }
                this.addType(config);
            }
        }
    }

    public void addType(AggregateTypeConfiguration config) throws IOException {
        try {
            this.typeMap.put(config.getName(), config);
            if (!this.tolerant) {
                this.getSchema(config.getName());
            }
            this.entries.remove(new NameImpl(this.namespaceURI, config.getName()));
        }
        catch (IOException e) {
            this.typeMap.remove(config.getName());
        }
    }

    public AggregateTypeConfiguration getConfiguration(String name) {
        return this.typeMap.get(name);
    }

    public AggregateTypeConfiguration removeType(String name) {
        AggregateTypeConfiguration config = this.typeMap.remove(name);
        if (config != null) {
            this.entries.remove(new NameImpl(this.namespaceURI, name));
        }
        return config;
    }

    public void resetConfiguration() {
        this.typeMap.clear();
        this.entries.clear();
    }

    public Map<String, AggregateTypeConfiguration> getConfigurations() {
        HashMap<String, AggregateTypeConfiguration> result = new HashMap<String, AggregateTypeConfiguration>();
        for (String key : this.typeMap.keySet()) {
            result.put(key, new AggregateTypeConfiguration(this.typeMap.get(key)));
        }
        return Collections.unmodifiableMap(result);
    }

    DataStore getStore(String storeName, boolean tolerant) throws IOException {
        Name name = AggregateTypeConfiguration.buildName(storeName);
        return this.getStore(name, tolerant);
    }

    DataStore getStore(Name name, boolean tolerant) throws IOException {
        DataStore store = null;
        Exception e = null;
        try {
            store = this.repository.dataStore(name);
        }
        catch (Exception ex) {
            e = ex;
        }
        if (store != null || tolerant) {
            return store;
        }
        throw new IOException("Could not locate store " + name, e);
    }

    <V> Future<V> submit(Callable<V> callable) {
        return this.executor.submit(callable);
    }
}

