/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.aggregate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.aggregate.SourceType;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.Name;

public class AggregateTypeConfiguration
implements Serializable {
    String name;
    List<SourceType> sourceTypes = new ArrayList<SourceType>();
    SourceType primarySource;

    public AggregateTypeConfiguration(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Feature type name cannot be null");
        }
        this.name = name;
    }

    public AggregateTypeConfiguration(String name, Name ... storeNames) {
        this(name);
        if (storeNames != null && storeNames.length > 0) {
            for (Name storeName : storeNames) {
                this.addSourceType(storeName, name);
            }
        }
    }

    public AggregateTypeConfiguration(String name, String ... storeNames) {
        this(name);
        if (storeNames != null && storeNames.length > 0) {
            for (String storeName : storeNames) {
                this.addSourceType(new NameImpl(storeName), name);
            }
        }
    }

    public AggregateTypeConfiguration(AggregateTypeConfiguration other) {
        this.copyFrom(other);
    }

    public void copyFrom(AggregateTypeConfiguration other) {
        this.name = other.name;
        this.sourceTypes.clear();
        this.sourceTypes.addAll(other.getSourceTypes());
        this.primarySource = other.primarySource;
    }

    public void addSourceType(Name storeName, String typeName) {
        SourceType sourceType = new SourceType(storeName, typeName);
        if (this.sourceTypes.isEmpty()) {
            this.primarySource = sourceType;
        }
        this.sourceTypes.add(sourceType);
    }

    public void addSourceType(String localName, String typeName) {
        Name storeName = AggregateTypeConfiguration.buildName(localName);
        this.addSourceType(storeName, typeName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SourceType> getSourceTypes() {
        return this.sourceTypes;
    }

    public List<SourceType> getSourceTypes(Name store) {
        ArrayList<SourceType> result = new ArrayList<SourceType>();
        for (SourceType st : this.sourceTypes) {
            if (!st.getStoreName().equals((Object)store)) continue;
            result.add(st);
        }
        return result;
    }

    public SourceType getPrimarySourceType() {
        return this.primarySource;
    }

    public void setPrimarySourceType(SourceType primary) {
        if (!this.sourceTypes.contains(primary)) {
            this.sourceTypes.add(0, primary);
        }
        this.primarySource = primary;
    }

    public String toString() {
        return "AggregateTypeConfiguration [name=" + this.name + ", storeMap=" + this.sourceTypes + ", primarySource=" + this.primarySource + "]";
    }

    int getStoreIndex(Name storeName) {
        int i = 0;
        for (SourceType st : this.sourceTypes) {
            if (st.getStoreName().equals((Object)storeName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static Name buildName(String name) {
        int idx = name.indexOf(":");
        if (idx == -1) {
            return new NameImpl(name);
        }
        String ns = name.substring(0, idx);
        String local = name.substring(idx + 1);
        return new NameImpl(ns, local);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.primarySource == null ? 0 : this.primarySource.hashCode());
        result = 31 * result + (this.sourceTypes == null ? 0 : this.sourceTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateTypeConfiguration other = (AggregateTypeConfiguration)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.primarySource == null ? other.primarySource != null : !this.primarySource.equals(other.primarySource)) {
            return false;
        }
        return !(this.sourceTypes == null ? other.sourceTypes != null : !this.sourceTypes.equals(other.sourceTypes));
    }
}

