/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0.parsers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.util.logging.Logging;
import org.geotools.xml.BindingWalkerFactory;
import org.geotools.xml.Configuration;
import org.geotools.xml.SchemaIndex;
import org.geotools.xml.Schemas;
import org.geotools.xml.impl.BindingFactoryImpl;
import org.geotools.xml.impl.BindingLoader;
import org.geotools.xml.impl.BindingWalkerFactoryImpl;
import org.geotools.xml.impl.NamespaceSupportWrapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.helpers.NamespaceSupport;

public class EmfAppSchemaParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.wfs");

    public static SimpleFeatureType parseSimpleFeatureType(QName featureName, URL schemaLocation, CoordinateReferenceSystem crs, Configuration wfsConfiguration, Map<String, String> mappedURIs, Map<QName, Class<?>> mappedBindings, boolean ignoreMissingElementDeclaration) throws IOException {
        return EmfAppSchemaParser.parseSimpleFeatureType(wfsConfiguration, featureName, schemaLocation, crs, mappedURIs, mappedBindings, ignoreMissingElementDeclaration);
    }

    public static SimpleFeatureType parseSimpleFeatureType(Configuration wfsConfiguration, QName featureName, URL schemaLocation, CoordinateReferenceSystem crs, Map<String, String> mappedURIs, Map<QName, Class<?>> mappedBindings, boolean ignoreMissingElementDeclaration) throws IOException {
        SimpleFeatureType realType = EmfAppSchemaParser.parse(wfsConfiguration, featureName, schemaLocation, crs, mappedURIs, mappedBindings, ignoreMissingElementDeclaration);
        SimpleFeatureType subsetType = EmfAppSchemaParser.toSimpleFeatureType((FeatureType)realType);
        return subsetType;
    }

    public static SimpleFeatureType toSimpleFeatureType(FeatureType realType) throws DataSourceException {
        SimpleFeatureType subsetType;
        Collection descriptors = realType.getDescriptors();
        List attributes = new ArrayList(descriptors);
        ArrayList<String> simpleProperties = new ArrayList<String>();
        HashSet<String> ignoreList = new HashSet<String>(Arrays.asList(GML.location.getLocalPart(), GML.metaDataProperty.getLocalPart(), GML.description.getLocalPart(), GML.name.getLocalPart(), GML.boundedBy.getLocalPart()));
        if (attributes.size() > ignoreList.size()) {
            HashSet<String> firstAtts = new HashSet<String>();
            for (int i = 0; i < ignoreList.size(); ++i) {
                firstAtts.add(((PropertyDescriptor)attributes.get(i)).getName().getLocalPart());
            }
            if (ignoreList.equals(firstAtts)) {
                attributes = attributes.subList(ignoreList.size(), attributes.size());
            }
        }
        for (PropertyDescriptor descriptor : attributes) {
            Class binding = descriptor.getType().getBinding();
            int maxOccurs = descriptor.getMaxOccurs();
            Name name = descriptor.getName();
            if ("http://www.opengis.net/gml".equals(name.getNamespaceURI()) || maxOccurs > 1 || Object.class.equals((Object)binding)) {
                LOGGER.fine("Ignoring multivalued or complex property " + name + " on feature type " + realType.getName());
                continue;
            }
            simpleProperties.add(((AttributeDescriptor)descriptor).getLocalName());
        }
        String[] properties = simpleProperties.toArray(new String[simpleProperties.size()]);
        try {
            subsetType = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)realType), (String[])properties);
        }
        catch (SchemaException e) {
            throw new DataSourceException(e);
        }
        return subsetType;
    }

    public static SimpleFeatureType parse(Configuration wfsConfiguration, QName featureName, URL schemaLocation, CoordinateReferenceSystem crs, Map<String, String> mappedURIs, Map<QName, Class<?>> mappedBindings, boolean ignoreMissingElementDeclaration) throws IOException {
        XSDElementDeclaration elementDecl = EmfAppSchemaParser.parseFeatureType(featureName, schemaLocation, mappedURIs, ignoreMissingElementDeclaration);
        Map bindings = wfsConfiguration.setupBindings();
        if (mappedBindings != null) {
            bindings.putAll(mappedBindings);
        }
        BindingLoader bindingLoader = new BindingLoader(bindings);
        MutablePicoContainer context = wfsConfiguration.setupContext((MutablePicoContainer)new DefaultPicoContainer());
        NamespaceSupport namespaces = new NamespaceSupport();
        context.registerComponentInstance((Object)namespaces);
        context.registerComponentInstance((Object)new NamespaceSupportWrapper(namespaces));
        BindingFactoryImpl bindingFactory = new BindingFactoryImpl(bindingLoader);
        context.registerComponentInstance((Object)bindingFactory);
        BindingWalkerFactoryImpl bwFactory = new BindingWalkerFactoryImpl(bindingLoader, context);
        context.registerComponentInstance((Object)bwFactory);
        try {
            SimpleFeatureType featureType = GML3ParsingUtils.featureType((XSDElementDeclaration)elementDecl, (BindingWalkerFactory)bwFactory);
            if (crs != null) {
                SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
                builder.setName(featureType.getName());
                builder.setAbstract(featureType.isAbstract());
                builder.setDescription(featureType.getDescription());
                if (featureType.getSuper() instanceof SimpleFeatureType) {
                    builder.setSuperType((SimpleFeatureType)featureType.getSuper());
                }
                List attributes = featureType.getAttributeDescriptors();
                GeometryDescriptor defaultGeometry = featureType.getGeometryDescriptor();
                for (AttributeDescriptor descriptor : attributes) {
                    if (descriptor instanceof GeometryDescriptor) {
                        String name = descriptor.getLocalName();
                        Class binding = descriptor.getType().getBinding();
                        builder.add(name, binding, crs);
                        continue;
                    }
                    builder.add(descriptor);
                }
                if (defaultGeometry != null) {
                    builder.setDefaultGeometry(defaultGeometry.getLocalName());
                }
                featureType = builder.buildFeatureType();
            }
            return featureType;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String msg = "Error parsing feature type for " + featureName + " from " + schemaLocation.toExternalForm();
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    private static XSDElementDeclaration parseFeatureType(QName featureTypeName, URL schemaLocation, Map<String, String> mappedURIs, boolean ignoreMissingElementDeclaration) throws DataSourceException {
        SchemaIndex schemaIndex;
        String namespaceURI = featureTypeName.getNamespaceURI();
        if (mappedURIs.containsKey(namespaceURI)) {
            namespaceURI = mappedURIs.get(namespaceURI);
            featureTypeName = new QName(namespaceURI, featureTypeName.getLocalPart());
        }
        String uri = schemaLocation.toExternalForm();
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration(namespaceURI, uri);
        try {
            schemaIndex = Schemas.findSchemas((Configuration)configuration);
        }
        catch (RuntimeException e) {
            throw new DataSourceException("Error parsing feature type for " + featureTypeName, e);
        }
        XSDElementDeclaration elementDeclaration = schemaIndex.getElementDeclaration(featureTypeName);
        schemaIndex.destroy();
        if (elementDeclaration == null && !ignoreMissingElementDeclaration) {
            throw new DataSourceException("No XSDElementDeclaration found for " + featureTypeName);
        }
        return elementDeclaration;
    }
}

