/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.imageio;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.FileSetManager;
import org.geotools.coverage.io.CoverageSourceDescriptor;
import org.geotools.coverage.io.catalog.CoverageSlice;
import org.geotools.coverage.io.catalog.CoverageSlicesCatalog;
import org.geotools.data.Query;
import org.opengis.feature.type.Name;

public abstract class GeoSpatialImageReader
extends ImageReader
implements FileSetManager {
    private CoverageSlicesCatalog slicesCatalog;
    protected int numImages = -1;
    private String auxiliaryFilesPath = null;

    protected GeoSpatialImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.ignoreMetadata) {
            return null;
        }
        throw new UnsupportedOperationException("ImageMetadata are not supported for this ImageReader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        try {
            if (this.slicesCatalog != null) {
                this.slicesCatalog.dispose();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.slicesCatalog = null;
        }
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("getStreamMetadata is not supported");
    }

    protected void checkImageIndex(int imageIndex) {
        if (imageIndex < 0 || imageIndex >= this.numImages) {
            throw new IndexOutOfBoundsException("Invalid imageIndex. It should " + (this.numImages > 0 ? "belong the range [0," + (this.numImages - 1) : "be 0"));
        }
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return this.numImages;
    }

    public abstract Collection<Name> getCoveragesNames();

    public abstract int getCoveragesNumber();

    public abstract CoverageSourceDescriptor getCoverageDescriptor(Name var1);

    protected void setCatalog(CoverageSlicesCatalog catalog) {
        if (this.slicesCatalog != null) {
            this.slicesCatalog.dispose();
        }
        this.slicesCatalog = catalog;
    }

    public List<Integer> getImageIndex(Query filterQuery) throws IOException {
        List<CoverageSlice> descs = this.slicesCatalog.getGranules(filterQuery);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (CoverageSlice desc : descs) {
            Integer index = (Integer)desc.getOriginator().getAttribute("imageindex");
            indexes.add(index);
        }
        return indexes;
    }

    public String getAuxiliaryFilesPath() {
        return this.auxiliaryFilesPath;
    }

    public void setAuxiliaryFilesPath(String auxiliaryFilesPath) {
        this.auxiliaryFilesPath = auxiliaryFilesPath;
    }

    public CoverageSlicesCatalog getCatalog() {
        return this.slicesCatalog;
    }

    protected void initCatalog(File parentLocation, String databaseName) throws IOException {
        this.slicesCatalog = new CoverageSlicesCatalog(databaseName, parentLocation);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

