/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;

public class EnumMeasure<V extends Enum<V>>
extends Measure<V, Dimensionless> {
    private static final long serialVersionUID = 2403097126807167994L;
    private V value;

    private EnumMeasure(V value) {
        this.value = value;
    }

    public double doubleValue(Unit<Dimensionless> unit) {
        return ((Enum)this.value).ordinal();
    }

    public Unit<Dimensionless> getUnit() {
        return Unit.ONE;
    }

    public V getValue() {
        return this.value;
    }

    public Measure<V, Dimensionless> to(Unit<Dimensionless> unit) {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : ((Enum)this.value).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EnumMeasure other = (EnumMeasure)((Object)obj);
        return !(this.value == null ? other.value != null : !((Enum)this.value).equals(other.value));
    }

    public static <E extends Enum<E>> EnumMeasure<E> valueOf(E enumeration) {
        return new EnumMeasure<E>(enumeration);
    }

    public static <E extends Enum<E>> List<Measure<E, Dimensionless>> valueOf(Class<E> elementType) {
        return EnumMeasure.valueOf(EnumSet.allOf(elementType));
    }

    public static <E extends Enum<E>> List<Measure<E, Dimensionless>> valueOf(EnumSet<E> set) {
        ArrayList<Measure<EnumMeasure<Enum>, Dimensionless>> list = new ArrayList<Measure<EnumMeasure<Enum>, Dimensionless>>();
        for (Enum entry : set) {
            list.add(new EnumMeasure<Enum>(entry));
        }
        return list;
    }
}

