/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range.impl;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;
import javax.media.jai.IHSColorSpace;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.io.range.Axis;
import org.geotools.coverage.io.range.impl.BandIndexMeasure;
import org.geotools.feature.NameImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.util.InternationalString;

public class DimensionlessAxis
implements Axis<String, Dimensionless> {
    private String[] bandsKeys = null;
    private Name name = null;
    private InternationalString description;

    public static DimensionlessAxis createFromRenderedImage(RenderedImage raster) {
        if (raster == null) {
            throw new IllegalArgumentException("Provided null input image");
        }
        ColorModel cm = raster.getColorModel();
        if (cm == null) {
            throw new IllegalArgumentException("Provided input image with null color model");
        }
        SampleModel sm = raster.getSampleModel();
        if (sm == null) {
            throw new IllegalArgumentException("Provided input image with null SampleModel");
        }
        ColorInterpretation firstBandCI = TypeMap.getColorInterpretation((ColorModel)cm, (int)0);
        if (firstBandCI == ColorInterpretation.CYAN_BAND) {
            if (sm.getNumBands() == 3) {
                return new DimensionlessAxis(Arrays.asList("CYAN", "MAGENTA", "YELLOW"), (Name)new NameImpl("CMY-AXIS"), (InternationalString)new SimpleInternationalString("Axis for CMY bands"));
            }
            return new DimensionlessAxis(Arrays.asList("CYAN", "MAGENTA", "YELLOW", "BLACK"), (Name)new NameImpl("CMYK-AXIS"), (InternationalString)new SimpleInternationalString("Axis for CMYK bands"));
        }
        if (firstBandCI == ColorInterpretation.HUE_BAND) {
            return new DimensionlessAxis(Arrays.asList("HUE", "SATURATION", "VALUE"), (Name)new NameImpl("HSV-AXIS"), (InternationalString)new SimpleInternationalString("Axis for HSV bands"));
        }
        if (firstBandCI == ColorInterpretation.RED_BAND) {
            return new DimensionlessAxis(Arrays.asList("RED", "GREEN", "BLUE", "ALPHA"), (Name)new NameImpl("RGBA-AXIS"), (InternationalString)new SimpleInternationalString("Axis for RGBA bands"));
        }
        if (firstBandCI == ColorInterpretation.PALETTE_INDEX) {
            return new DimensionlessAxis(Arrays.asList("PALETTE_INDEX"), (Name)new NameImpl("PALETTE_INDEX-AXIS"), (InternationalString)new SimpleInternationalString("Axis for PALETTE INDEX bands"));
        }
        if (firstBandCI == ColorInterpretation.GRAY_INDEX) {
            if (sm.getNumBands() == 2) {
                return new DimensionlessAxis(Arrays.asList("GRAY", "ALPHA"), (Name)new NameImpl("GA-AXIS"), (InternationalString)new SimpleInternationalString("Axis for GRAY-ALPHA bands"));
            }
            return new DimensionlessAxis(Arrays.asList("GRAY"), (Name)new NameImpl("GRAY-AXIS"), (InternationalString)new SimpleInternationalString("Axis for GRAY bands"));
        }
        ColorSpace cs = cm.getColorSpace();
        if (cs instanceof IHSColorSpace) {
            return new DimensionlessAxis(Arrays.asList("INTENSITY", "HUE", "SATURATION"), (Name)new NameImpl("IHS-AXIS"), (InternationalString)new SimpleInternationalString("Axis for IHS bands"));
        }
        switch (cs.getType()) {
            case 3: {
                return new DimensionlessAxis(Arrays.asList("LUMA", "CHROMA-A", "CHROMA-B"), (Name)new NameImpl("YCbCr-AXIS"), (InternationalString)new SimpleInternationalString("Axis for YCbCr bands"));
            }
            case 2: {
                return new DimensionlessAxis(Arrays.asList("LIGHTNESS", "U", "V"), (Name)new NameImpl("LUV-AXIS"), (InternationalString)new SimpleInternationalString("Axis for LUV bands"));
            }
            case 1: {
                return new DimensionlessAxis(Arrays.asList("LIGHTNESS", "A", "B"), (Name)new NameImpl("LAB-AXIS"), (InternationalString)new SimpleInternationalString("Axis for LAB bands"));
            }
            case 8: {
                return new DimensionlessAxis(Arrays.asList("HUE", "LIGHTNESS", "SATURATION"), (Name)new NameImpl("HLS-AXIS"), (InternationalString)new SimpleInternationalString("Axis for HLS bands"));
            }
            case 1001: {
                return new DimensionlessAxis(Arrays.asList("X", "Y", "Z"), (Name)new NameImpl("XYZ-AXIS"), (InternationalString)new SimpleInternationalString("Axis for XYZ bands"));
            }
        }
        return null;
    }

    public DimensionlessAxis(int bandsNumber, Name name, InternationalString description) {
        String[] bandsKeys = new String[bandsNumber];
        for (int i = 0; i < bandsNumber; ++i) {
            bandsKeys[i] = Integer.toString(i);
        }
        this.init(bandsKeys, name, description);
    }

    public DimensionlessAxis(String[] bands, Name name, InternationalString description) {
        this.init(bands, name, description);
    }

    public DimensionlessAxis(List<String> bandsKeys, Name name, InternationalString description) {
        if (bandsKeys == null || bandsKeys.isEmpty()) {
            throw new IllegalArgumentException("Specified band keys list is invalid");
        }
        this.init(bandsKeys.toArray(new String[bandsKeys.size()]), name, description);
    }

    private void init(String[] bandsKeys, Name name, InternationalString description) {
        this.name = name;
        this.description = description;
        this.bandsKeys = bandsKeys;
    }

    @Override
    public SingleCRS getCoordinateReferenceSystem() {
        return null;
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    public BandIndexMeasure getKey(int keyIndex) {
        return new BandIndexMeasure(keyIndex, this.bandsKeys[keyIndex]);
    }

    @Override
    public List<BandIndexMeasure> getKeys() {
        ArrayList<BandIndexMeasure> list = new ArrayList<BandIndexMeasure>(this.bandsKeys.length);
        int i = 0;
        for (String band : this.bandsKeys) {
            list.add(new BandIndexMeasure(i++, band));
        }
        return list;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public int getNumKeys() {
        return this.bandsKeys.length;
    }

    @Override
    public Unit<Dimensionless> getUnitOfMeasure() {
        return Unit.ONE;
    }
}

