/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.geotools.coverage.io.range.Axis;
import org.geotools.feature.NameImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.util.InternationalString;

public class DefaultAxis<V, Q extends Quantity>
implements Axis<V, Q> {
    private SingleCRS crs;
    private InternationalString description;
    private List<Measure<V, Q>> keys;
    private Name name;
    private Unit<Q> unit;

    public DefaultAxis(String name, Measure<V, Q> key, Unit<Q> unit) {
        this((Name)new NameImpl(name), (InternationalString)new SimpleInternationalString(name), Collections.singletonList(key), unit, null);
    }

    public DefaultAxis(String name, List<Measure<V, Q>> keys, Unit<Q> unit) {
        this((Name)new NameImpl(name), (InternationalString)new SimpleInternationalString(name), keys, unit, null);
    }

    public DefaultAxis(Name name, InternationalString description, List<Measure<V, Q>> keys, Unit<Q> unit) {
        this(name, description, keys, unit, null);
    }

    public DefaultAxis(Name name, InternationalString description, List<Measure<V, Q>> keys, Unit<Q> unit, SingleCRS crs) {
        this.name = name;
        this.unit = unit;
        this.description = description;
        this.keys = new ArrayList<Measure<V, Q>>(keys);
        this.crs = crs;
    }

    @Override
    public SingleCRS getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public Measure<V, Q> getKey(int keyIndex) {
        return this.keys.get(keyIndex);
    }

    @Override
    public List<? extends Measure<V, Q>> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public int getNumKeys() {
        return this.keys.size();
    }

    @Override
    public Unit<Q> getUnitOfMeasure() {
        return this.unit;
    }
}

