/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;
import org.opengis.util.CodeList;

public class CodeMeasure<V extends CodeList<V>>
extends Measure<V, Dimensionless> {
    private static final long serialVersionUID = 2403097126807167994L;
    private V value;

    private CodeMeasure(V value) {
        this.value = value;
    }

    public double doubleValue(Unit<Dimensionless> unit) {
        return this.value.ordinal();
    }

    public Unit<Dimensionless> getUnit() {
        return Unit.ONE;
    }

    public V getValue() {
        return this.value;
    }

    public Measure<V, Dimensionless> to(Unit<Dimensionless> unit) {
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CodeMeasure other = (CodeMeasure)((Object)obj);
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static <C extends CodeList<C>> Measure<C, Dimensionless> valueOf(C code) {
        return new CodeMeasure<C>(code);
    }

    public static <C extends CodeList<C>> List<Measure<C, Dimensionless>> valueOf(Collection<C> codes) {
        ArrayList<Measure<C, Dimensionless>> list = new ArrayList<Measure<C, Dimensionless>>();
        for (CodeList entry : codes) {
            list.add(new CodeMeasure<CodeList>(entry));
        }
        return list;
    }

    public static <C extends CodeList<C>> List<Measure<C, Dimensionless>> valueOf(C[] codes) {
        return CodeMeasure.valueOf(Arrays.asList(codes));
    }
}

