/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.range.impl;

import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.converter.ConversionException;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;

public class BandIndexMeasure
extends Measure<String, Dimensionless>
implements Measurable<Dimensionless> {
    private static final long serialVersionUID = 3895010709415779953L;
    private Long index = null;
    private String bandMnemonic = null;

    public BandIndexMeasure(int index, String bandMnemonic) {
        this.index = index;
        this.bandMnemonic = bandMnemonic != null ? bandMnemonic : Long.toString(this.index);
    }

    public double doubleValue(Unit<Dimensionless> value) {
        return this.index.longValue();
    }

    public long longValue(Unit<Dimensionless> value) throws ArithmeticException {
        return this.index;
    }

    public int compareTo(Measurable<Dimensionless> o) {
        return this.index.compareTo(o.longValue(Unit.ONE));
    }

    public Unit<Dimensionless> getUnit() {
        return Unit.ONE;
    }

    public String getValue() {
        return this.bandMnemonic;
    }

    public Measure<String, Dimensionless> to(Unit<Dimensionless> target) {
        if (target.isCompatible(Unit.ONE)) {
            return new BandIndexMeasure(this.index.intValue(), this.bandMnemonic);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("Unable to perform requested conversion");
        buffer.append("\nsource UoM:").append("  ").append(Unit.ONE.toString());
        buffer.append("\ntarget UoM:").append("  ").append(target.toString());
        throw new ConversionException(buffer.toString());
    }
}

