/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.Driver;
import org.geotools.data.Parameter;
import org.geotools.factory.Hints;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class DefaultDriver
implements Driver {
    private final EnumSet<Driver.DriverCapabilities> driverCapabilities;
    private String name;
    private InternationalString description;
    private InternationalString title;
    private Map<RenderingHints.Key, ?> implementationHints;
    private Map<String, Parameter<?>> connectParameterInfo;
    private Map<String, Parameter<?>> createParameterInfo;
    private Map<String, Parameter<?>> deleteParameterInfo;

    protected DefaultDriver(String name, String description, String title, EnumSet<Driver.DriverCapabilities> driverCapabilities, Hints implementationHints) {
        Utilities.ensureNonNull((String)"name", (Object)name);
        Utilities.ensureNonNull((String)"description", (Object)description);
        Utilities.ensureNonNull((String)"title", (Object)title);
        Utilities.ensureNonNull((String)"driverCapabilities", driverCapabilities);
        this.driverCapabilities = driverCapabilities.clone();
        this.name = name;
        this.description = new SimpleInternationalString(description);
        this.title = new SimpleInternationalString(title);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InternationalString getTitle() {
        return this.title;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return this.implementationHints;
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public boolean canAccess(Driver.DriverCapabilities operation, Map<String, Serializable> params) {
        if (!this.getDriverCapabilities().contains((Object)operation)) {
            throw new UnsupportedOperationException("Operation " + (Object)((Object)operation) + " is not supported by this driver");
        }
        switch (operation) {
            case CONNECT: {
                return this.canConnect(params);
            }
            case DELETE: {
                return this.canDelete(params);
            }
            case CREATE: {
                return this.canCreate(params);
            }
        }
        throw new IllegalArgumentException("Operation " + (Object)((Object)operation) + " uknknown ");
    }

    @Override
    public CoverageAccess access(Driver.DriverCapabilities operation, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        if (!this.getDriverCapabilities().contains((Object)operation)) {
            throw new UnsupportedOperationException("Operation " + (Object)((Object)operation) + " is not supported by this driver");
        }
        switch (operation) {
            case CONNECT: {
                return this.connect(params, hints, listener);
            }
            case DELETE: {
                return this.delete(params, hints, listener);
            }
            case CREATE: {
                return this.create(params, hints, listener);
            }
        }
        throw new IllegalArgumentException("Operation " + (Object)((Object)operation) + " uknknown ");
    }

    protected synchronized Map<String, Parameter<?>> getConnectParameterInfo() {
        if (this.connectParameterInfo == null) {
            this.connectParameterInfo = this.defineConnectParameterInfo();
            if (this.connectParameterInfo == null) {
                this.connectParameterInfo = Collections.emptyMap();
            }
        }
        return this.connectParameterInfo;
    }

    protected synchronized Map<String, Parameter<?>> getDeleteParameterInfo() {
        if (this.deleteParameterInfo == null) {
            this.deleteParameterInfo = this.defineDeleteParameterInfo();
            if (this.deleteParameterInfo == null) {
                this.deleteParameterInfo = Collections.emptyMap();
            }
        }
        return this.deleteParameterInfo;
    }

    protected synchronized Map<String, Parameter<?>> getCreateParameterInfo() {
        if (this.createParameterInfo == null) {
            this.createParameterInfo = this.defineCreateParameterInfo();
            if (this.createParameterInfo == null) {
                this.createParameterInfo = Collections.emptyMap();
            }
        }
        return this.createParameterInfo;
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo(Driver.DriverCapabilities operation) {
        switch (operation) {
            case CONNECT: {
                return this.getConnectParameterInfo();
            }
            case DELETE: {
                return this.getDeleteParameterInfo();
            }
            case CREATE: {
                return this.getCreateParameterInfo();
            }
        }
        throw new IllegalArgumentException("Operation " + (Object)((Object)operation) + " uknknown ");
    }

    protected boolean canConnect(Map<String, Serializable> params) {
        return false;
    }

    protected boolean canCreate(Map<String, Serializable> params) {
        return false;
    }

    protected boolean canDelete(Map<String, Serializable> params) {
        return false;
    }

    protected CoverageAccess connect(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not currently implemented");
    }

    protected CoverageAccess create(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not currently implemented");
    }

    protected Map<String, Parameter<?>> defineConnectParameterInfo() {
        return Collections.emptyMap();
    }

    protected Map<String, Parameter<?>> defineCreateParameterInfo() {
        return Collections.emptyMap();
    }

    protected Map<String, Parameter<?>> defineDeleteParameterInfo() {
        return Collections.emptyMap();
    }

    protected CoverageAccess delete(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not currently implemented");
    }

    @Override
    public EnumSet<Driver.DriverCapabilities> getDriverCapabilities() {
        return this.driverCapabilities;
    }

    @Override
    public boolean isAvailable() {
        return false;
    }
}

