/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.CoverageSource;
import org.geotools.coverage.io.CoverageStore;
import org.geotools.coverage.io.Driver;
import org.geotools.coverage.io.metadata.MetadataNode;
import org.geotools.data.Parameter;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.Hints;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

public class DefaultCoverageAccess
implements CoverageAccess {
    protected final Driver driver;
    protected final EnumSet<CoverageAccess.AccessType> allowedAccessTypes;
    protected final Map<String, Parameter<?>> accessParameters = new HashMap();
    protected final Map<String, Serializable> connectionParameters = new HashMap<String, Serializable>();
    protected List<Name> names = null;

    public DefaultCoverageAccess(Driver driver, EnumSet<CoverageAccess.AccessType> allowedAccessTypes, Map<String, Parameter<?>> accessParams, Map<String, Serializable> connectionParameters) {
        this.driver = driver;
        this.allowedAccessTypes = allowedAccessTypes.clone();
        this.accessParameters.putAll(accessParams);
        if (connectionParameters != null) {
            this.connectionParameters.putAll(connectionParameters);
        }
    }

    @Override
    public CoverageSource access(Name name, Map<String, Serializable> params, CoverageAccess.AccessType accessType, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not implemented");
    }

    @Override
    public boolean canCreate(Name name, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        return false;
    }

    @Override
    public boolean canDelete(Name name, Map<String, Serializable> params, Hints hints) throws IOException {
        return false;
    }

    @Override
    public CoverageStore create(Name name, Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        throw new UnsupportedOperationException("Operation not implemented");
    }

    @Override
    public boolean delete(Name name, Map<String, Serializable> params, Hints hints) throws IOException {
        return false;
    }

    @Override
    public Map<String, Parameter<?>> getAccessParameterInfo(CoverageAccess.AccessType accessType) {
        return Collections.unmodifiableMap(this.accessParameters);
    }

    @Override
    public Map<String, Serializable> getConnectParameters() {
        return Collections.unmodifiableMap(this.connectionParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCoveragesNumber(ProgressListener listener) {
        if (listener == null) {
            listener = new NullProgressListener();
        }
        listener.started();
        try {
            int n = this.names.size();
            return n;
        }
        finally {
            listener.complete();
        }
    }

    @Override
    public ServiceInfo getInfo(ProgressListener listener) {
        throw new UnsupportedOperationException("Operation not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Name> getNames(ProgressListener listener) {
        if (listener == null) {
            listener = new NullProgressListener();
        }
        listener.started();
        try {
            List<Name> list = Collections.unmodifiableList(this.names);
            return list;
        }
        finally {
            listener.complete();
        }
    }

    @Override
    public MetadataNode getStorageMetadata(String metadataDomain) {
        throw new UnsupportedOperationException("Operation not implemented");
    }

    @Override
    public Set<String> getStorageMetadataDomains() {
        return Collections.emptySet();
    }

    @Override
    public Set<CoverageAccess.AccessType> getSupportedAccessTypes() {
        return this.allowedAccessTypes;
    }

    @Override
    public boolean isCreateSupported() {
        return false;
    }

    @Override
    public boolean isDeleteSupported() {
        return false;
    }

    @Override
    public Driver getDriver() {
        return this.driver;
    }

    @Override
    public void dispose() {
    }
}

