/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.impl;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.io.CoverageAccess;
import org.geotools.coverage.io.Driver;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.util.ProgressListener;

public class CoverageIO {
    private static final Logger LOGGER = Logging.getLogger(CoverageIO.class);
    private static FactoryRegistry REGISTRY;

    private CoverageIO() {
    }

    public static boolean canConnect(Map<String, Serializable> params) {
        for (Driver driver : CoverageIO.getAvailableDrivers()) {
            boolean canProcess = false;
            try {
                canProcess = driver.canAccess(Driver.DriverCapabilities.CONNECT, params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error asking " + driver.getTitle() + " if it can process request", t);
                continue;
            }
            if (!canProcess) continue;
            boolean isAvailable = false;
            try {
                isAvailable = driver.isAvailable();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error when checking if " + driver.getTitle() + " is available", t);
                continue;
            }
            if (!isAvailable) continue;
            try {
                if (!driver.canAccess(Driver.DriverCapabilities.CONNECT, params)) continue;
                return true;
            }
            catch (Exception couldNotConnect) {
                LOGGER.log(Level.WARNING, driver.getTitle() + " could not connect", couldNotConnect);
            }
        }
        return false;
    }

    public static CoverageAccess connect(Map<String, Serializable> params, Hints hints, ProgressListener listener) throws IOException {
        for (Driver driver : CoverageIO.getAvailableDrivers()) {
            boolean canProcess = false;
            try {
                canProcess = driver.canAccess(Driver.DriverCapabilities.CONNECT, params);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error asking " + driver.getTitle() + " if it can process request", t);
                continue;
            }
            if (!canProcess) continue;
            boolean isAvailable = false;
            try {
                isAvailable = driver.isAvailable();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error when checking if " + driver.getTitle() + " is available", t);
                continue;
            }
            if (!isAvailable) continue;
            try {
                return driver.access(Driver.DriverCapabilities.CONNECT, params, hints, listener);
            }
            catch (IOException couldNotConnect) {
                LOGGER.log(Level.WARNING, driver.getTitle() + " could not connect", couldNotConnect);
            }
        }
        return null;
    }

    public static CoverageAccess connect(Map<String, Serializable> params) throws IOException {
        return CoverageIO.connect(params, null, null);
    }

    public static synchronized Set<Driver> getAvailableDrivers() {
        CoverageIO.scanForPlugins();
        Iterator it = CoverageIO.getServiceRegistry().getServiceProviders(Driver.class, false);
        HashSet<Driver> drivers = new HashSet<Driver>();
        while (it.hasNext()) {
            Driver spi = (Driver)it.next();
            if (!spi.isAvailable()) continue;
            drivers.add(spi);
        }
        return Collections.unmodifiableSet(drivers);
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CoverageIO.class));
        if (REGISTRY == null) {
            REGISTRY = new FactoryCreator(Arrays.asList(Driver.class));
        }
        return REGISTRY;
    }

    public static synchronized void scanForPlugins() {
        CoverageIO.getServiceRegistry().scanForPlugins();
    }

    public static Driver[] getAvailableDriversArray() {
        Set<Driver> drivers = CoverageIO.getAvailableDrivers();
        ArrayList<Driver> driverSet = new ArrayList<Driver>(drivers.size());
        for (Driver element : drivers) {
            if (!element.isAvailable()) continue;
            driverSet.add(element);
        }
        return driverSet.toArray(new Driver[driverSet.size()]);
    }

    public static Set<Driver> findDrivers(URL url) {
        Set<Driver> availaibleDrivers = CoverageIO.getAvailableDrivers();
        HashSet<Driver> drivers = new HashSet<Driver>();
        for (Driver spi : availaibleDrivers) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", url);
            if (!spi.isAvailable() || !spi.canAccess(Driver.DriverCapabilities.CONNECT, params)) continue;
            drivers.add(spi);
        }
        return Collections.unmodifiableSet(drivers);
    }

    public static Driver findDriver(URL url) {
        Set<Driver> drivers = CoverageIO.findDrivers(url);
        Iterator<Driver> it = drivers.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

