/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.catalog;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.io.catalog.CoverageSlice;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.h2.H2DataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class CoverageSlicesCatalog {
    static final Logger LOGGER = Logging.getLogger(CoverageSlicesCatalog.class);
    static final H2DataStoreFactory INTERNAL_STORE_SPI = new H2DataStoreFactory();
    static final String SCAN_FOR_TYPENAMES = "ScanTypeNames";
    private DataStore slicesIndexStore;
    private Set<String> typeNames = new HashSet<String>();
    private String geometryPropertyName;
    private ReferencedEnvelope bounds;
    public static final String IMAGE_INDEX_ATTR = "imageindex";
    private final SoftValueHashMap<Integer, CoverageSlice> coverageSliceDescriptorsCache = new SoftValueHashMap(0);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public CoverageSlicesCatalog(String database, File parentLocation) {
        this(CoverageSlicesCatalog.createParams(database, parentLocation));
    }

    private static Map<String, Serializable> createParams(String database, File parentLocation) {
        Utilities.ensureNonNull((String)"database", (Object)database);
        Utilities.ensureNonNull((String)"parentLocation", (Object)parentLocation);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(SCAN_FOR_TYPENAMES, Boolean.valueOf(true));
        String url = DataUtilities.fileToURL((File)parentLocation).toExternalForm();
        try {
            String updatedDB = "file:" + new File(DataUtilities.urlToFile((URL)new URL(url)), database).getPath();
            params.put("ParentLocation", (Serializable)((Object)url));
            params.put("database", (Serializable)((Object)updatedDB));
            params.put("dbtype", (Serializable)((Object)"h2"));
            params.put("user", (Serializable)((Object)"geotools"));
            params.put("passwd", (Serializable)((Object)"geotools"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoverageSlicesCatalog(Map<String, Serializable> params) {
        Utilities.ensureNonNull((String)"params", params);
        try {
            this.slicesIndexStore = INTERNAL_STORE_SPI.createDataStore(params);
            String typeName = null;
            boolean scanForTypeNames = false;
            if (params.containsKey("TypeName")) {
                typeName = (String)((Object)params.get("TypeName"));
            }
            if (params.containsKey(SCAN_FOR_TYPENAMES)) {
                scanForTypeNames = (Boolean)params.get(SCAN_FOR_TYPENAMES);
            }
            if (scanForTypeNames) {
                String[] typeNames = this.slicesIndexStore.getTypeNames();
                if (typeNames != null) {
                    for (String tn : typeNames) {
                        this.typeNames.add(tn);
                    }
                }
            } else if (typeName != null) {
                this.addTypeName(typeName, false);
            }
            if (this.typeNames.size() > 0) {
                this.extractBasicProperties(this.typeNames.iterator().next());
            } else {
                this.extractBasicProperties(typeName);
            }
        }
        catch (Throwable e) {
            try {
                if (this.slicesIndexStore != null) {
                    this.slicesIndexStore.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.slicesIndexStore = null;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.slicesIndexStore == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties(String typeName) throws IOException {
        SimpleFeatureSource featureSource;
        if (typeName == null) {
            String[] typeNames = this.slicesIndexStore.getTypeNames();
            if (typeNames == null || typeNames.length <= 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
                }
                return;
            }
            if (typeName == null) {
                typeName = typeNames[0];
                this.addTypeName(typeName, false);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + typeName);
                }
            }
            for (String type : typeNames) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
                }
                if (!type.equalsIgnoreCase(typeName)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                typeName = type;
                this.addTypeName(typeName, false);
                break;
            }
        }
        if ((featureSource = this.slicesIndexStore.getFeatureSource(typeName)) == null) {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a featureSource for the qualified name" + typeName);
        }
        FeatureType schema = featureSource.getSchema();
        if (schema != null) {
            this.geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): geometryPropertyName is set to '" + this.geometryPropertyName + "'.");
            }
        } else {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a schema from the featureSource");
        }
    }

    private void addTypeName(String typeName, boolean check) {
        if (check && this.typeNames.contains(typeName)) {
            throw new IllegalArgumentException("This typeName already exists: " + typeName);
        }
        this.typeNames.add(typeName);
    }

    public String[] getTypeNames() {
        if (this.typeNames != null && !this.typeNames.isEmpty()) {
            return this.typeNames.toArray(new String[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock l = this.rwLock.writeLock();
        try {
            l.lock();
            try {
                if (this.slicesIndexStore != null) {
                    this.slicesIndexStore.dispose();
                }
                this.slicesIndexStore = null;
            }
            catch (Throwable e) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.slicesIndexStore = null;
                }
            }
        }
        finally {
            l.unlock();
        }
    }

    public void addGranule(String typeName, SimpleFeature granule, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"granule", (Object)granule);
        Utilities.ensureNonNull((String)"transaction", (Object)transaction);
        DefaultFeatureCollection collection = new DefaultFeatureCollection();
        collection.add(granule);
        this.addGranules(typeName, (SimpleFeatureCollection)collection, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGranules(String typeName, SimpleFeatureCollection granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"granuleMetadata", (Object)granules);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore store = (SimpleFeatureStore)this.slicesIndexStore.getFeatureSource(typeName);
            store.setTransaction(transaction);
            store.addFeatures((FeatureCollection)granules);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CoverageSlice> getGranules(Query q) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        ArrayList<CoverageSlice> returnValue = new ArrayList<CoverageSlice>();
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            String typeName = q.getTypeName();
            SimpleFeatureSource featureSource = this.slicesIndexStore.getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection features = featureSource.getFeatures(q);
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            try (SimpleFeatureIterator it = features.features();){
                if (!it.hasNext()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("The provided SimpleFeatureCollection  or empty, it's impossible to create an index!");
                    }
                    List<CoverageSlice> list = Collections.emptyList();
                    return list;
                }
                while (it.hasNext()) {
                    CoverageSlice slice;
                    SimpleFeature feature;
                    SimpleFeature sf = feature = (SimpleFeature)it.next();
                    SoftValueHashMap<Integer, CoverageSlice> softValueHashMap = this.coverageSliceDescriptorsCache;
                    synchronized (softValueHashMap) {
                        Integer granuleIndex = (Integer)sf.getAttribute(IMAGE_INDEX_ATTR);
                        if (this.coverageSliceDescriptorsCache.containsKey((Object)granuleIndex)) {
                            slice = (CoverageSlice)this.coverageSliceDescriptorsCache.get((Object)granuleIndex);
                        } else {
                            slice = new CoverageSlice(sf);
                            this.coverageSliceDescriptorsCache.put((Object)granuleIndex, (Object)slice);
                        }
                    }
                    returnValue.add(slice);
                }
            }
            ArrayList<CoverageSlice> arrayList = returnValue;
            return arrayList;
        }
        catch (Throwable e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferencedEnvelope getBounds(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            if (this.bounds == null) {
                this.bounds = this.slicesIndexStore.getFeatureSource(typeName).getBounds();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            this.bounds = null;
        }
        finally {
            lock.unlock();
        }
        return this.bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)featureType);
        Lock lock = this.rwLock.writeLock();
        String typeName = null;
        try {
            lock.lock();
            this.checkStore();
            this.slicesIndexStore.createSchema((FeatureType)featureType);
            typeName = featureType.getTypeName();
            if (typeName != null) {
                this.addTypeName(typeName, true);
            }
            this.extractBasicProperties(typeName);
        }
        finally {
            lock.unlock();
        }
    }

    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Utilities.ensureNonNull((String)"identification", (Object)identification);
        SimpleFeatureType featureType = DataUtilities.createType((String)identification, (String)typeSpec);
        this.createType(featureType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            if (typeName == null) {
                SimpleFeatureType simpleFeatureType = null;
                return simpleFeatureType;
            }
            SimpleFeatureType simpleFeatureType = this.slicesIndexStore.getSchema(typeName);
            return simpleFeatureType;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureSource fs = this.slicesIndexStore.getFeatureSource(query.getTypeName());
            if (fs instanceof ContentFeatureSource) {
                ((ContentFeatureSource)fs).accepts(query, (FeatureVisitor)function, null);
            } else {
                SimpleFeatureCollection collection = fs.getFeatures(query);
                collection.accepts((FeatureVisitor)function, null);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCapabilities getQueryCapabilities(String typeName) {
        Lock lock = this.rwLock.readLock();
        try {
            lock.lock();
            this.checkStore();
            QueryCapabilities queryCapabilities = this.slicesIndexStore.getFeatureSource(typeName).getQueryCapabilities();
            return queryCapabilities;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            QueryCapabilities queryCapabilities = null;
            return queryCapabilities;
        }
        finally {
            lock.unlock();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.slicesIndexStore != null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("This granule catalog was not properly dispose as it still points to:" + this.slicesIndexStore.getInfo().toString());
            }
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGranules(String typeName, Filter filter, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"filter", (Object)filter);
        Utilities.ensureNonNull((String)"transaction", (Object)transaction);
        Lock lock = this.rwLock.writeLock();
        try {
            lock.lock();
            this.checkStore();
            SimpleFeatureStore store = (SimpleFeatureStore)this.slicesIndexStore.getFeatureSource(typeName);
            store.setTransaction(transaction);
            store.removeFeatures(filter);
        }
        finally {
            lock.unlock();
        }
    }
}

