/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.io.CoverageRequest;
import org.geotools.coverage.io.range.RangeType;
import org.geotools.coverage.io.util.DateRangeTreeSet;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class CoverageReadRequest
extends CoverageRequest {
    protected Rectangle rasterArea;
    protected ReferencedEnvelope geographicArea;
    protected MathTransform2D gridToWorldTransform;
    private RangeType rangeSubset;
    private Set<NumberRange<Double>> verticalSubset;
    private SortedSet<DateRange> temporalSubset;
    private Map<String, Set<?>> additionalDomainsSubset = new HashMap();
    private Filter filter;

    public RangeType getRangeSubset() {
        return this.rangeSubset;
    }

    public void setDomainSubset(Rectangle rasterArea, MathTransform2D gridToWorldTrasform, CoordinateReferenceSystem crs) throws MismatchedDimensionException, TransformException {
        this.rasterArea = (Rectangle)rasterArea.clone();
        this.gridToWorldTransform = gridToWorldTrasform;
        GeneralEnvelope env = CRS.transform((MathTransform)gridToWorldTrasform, (org.opengis.geometry.Envelope)new ReferencedEnvelope(rasterArea.getBounds2D(), crs));
        this.geographicArea = new ReferencedEnvelope((Envelope)new ReferencedEnvelope((org.opengis.geometry.Envelope)env), crs);
    }

    public void setDomainSubset(Rectangle rasterArea, ReferencedEnvelope worldArea) {
        if (rasterArea != null) {
            this.rasterArea = (Rectangle)rasterArea.clone();
        }
        this.geographicArea = worldArea;
        GridToEnvelopeMapper mapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(rasterArea), (org.opengis.geometry.Envelope)new ReferencedEnvelope(worldArea));
        mapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        this.gridToWorldTransform = (MathTransform2D)mapper.createTransform();
    }

    public void setRangeSubset(RangeType value) {
        this.rangeSubset = value;
    }

    public Set<NumberRange<Double>> getVerticalSubset() {
        if (this.verticalSubset == null) {
            Set empty = Collections.emptySet();
            this.verticalSubset = new HashSet(empty);
            return this.verticalSubset;
        }
        return new LinkedHashSet<NumberRange<Double>>(this.verticalSubset);
    }

    public void setVerticalSubset(Set<NumberRange<Double>> verticalSubset) {
        this.verticalSubset = new LinkedHashSet<NumberRange<Double>>(verticalSubset);
    }

    public SortedSet<DateRange> getTemporalSubset() {
        if (this.temporalSubset == null) {
            this.temporalSubset = new DateRangeTreeSet();
        }
        return new DateRangeTreeSet(this.temporalSubset);
    }

    public void setTemporalSubset(SortedSet<DateRange> temporalSubset) {
        this.temporalSubset = new DateRangeTreeSet(temporalSubset);
    }

    public Map<String, Set<?>> getAdditionalDomainsSubset() {
        return this.additionalDomainsSubset;
    }

    public void setAdditionalDomainsSubset(Map<String, Set<?>> additionalDomainsSubset) {
        this.additionalDomainsSubset = additionalDomainsSubset;
    }

    public Rectangle getRasterArea() {
        return this.rasterArea != null ? (Rectangle)this.rasterArea.clone() : this.rasterArea;
    }

    public BoundingBox getGeographicArea() {
        return this.geographicArea;
    }

    public MathTransform2D getGridToWorldTransform() {
        return this.gridToWorldTransform;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }
}

