Attribute VB_Name = "mod_Turn"
Option Explicit

Private Type POINTAPI    ' aka Point
        X       As Long
        Y       As Long
End Type

Private Declare Function PlgBlt Lib "gdi32" (ByVal hDCDest As Long, lpPoint As POINTAPI, ByVal hDCSrc As Long, ByVal nXSrc As Long, ByVal nYSrc As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hbmMask As Long, ByVal xMask As Long, ByVal yMask As Long) As Long
Private Declare Function BitBlt Lib "gdi32.dll" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Public Const PI As Double = 3.1415926

Private Const SWP_NOACTIVATE = &H10
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOREDRAW = &H8
Private Const SWP_NOSIZE = &H1
Private Const SWP_NOZORDER = &H4
Private Const SWP_FRAMECHANGED = &H20

'*****************************************************************
'ת
Public Function TurnPic(ObjMe As Object, pObj1 As PictureBox, pObj2 As PictureBox, ByVal dThetaDeg As Single) As Boolean
                        
        'On Error Resume Next
        
        Dim pt(1 To 3) As POINTAPI, p4 As POINTAPI, mpt(0 To 3) As POINTAPI
        Dim dx As Long, dy As Long
        Dim lRet As Long, OffsetX As Long, OffsetY As Long
        Dim Sida As Double
        Dim MaxX As Long, MaxY As Long, MinX As Long, MinY As Long, MaxW As Long, MaxH As Long
        
        Sida = dThetaDeg * PI / 180
        
        dx = ObjMe.ScaleX(pObj1.image.Width, vbHimetric, vbPixels)
        dy = ObjMe.ScaleX(pObj1.image.Height, vbHimetric, vbPixels)
        
        'Debug.Print dx, dy
        
        pt(1).X = dy * Sin(Sida)
        pt(1).Y = dy - dy * Cos(Sida)
        pt(2).X = pt(1).X + dx * Cos(Sida)
        pt(2).Y = pt(1).Y + dx * Sin(Sida)
        pt(3).X = 0: pt(3).Y = dy
        
        'Debug.Print pt(1).x, pt(2).x, pt(3).x
        
        'p4pt()֮Уpt(1)-pt(3)Ƴ
        p4.X = pt(3).X + dx * Cos(Sida)
        p4.Y = pt(3).Y + dx * Sin(Sida)
        
        'µĹֻΪתͼpic2мʾ
        MaxX = IIf(pt(1).X > pt(2).X, pt(1).X, pt(2).X)
        MaxX = IIf(MaxX > pt(3).X, MaxX, pt(3).X)
        MaxX = IIf(MaxX > p4.X, MaxX, p4.X)
        MinX = IIf(pt(1).X < pt(2).X, pt(1).X, pt(2).X)
        MinX = IIf(MinX < pt(3).X, MinX, pt(3).X)
        MinX = IIf(MinX < p4.X, MinX, p4.X)
        
        MaxY = IIf(pt(1).Y > pt(2).Y, pt(1).Y, pt(2).Y)
        MaxY = IIf(MaxY > pt(3).Y, MaxY, pt(3).Y)
        MaxY = IIf(MaxY > p4.Y, MaxY, p4.Y)
        MinY = IIf(pt(1).Y < pt(2).Y, pt(1).Y, pt(2).Y)
        MinY = IIf(MinY < pt(3).Y, MinY, pt(3).Y)
        MinY = IIf(MinY < p4.Y, MinY, p4.Y)
        
        MaxW = MaxX - MinX
        MaxH = MaxY - MinY
        
'        pObj2.Width = MaxW
'        pObj2.Height = MaxH
        
        'Debug.Print MaxW, MaxH
        SetWidthHeight pObj2, MaxW, MaxH 'ÿ
        
        If dThetaDeg = 180 Then
                OffsetX = (pObj2.ScaleWidth - MaxX + MinX) \ 2 - MinX - 1
                OffsetY = (pObj2.ScaleHeight - (MaxY - MinY)) \ 2 - MinY - 1
        Else
                OffsetX = (pObj2.ScaleWidth - MaxX + MinX) \ 2 - MinX
                OffsetY = (pObj2.ScaleHeight - (MaxY - MinY)) \ 2 - MinY
        End If
        'Debug.Print OffsetX, OffsetY
        
        pt(1).X = pt(1).X + OffsetX: pt(1).Y = pt(1).Y + OffsetY
        pt(2).X = pt(2).X + OffsetX: pt(2).Y = pt(2).Y + OffsetY
        pt(3).X = pt(3).X + OffsetX: pt(3).Y = pt(3).Y + OffsetY
        
        'pObj2.Cls
        lRet = PlgBlt(pObj2.Hdc, pt(1), pObj1.Hdc, 0, 0, dx, dy, 0, 0, 0)
        'Debug.Print lRet, Err.LastDllError
        
        'ƽԵ
'        mpt(0) = pt(1): mpt(1) = pt(2): mpt(2) = pt(3): mpt(3) = p4
'        SmoothEdge pObj2, mpt(), 10
        Erase pt, mpt
        pObj2.Refresh
        TurnPic = lRet
End Function

'GDI+ת
Public Function GdiTurnPic(pSrc As PictureBox, pDes As PictureBox, ByVal nAngle As Single, _
                                                                Optional fx As Long, _
                                                                Optional fy As Long) As Boolean
                        
        'On Error Resume Next
        Dim gdip_Token          As Long
        Dim gdip_Image          As Long
        Dim gdip_Graphics       As Long
        Dim lRet                As Long
        Dim GpInput             As GdiplusStartupInput
        Dim iW&, iH&, MaxW&, MaxH&, CenX&, CenY&, OffsetX&, OffsetY&
        iW = pSrc.ScaleWidth
        iH = pSrc.ScaleHeight
        GpInput.GdiplusVersion = 1
        If GdiplusStartup(gdip_Token, GpInput) <> 0 Then Exit Function
        pDes.Cls
        GetTurnWidthHeight nAngle, iW, iH, MaxW, MaxH, CenX, CenY
        'Debug.Print "zff", MaxW, MaxH, CenX, CenY
        pDes.Width = MaxW - 1
        pDes.Height = MaxH - 1
        OffsetX = MaxW \ 2 - CenX - 1
        OffsetY = MaxH \ 2 - CenY - 1
        fx = OffsetX
        fy = OffsetY
        'Debug.Print MaxW, MaxH
        If GdipCreateFromHDC(pDes.Hdc, gdip_Graphics) = 0 Then
                GdipCreateBitmapFromHBITMAP pSrc.image.Handle, 0, gdip_Image
                'Debug.Print "gdip_Image=", gdip_Image
                GdipRotateWorldTransform gdip_Graphics, nAngle, MatrixOrderAppend
                GdipTranslateWorldTransform gdip_Graphics, OffsetX, OffsetY, MatrixOrderAppend
                lRet = GdipDrawImageRect(gdip_Graphics, gdip_Image, 0, 0, iW, iH)
                GdipDisposeImage gdip_Image
                GdipDeleteGraphics gdip_Graphics
        End If
        GdiTurnPic = (lRet = 0)
        GdiplusShutdown gdip_Token
End Function

'Shell ת
Sub ShellGDITurn(pSrc As PictureBox, pDes As PictureBox, ByVal nAngle As Single)
        'On Error Resume Next
        'һת
        Dim fx&, fy&, i&, j&, X&, Y&, d#, m&, t&
        GdiTurnPic pSrc, pDes, nAngle, fx, fy
        Debug.Print fx, fy
        d = nAngle * PI / 180
        If nAngle = 88 Or nAngle = 178 Or nAngle = 268 Or nAngle = 358 Then
                t = 2
        Else
                t = 1
        End If
        'ڶתϾ
        With frm_Main
                .pTM.Cls
                .pTM.BackColor = pDes.BackColor
                .p180.Cls
                .p180.BackColor = pDes.BackColor
                TurnPic pSrc, pSrc, .p180, 180 'ת
                If nAngle < 180 Then
                        nAngle = nAngle + 180
                Else
                        nAngle = nAngle - 180
                End If
                GdiTurnPic .p180, .pTM, nAngle
                '
                For i = 1 To 2
                        If i = 1 Then m = pSrc.ScaleWidth - 1 Else m = pSrc.ScaleHeight - 1
                        For j = t To m - t
                                If i = 1 Then
                                        X = Cos(d) * j + fx
                                        Y = Sin(d) * j + fy
                                Else
                                        X = Sin(d) * -j + fx
                                        Y = Cos(d) * j + fy
                                End If
                                BitBlt pDes.Hdc, X - t, Y - t, t * 2 + 1, t * 2 + 1, .pTM.Hdc, X - t, Y - t, vbSrcCopy
                        Next j
                Next i
                .pTM.Cls
                .p180.Cls
        End With
End Sub

'ȡת
Sub GetTurnWidthHeight(nAngle As Single, iW As Long, iH As Long, MaxW As Long, MaxH As Long, CenX As Long, CenY As Long)
        'µĹֻΪתͼpic2мʾ
        Dim pt(1 To 4) As POINTAPI
        Dim MaxX&, MaxY&, MinX&, MinY&
        Dim d As Double
        d = nAngle * PI / 180
        pt(1).X = 0
        pt(1).Y = 0
        pt(2).X = pt(1).X + iW * Cos(d)
        pt(2).Y = pt(1).Y + iW * Sin(d)
        pt(3).X = -iH * Sin(d)
        pt(3).Y = iH * Cos(d)
        pt(4).X = pt(3).X + iW * Cos(d)
        pt(4).Y = pt(3).Y + iW * Sin(d)
        
        MaxX = IIf(pt(1).X > pt(2).X, pt(1).X, pt(2).X)
        MaxX = IIf(MaxX > pt(3).X, MaxX, pt(3).X)
        MaxX = IIf(MaxX > pt(4).X, MaxX, pt(4).X)
        MinX = IIf(pt(1).X < pt(2).X, pt(1).X, pt(2).X)
        MinX = IIf(MinX < pt(3).X, MinX, pt(3).X)
        MinX = IIf(MinX < pt(4).X, MinX, pt(4).X)
        
        MaxY = IIf(pt(1).Y > pt(2).Y, pt(1).Y, pt(2).Y)
        MaxY = IIf(MaxY > pt(3).Y, MaxY, pt(3).Y)
        MaxY = IIf(MaxY > pt(4).Y, MaxY, pt(4).Y)
        MinY = IIf(pt(1).Y < pt(2).Y, pt(1).Y, pt(2).Y)
        MinY = IIf(MinY < pt(3).Y, MinY, pt(3).Y)
        MinY = IIf(MinY < pt(4).Y, MinY, pt(4).Y)
        
        MaxW = MaxX - MinX
        MaxH = MaxY - MinY
        'Debug.Print MaxW, MaxH, MaxX, MinX, MaxY, MinY
        'Debug.Print pt(2).X, pt(2).Y, pt(3).X, pt(3).Y, pt(4).X, pt(4).Y
        CenX = MaxW \ 2 + MinX
        CenY = MaxH \ 2 + MinY
End Sub

'
Public Function Is90Angle(nAngle As Single) As Boolean
        If nAngle = 0 Or nAngle = 90 Or nAngle = 180 Or nAngle = 270 Or nAngle = 360 Then
                Is90Angle = True
        End If
End Function

Public Function SetWidthHeight(MyCtl As Object, frmW As Long, frmH As Long)
        SetWindowPos MyCtl.hWnd, 0&, 0&, 0&, frmW, frmH, SWP_NOZORDER Or SWP_NOMOVE Or SWP_NOACTIVATE
End Function

