Attribute VB_Name = "mod_Gdiplus"

Option Explicit



Public Enum GpStatus
        [Ok] = 0
        [GenericError] = 1
        [InvalidParameter] = 2
        [OutOfMemory] = 3
        [ObjectBusy] = 4
        [InsufficientBuffer] = 5
        [NotImplemented] = 6
        [Win32Error] = 7
        [WrongState] = 8
        [Aborted] = 9
        [FileNotFound] = 10
        [ValueOverflow ] = 11
        [AccessDenied] = 12
        [UnknownImageFormat] = 13
        [FontFamilyNotFound] = 14
        [FontStyleNotFound] = 15
        [NotTrueTypeFont] = 16
        [UnsupportedGdiplusVersion] = 17
        [GdiplusNotInitialized ] = 18
        [PropertyNotFound] = 19
        [PropertyNotSupported] = 20
End Enum

Public Type GdiplusStartupInput
        GdiplusVersion           As Long
        DebugEventCallback       As Long
        SuppressBackgroundThread As Long
        SuppressExternalCodecs   As Long
End Type

Public Enum GpUnit  ' aka Unit
        UnitWorld      ' 0 -- World coordinate (non-physical unit)
        UnitDisplay    ' 1 -- Variable -- for PageTransform only
        UnitPixel      ' 2 -- Each unit is one device pixel.
        UnitPoint      ' 3 -- Each unit is a printer's point, or 1/72 inch.
        UnitInch       ' 4 -- Each unit is 1 inch.
        UnitDocument   ' 5 -- Each unit is 1/300 inch.
        UnitMillimeter ' 6 -- Each unit is 1 millimeter.
End Enum

Public Enum MatrixOrder
        MatrixOrderPrepend = 0
        MatrixOrderAppend = 1
End Enum

Public Type POINTF   ' aka PointF
        X As Single
        Y As Single
End Type

Public Type POINTL    ' aka Point
        X As Long
        Y As Long
End Type

Public Type RECTF    ' aka RectF
        Left As Single
        Top As Single
        Right As Single
        Bottom As Single
End Type

'ֵģʽ
Private Enum QualityMode
        QualityModeInvalid = -1
        QualityModeDefault = 0
        QualityModeLow = 1
        QualityModeHigh = 2
End Enum

Public Enum InterpolationMode
        InterpolationModeInvalid = QualityModeInvalid   'Ч
        InterpolationModeDefault = QualityModeDefault   'Ĭ
        InterpolationModeLowQuality = QualityModeLow    '
        InterpolationModeHighQuality = QualityModeHigh  '
        InterpolationModeBilinear       '˫
        InterpolationModeBicubic        '˫
        InterpolationModeNearestNeighbor        'ٽ
        InterpolationModeHighQualityBilinear    '˫
        InterpolationModeHighQualityBicubic     '˫
End Enum

Public Enum SmoothingMode
        SmoothingModeInvalid = QualityModeInvalid
        SmoothingModeDefault = QualityModeDefault
        SmoothingModeHighSpeed = QualityModeLow
        SmoothingModeHighQuality = QualityModeHigh
        SmoothingModeNone
        SmoothingModeAntiAlias
End Enum


Public Declare Function GdiplusStartup Lib "gdiplus" (Token As Long, InputBuf As GdiplusStartupInput, Optional ByVal OutputBuf As Long = 0) As GpStatus
Public Declare Function GdiplusShutdown Lib "gdiplus" (ByVal Token As Long) As GpStatus
Public Declare Function GdipDrawImageRect Lib "gdiplus" (ByVal graphics As Long, ByVal image As Long, ByVal X As Single, ByVal Y As Single, ByVal Width As Single, ByVal Height As Single) As GpStatus
Public Declare Function GdipCreateFromHDC Lib "gdiplus" (ByVal Hdc As Long, graphics As Long) As GpStatus
Public Declare Function GdipDeleteGraphics Lib "gdiplus" (ByVal graphics As Long) As GpStatus
Public Declare Function GdipLoadImageFromFile Lib "gdiplus" (ByVal FileName As Long, hImage As Long) As GpStatus
Public Declare Function GdipDisposeImage Lib "gdiplus" (ByVal image As Long) As GpStatus
Public Declare Function GdipGetImageWidth Lib "gdiplus" (ByVal image As Long, Width As Long) As GpStatus
Public Declare Function GdipGetImageHeight Lib "gdiplus" (ByVal image As Long, Height As Long) As GpStatus
Public Declare Function GdipCreateBitmapFromHBITMAP Lib "gdiplus" (ByVal hbm As Long, ByVal hPal As Long, BITMAP As Long) As Long
Public Declare Function GdipSetSmoothingMode Lib "gdiplus" (ByVal graphics As Long, ByVal SmoothingMd As SmoothingMode) As GpStatus
Public Declare Function GdipRotateWorldTransform Lib "gdiplus" (ByVal graphics As Long, ByVal Angle As Single, ByVal order As MatrixOrder) As GpStatus
Public Declare Function GdipTranslateWorldTransform Lib "gdiplus" (ByVal graphics As Long, ByVal dx As Single, ByVal dy As Single, ByVal order As MatrixOrder) As GpStatus
Public Declare Function GdipDrawImagePoints Lib "gdiplus" (ByVal graphics As Long, ByVal image As Long, dstpoints As POINTF, ByVal count As Long) As GpStatus
Public Declare Function GdipSetInterpolationMode Lib "gdiplus" (ByVal graphics As Long, ByVal interpolation As InterpolationMode) As GpStatus


