;/ Decompiled by Champollion V1.0.5
PEX format v3.9 GameID: 2
Source   : g:\_F4\Art\Raw\Scripts\MinArtilleryScript.psc
Modified : 2015-07-29 09:09:46
Compiled : 2015-12-11 11:58:59
User     : builds
Computer : RKVBGSBUILD05
/;
ScriptName MinArtilleryScript extends Quest conditional

;-- Structs -----------------------------------------
Struct ArtilleryLocation
	LocationAlias artilleryLocationAlias
	ReferenceAlias originMarker
	ReferenceAlias workshopAlias
	RefCollectionAlias artillery
	int strikeCount
EndStruct


;-- Properties --------------------------------------
PropertyGroup OutOfRange
	LocationAlias Property ArtilleryLocationTooClose Auto
	{ if this is filled, there is some artillery but too close - use for radio message "out of range" }
	ReferenceAlias Property ArtilleryTooCloseMarker Auto
	{ center marker for ArtilleryLocationAnyRange - use for distance calculations }
	LocationAlias Property ArtilleryLocationTooFar Auto
	{ if this is filled, there is some artillery but too far - use for radio message "out of range" }
	ReferenceAlias Property ArtilleryTooFarMarker Auto
	{ center marker for ArtilleryLocationAnyRange - use for distance calculations }
EndPropertyGroup

PropertyGroup Messages
	Message Property MinArtilleryFriendlyTargetMessage Auto mandatory
	Message Property MinArtilleryTooCloseMessage Auto mandatory
	Message Property MinArtilleryTooFarMessage Auto mandatory
	Message Property MinArtilleryNoneAvailableMessage Auto mandatory
	Message Property MinArtilleryReloadingMessage Auto mandatory
EndPropertyGroup

PropertyGroup ExplosionProperties
	Sound Property FXProjectileArtilleryMinutemen Auto
	Activator Property WorkshopArtilleryStrikeProjectileShooterFar Auto
EndPropertyGroup

FormList Property MinArtilleryList Auto
minartilleryscript#artillerylocation[] Property ArtilleryLocations Auto
ReferenceAlias Property Smoke Auto
LocationAlias Property SmokeLocation Auto
ReferenceAlias Property SmokeLocationCenterMarker Auto
ObjectReference Property MinArtilleryMarker Auto
{ marker used for placing artillery strikes }
ObjectReference Property MinArtilleryCenterMarker Auto
{ marker used for placing artillery strikes }
GlobalVariable Property MinArtilleryRangeMinimum Auto
GlobalVariable Property MinArtilleryRangeMaximum Auto
GlobalVariable Property MinArtilleryTimeNextAvailable Auto
{ after firing, next time the artillery will be available - GameDaysPassed + MinArtilleryResetTimeHours }
GlobalVariable Property MinArtilleryResetTimeHours Auto
{ how long (in hours) until artillery can fire again }
workshopparentscript Property WorkshopParent Auto
minutemencentralscript Property MinutemenCentralQuest Auto
Scene Property MinArtilleryRadioChatter Auto
bool Property bValidTarget Auto conditional
bool Property bFriendlyTarget Auto conditional
bool Property bTooClose Auto conditional
bool Property bTooFar Auto conditional

;-- Variables ---------------------------------------
minartilleryscript#artillerylocation nextLocation
const float MaxStrikesPerArtillery = 4
const float ArtilleryStrikeTimerMin = 0.0001
const float ArtillerySpreadRadius = 750
int TotalArtillery = 0
const int MaxArtilleryStrikeCount = 18
const float StartHours = 0.04
const float ArtilleryStrikeTimerMax = 0.0001
const float MinStrikesPerArtillery = 4
ObjectReference nextArtillery
ObjectReference nextArtillery2
ObjectReference nextArtillery3
int ArtilleryStrikeCount = 0
minartilleryscript#artillerylocation firingLocation
artilleryreferencescript firingArtillery
int ArtilleryStrikeTimerID = 2
int ArtilleryWaitForFinishedTimerID = 3
int StartTimerID = 1
float firingArtilleryFailsafeHours = 0.0001
bool didFirstStrike = False

;-- Functions ---------------------------------------

Function Initialize()
	int I = 0
	TotalArtillery = 0
	ArtilleryStrikeCount = 0
	While (I < ArtilleryLocations.length)
		minartilleryscript#artillerylocation theArtyLoc = ArtilleryLocations[I]
		Location theLoc = theArtyLoc.artilleryLocationAlias.GetLocation()
		workshopscript theWorkshop = theArtyLoc.workshopAlias.GetRef() as workshopscript
		If (theLoc)
			MinArtilleryList.AddForm(theLoc as Form)
			theArtyLoc.strikeCount = theWorkshop.GetValue(WorkshopParent.WorkshopRatings[WorkshopParent.WorkshopRatingArtillery].resourceValue) as int
			TotalArtillery += theArtyLoc.strikeCount
			theArtyLoc.strikeCount = Math.Floor(theArtyLoc.strikeCount as float * Utility.RandomFloat(MinStrikesPerArtillery, MaxStrikesPerArtillery))
			ArtilleryStrikeCount += theArtyLoc.strikeCount
		EndIf
		RefCollectionAlias theArtilleryCollection = theArtyLoc.artillery
		int artilleryIndex = theArtilleryCollection.GetCount() - 1
		While (artilleryIndex > -1)
			ObjectReference theArtilleryRef = theArtilleryCollection.GetAt(artilleryIndex)
			If (theArtilleryRef.CanProduceForWorkshop() == False)
				theArtilleryCollection.RemoveRef(theArtilleryRef)
			EndIf
			artilleryIndex -= 1
		EndWhile
		I += 1
	EndWhile
	ArtilleryStrikeCount = Math.Min(ArtilleryStrikeCount as float, MaxArtilleryStrikeCount as float) as int
	If (TotalArtillery == 0 && (ArtilleryLocationTooClose.GetLocation() as bool || ArtilleryLocationTooFar.GetLocation() as bool))
		ObjectReference artyTooCloseMarker = ArtilleryTooCloseMarker.GetRef()
		ObjectReference artyTooFarMarker = ArtilleryTooFarMarker.GetRef()
		If (artyTooCloseMarker)
			bTooClose = True
		ElseIf (artyTooFarMarker)
			bTooFar = True
		EndIf
	ElseIf (TotalArtillery > 0)
		If (WorkshopParent.IsFriendlyLocation(Smoke.GetRef()))
			bFriendlyTarget = True
		Else
			bValidTarget = True
		EndIf
	Else
		MinArtilleryNoneAvailableMessage.Show(0, 0, 0, 0, 0, 0, 0, 0, 0)
		Self.stop()
	EndIf
	If (bValidTarget)
		
	EndIf
	Self.StartTimerGameTime(StartHours, StartTimerID)
EndFunction

Function NextArtilleryStrike()
	If (ArtilleryStrikeCount <= 0)
		Self.FinishArtilleryStrikes()
		return 
	EndIf
	ArtilleryStrikeCount -= 1
	If (nextLocation == None)
		Self.PickNextArtillery(None)
	EndIf
	If (nextLocation == None)
		
	Else
		Location strikeLoc = nextLocation.artilleryLocationAlias.GetLocation()
		If (nextArtillery == None)
			
		Else
			float xOffset = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
			float yOffset = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
			float xOffset2 = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
			float yOffset2 = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
			float xOffset3 = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
			float yOffset3 = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
			If (!didFirstStrike)
				didFirstStrike = True
				xOffset = 0
				yOffset = 0
			EndIf
			MinArtilleryMarker.MoveTo(MinArtilleryCenterMarker, xOffset, yOffset, 0, True)
			float headingAngle = MinArtilleryMarker.GetHeadingAngle(nextArtillery)
			headingAngle += MinArtilleryMarker.GetAngleZ()
			MinArtilleryMarker.SetAngle(0, 0, headingAngle)
			artilleryreferencescript artilleryRef = nextArtillery as artilleryreferencescript
			artilleryreferencescript artilleryRef2 = nextArtillery2 as artilleryreferencescript
			artilleryreferencescript artilleryRef3 = nextArtillery3 as artilleryreferencescript
			If (artilleryRef)
				;Self.RegisterForCustomEvent(artilleryRef as ScriptObject, "artilleryreferencescript_FinishedFiring")
				Self.SetFiringArtillery(artilleryRef, nextLocation)
				artilleryRef.FireAtTarget(MinArtilleryMarker, False)
				If (artilleryRef2)
					ArtilleryStrikeCount -= 1
					Utility.Wait(0.25)
					Self.SetFiringArtillery(artilleryRef2, nextLocation)
					MinArtilleryMarker.MoveTo(MinArtilleryCenterMarker, xOffset2, yOffset2, 0, True)
					artilleryRef2.FireAtTarget(MinArtilleryMarker, False)
					If (artilleryRef3)
						ArtilleryStrikeCount -= 1
						Utility.Wait(0.25)
						Self.SetFiringArtillery(artilleryRef3, nextLocation)
						MinArtilleryMarker.MoveTo(MinArtilleryCenterMarker, xOffset3, yOffset3, 0, True)
						artilleryRef3.FireAtTarget(MinArtilleryMarker, False)
					EndIf
				EndIf
				;Self.StartTimerGameTime(firingArtilleryFailsafeHours, ArtilleryWaitForFinishedTimerID)
			Else
				Self.PlaceExplosion(MinArtilleryMarker)
				Self.SetFiringArtillery(None, None)
			EndIf
		EndIf
	EndIf
	If (ArtilleryStrikeCount > 0)
		Self.PickNextArtillery(firingArtillery)
	EndIf
	;If (firingArtillery)
	;	
	;ElseIf (ArtilleryStrikeCount > 0)
	If (ArtilleryStrikeCount > 0)
		Self.StartArtilleryStrikeTimer()
	Else
		Self.FinishArtilleryStrikes()
	EndIf
EndFunction

Function OnTimerGameTime(int aiTimerID)
	If (aiTimerID == StartTimerID)
		Self.setStage(20)
		MinArtilleryCenterMarker.MoveTo(Smoke.GetRef(), 0, 0, 0, False)
;	ElseIf (aiTimerID == ArtilleryStrikeTimerID)
;		Self.NextArtilleryStrike()
;	ElseIf (aiTimerID == ArtilleryWaitForFinishedTimerID)
;		If (firingArtillery)
;			Self.SetFiringArtillery(None, None)
;			Self.StartArtilleryStrikeTimer()
;		EndIf
	EndIf
EndFunction

Function PlaceExplosion(ObjectReference targetMarker)
	FXProjectileArtilleryMinutemen.Play(targetMarker)
	ObjectReference myFiringMarker = targetMarker.PlaceAtMe(WorkshopArtilleryStrikeProjectileShooterFar as Form, 1, False, False, True)
	myFiringMarker.Delete()
EndFunction

Function ShowFailureMessage(Message theMessage)
	If (MinutemenCentralQuest.RadioStationActive == False || Game.IsPlayerListening(MinutemenCentralQuest.MinutemenRadioFrequency as float) == False)
		theMessage.Show(0, 0, 0, 0, 0, 0, 0, 0, 0)
	EndIf
EndFunction

Function PickNextArtillery(artilleryreferencescript lastArtillery)
	int strikeIndex = Utility.RandomInt(0, MinArtilleryList.GetSize() - 1)
	Location strikeLoc = MinArtilleryList.GetAt(strikeIndex) as Location
	ObjectReference strikeOrigin = None
	minartilleryscript#artillerylocation strikeArtilleryLocation = None
	int I = 0
	While (I < ArtilleryLocations.length && strikeOrigin == None)
		minartilleryscript#artillerylocation theArtyLoc = ArtilleryLocations[I]
		If (theArtyLoc.artilleryLocationAlias.GetLocation() == strikeLoc)
			strikeArtilleryLocation = theArtyLoc
			theArtyLoc.strikeCount = theArtyLoc.strikeCount + -1
			If (theArtyLoc.strikeCount <= 0)
				MinArtilleryList.RemoveAddedForm(strikeLoc as Form)
			EndIf
			int artilleryCount = theArtyLoc.artillery.GetCount()
			If (artilleryCount > 0)
				int nextArtilleryIndex = -1
				If (lastArtillery)
					int lastArtilleryIndex = theArtyLoc.artillery.Find(lastArtillery as ObjectReference)
					If (lastArtilleryIndex > -1)
						nextArtilleryIndex = (lastArtilleryIndex + 3) % artilleryCount
					EndIf
				EndIf
				If (nextArtilleryIndex == -1)
					nextArtilleryIndex = Utility.RandomInt(0, artilleryCount - 1)
				EndIf
				strikeOrigin = theArtyLoc.artillery.GetAt(nextArtilleryIndex)
				int nextArtilleryIndex2 = (nextArtilleryIndex + 1) % artilleryCount
				If (nextArtilleryIndex2 != nextArtilleryIndex)
					nextArtillery2 = theArtyLoc.artillery.GetAt(nextArtilleryIndex2)
				Else
					nextArtillery2 = None
				EndIf
				int nextArtilleryIndex3 = (nextArtilleryIndex + 2) % artilleryCount
				If (nextArtilleryIndex3 != nextArtilleryIndex && nextArtilleryIndex3 != nextArtilleryIndex2)
					nextArtillery3 = theArtyLoc.artillery.GetAt(nextArtilleryIndex3)
				Else
					nextArtillery3 = None
				EndIf
			Else
				strikeOrigin = theArtyLoc.originMarker.GetRef()
			EndIf
		EndIf
		I += 1
	EndWhile
	nextLocation = strikeArtilleryLocation
	nextArtillery = strikeOrigin
	If (nextLocation as bool && nextLocation.artilleryLocationAlias.GetLocation() as bool)
		
	Else
		nextLocation = None
	EndIf
EndFunction

Function ShowFailureMessageTooClose()
	Self.ShowFailureMessage(MinArtilleryTooCloseMessage)
EndFunction

Function FinishArtilleryStrikes()
	MinArtilleryTimeNextAvailable.SetValue(Utility.GetCurrentGameTime() + MinArtilleryResetTimeHours.GetValue() / 24)
	Self.setStage(500)
EndFunction

Function ShowFailureMessageReloading()
	Self.ShowFailureMessage(MinArtilleryReloadingMessage)
EndFunction

Function StartArtilleryStrikeTimer()
;	float timerMin = Math.Max(ArtilleryStrikeTimerMin * 3 / TotalArtillery as float, ArtilleryStrikeTimerMin)
;	float timerMax = Math.Max(ArtilleryStrikeTimerMax * 3 / TotalArtillery as float, ArtilleryStrikeTimerMax)
;	float strikeTimer = Utility.RandomFloat(timerMin, timerMax)
;	If (nextArtillery != firingArtillery as ObjectReference)
;		strikeTimer *= 0.5
;	EndIf
;	Self.StartTimerGameTime(strikeTimer, ArtilleryStrikeTimerID)
	Self.NextArtilleryStrike()
EndFunction

Function ShowFailureMessageTooFar()
	Self.ShowFailureMessage(MinArtilleryTooFarMessage)
EndFunction

Function BeginArtilleryStrikes()
;	Self.StartTimerGameTime(ArtilleryStrikeTimerMin, ArtilleryStrikeTimerID)
	Self.NextArtilleryStrike()
EndFunction

Function ShowFailureMessageFriendlyTarget()
	Self.ShowFailureMessage(MinArtilleryFriendlyTargetMessage)
EndFunction

Function SetFiringArtillery(artilleryreferencescript newFiringArtillery, minartilleryscript#artillerylocation newFiringLocation)
	firingArtillery = newFiringArtillery
	firingLocation = newFiringLocation
EndFunction

;Function ::remote_ArtilleryReferenceScript_FinishedFiring(artilleryreferencescript akSender, var[] akArgs)
;	If (akSender == firingArtillery)
;		Self.SetFiringArtillery(None, None)
;		Self.CancelTimerGameTime(ArtilleryWaitForFinishedTimerID)
;		Self.StartArtilleryStrikeTimer()
;	EndIf
;EndFunction
