;/ Decompiled by Champollion V1.0.5
PEX format v3.9 GameID: 2
Source   : D:\Program Files (x86)\Steam\steamapps\common\Fallout 4\Data\scripts\ArtilleryReferenceScript.psc
Modified : 2016-02-03 03:40:37
Compiled : 2016-02-03 03:40:39
User     : Reid Rankin
Computer : ICARUS
/;
ScriptName ArtilleryReferenceScript extends ObjectReference

;-- Properties --------------------------------------
PropertyGroup ExplosionProperties
	Weapon Property WorkshopArtilleryWeapon Auto
	Activator Property WorkshopArtilleryFakeProjectile Auto
	Form Property XmarkerHeading Auto
	Sound Property FXProjectileArtilleryMinutemen Auto
	Explosion Property WorkshopArtilleryForce Auto
	Explosion Property MinArtilleryMuzzleFlash Auto
	Activator Property WorkshopArtilleryStrikeProjectileShooterClose Auto
	Activator Property WorkshopArtilleryStrikeProjectileShooterFar Auto
	Sound Property WPNArtilleryMinutemenFire Auto
EndPropertyGroup

PropertyGroup AnimationProperties collapsedonref
	Idle Property ArtilleryFire Auto
	Idle Property ArtilleryStop Auto
	Idle Property ArtilleryTurnClockwise Auto
	Idle Property ArtilleryTurnCounterClockwise Auto
EndPropertyGroup


;-- Variables ---------------------------------------
int CurrentCardinal = 0
ObjectReference CurrentTarget
string CurrentTurnEvent
bool noFire = False
int PreviousCardinal = 0
float AngleSnap = 20
bool TestFire = False
ObjectReference MinArtilleryMarker
float ArtillerySpreadRadius = 50

;-- Functions ---------------------------------------

Function PlaceTargetMarker()
	MinArtilleryMarker = CurrentTarget.PlaceAtMe(XmarkerHeading, 1, False, False, True)
	ObjectReference strikeOrigin = Self as ObjectReference
	float xOffset = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
	float yOffset = Utility.RandomFloat(-1 * ArtillerySpreadRadius, ArtillerySpreadRadius)
	MinArtilleryMarker.MoveTo(CurrentTarget, xOffset, yOffset, 0, True)
	float headingAngle = MinArtilleryMarker.GetHeadingAngle(strikeOrigin)
	headingAngle += MinArtilleryMarker.GetAngleZ()
	MinArtilleryMarker.SetAngle(0, 0, headingAngle)
EndFunction

Function Test(bool justAim)
	TestFire = True
	Self.FireAtTarget(Game.GetPlayer() as ObjectReference, justAim)
EndFunction

Function PlaceMortarExplosion()
	FXProjectileArtilleryMinutemen.Play(MinArtilleryMarker)
	ObjectReference myFiringMarker = None
	If (Self.Is3DLoaded())
		myFiringMarker = MinArtilleryMarker.PlaceAtMe(WorkshopArtilleryStrikeProjectileShooterClose as Form, 1, False, False, True)
	Else
		myFiringMarker = MinArtilleryMarker.PlaceAtMe(WorkshopArtilleryStrikeProjectileShooterFar as Form, 1, False, False, True)
	EndIf
	If (TestFire)
		MinArtilleryMarker.Delete()
	Else
		MinArtilleryMarker = None
	EndIf
	CurrentTarget = None
	TestFire = False
	var[] kargs = new var[1]
	kargs[0] = Self as var
	Self.SendCustomEvent("artilleryreferencescript_FinishedFiring", kargs)
EndFunction

Function PlayAnimOrIdle(Idle myIdle, string myAnim)
	Actor CurrentWorker = Self.GetActorRefOwner()
	Self.IsFurnitureInUse(True) && CurrentWorker as bool && CurrentWorker.PlayIdle(myIdle)
	Self.PlayAnimation(myAnim)
EndFunction

;bool Function GetTurnDirection(int P, int N)
;	bool CW = False
;	bool CCW = True
;	int T = (360 / AngleSnap) as int
;	N > P && T - N + P >= N - P
;	If (T - P + N <= P - N)
;		return CW
;	Else
;		return CCW
;	EndIf
;EndFunction

Function FireAtTarget(ObjectReference TargetToFireAt, bool turnToTargetOnly)
	CurrentTarget = TargetToFireAt
	If (TestFire)
		Self.PlaceTargetMarker()
	Else
		MinArtilleryMarker = TargetToFireAt
	EndIf
	Self.FireMortar(False)
EndFunction

;Function OnAnimationEvent(ObjectReference akSource, string asEventName)
;	If (asEventName == CurrentTurnEvent)
;		Self.UnregisterForAnimationEvent(Self as ObjectReference, CurrentTurnEvent)
;		Self.PlayAnimOrIdle(ArtilleryStop, "Stop")
;		If (noFire == False)
;			Self.FireMortar(False)
;		Else
;			noFire = True
;		EndIf
;	EndIf
;EndFunction

Function FireMortar(bool fakeFire)
	ObjectReference objSelf = Self as ObjectReference
	If (Self.Is3DLoaded())
		float CurrentDistance = objSelf.getDistance(CurrentTarget)
		Self.PlayAnimOrIdle(ArtilleryFire, "Fire")
		Utility.Wait(0.9)
		Self.PlaceAtNode("ProjectileNode", MinArtilleryMuzzleFlash as Form, 1, False, False, True, False)
		WorkshopArtilleryWeapon.Fire(objSelf, None)
	Else
		WPNArtilleryMinutemenFire.Play(objSelf)
	EndIf
	If (fakeFire == False)
		Self.PlaceMortarExplosion()
	EndIf
EndFunction

;Function TurnToTarget(ObjectReference TargetToFireAt, bool doNotFire)
;	bool TurnCCW = False
;	float FiringAngle = 0
;	float myHeadingAngle = 0
;	int myHeadingCardinal = 0
;	myHeadingAngle = Self.GetHeadingAngle(TargetToFireAt)
;	FiringAngle = myHeadingAngle
;	If (FiringAngle < 0)
;		FiringAngle += 360
;	EndIf
;	int upDownTest = Math.Floor(FiringAngle / AngleSnap / 2) % 2
;	If (upDownTest == 1)
;		myHeadingCardinal = Math.Ceiling(FiringAngle / AngleSnap)
;	Else
;		myHeadingCardinal = Math.Floor(FiringAngle / AngleSnap)
;	EndIf
;	myHeadingCardinal %= (360 / AngleSnap) as int
;	CurrentTurnEvent = myHeadingCardinal as string
;	If (PreviousCardinal != myHeadingCardinal)
;		Self.RegisterForAnimationEvent(Self as ObjectReference, CurrentTurnEvent)
;		TurnCCW = Self.GetTurnDirection(PreviousCardinal, myHeadingCardinal)
;		If (doNotFire)
;			noFire = True
;		Else
;			noFire = False
;		EndIf
;		If (TurnCCW == False)
;			Self.PlayAnimOrIdle(ArtilleryTurnClockwise, "TurnClockwise")
;		Else
;			Self.PlayAnimOrIdle(ArtilleryTurnCounterClockwise, "TurnCounterClockwise")
;		EndIf
;	ElseIf (doNotFire == False)
;		noFire = False
;		Self.FireMortar(False)
;	Else
;		noFire = True
;	EndIf
;	PreviousCardinal = myHeadingCardinal
;EndFunction
