/*
 * Decompiled with CFR 0.152.
 */
package name.yumao.douyu.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import name.yumao.douyu.mina.KeepLive;
import name.yumao.douyu.mina.LoginMinaHandler;
import name.yumao.douyu.mina.factory.HexCodecFactory;
import name.yumao.douyu.utils.HexUtils;
import name.yumao.douyu.utils.SttEncoder;
import name.yumao.douyu.vo.RoomApiServersVo;
import org.apache.log4j.Logger;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class LoginMinaThread
implements Runnable {
    private static Logger logger = Logger.getLogger(LoginMinaThread.class);
    private String Server1_Host;
    private int Server1_Port;
    private String filepath;
    private JTextField inNum;
    private JButton butnSure;
    private SttEncoder sttEncoder;

    public LoginMinaThread(String filepath, List<RoomApiServersVo> loginServerList, JTextField inNum, JButton butnSure) {
        RoomApiServersVo loginServerVo = loginServerList.get((int)(Math.random() * (double)loginServerList.size()));
        this.Server1_Host = loginServerVo.getIp();
        this.Server1_Port = Integer.parseInt(loginServerVo.getPort());
        logger.info((Object)("\u968f\u673a\u9009\u62e9\u767b\u9646\u670d\u52a1\u5668 " + this.Server1_Host + ":" + this.Server1_Port));
        this.inNum = inNum;
        this.butnSure = butnSure;
        this.sttEncoder = new SttEncoder();
        this.filepath = filepath;
    }

    @Override
    public void run() {
        if (this.inNum.getText().equals("")) {
            this.inNum.setEditable(true);
            this.butnSure.setEnabled(true);
            logger.info((Object)"\u65e0\u6548\u7684\u623f\u95f4\u540dor\u623f\u95f4\u53f7\uff01");
        } else {
            NioSocketConnector connector = new NioSocketConnector();
            DefaultIoFilterChainBuilder chain = connector.getFilterChain();
            chain.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new HexCodecFactory()));
            connector.setHandler((IoHandler)new LoginMinaHandler(this.filepath, this.inNum, this.butnSure));
            IoSession session = null;
            try {
                ConnectFuture future = connector.connect((SocketAddress)new InetSocketAddress(this.Server1_Host, this.Server1_Port));
                future.awaitUninterruptibly();
                session = future.getSession();
                this.sttEncoder.Clear();
                this.sttEncoder.AddItem("type", "loginreq");
                this.sttEncoder.AddItem("username", "");
                this.sttEncoder.AddItem("password", "");
                this.sttEncoder.AddItem("roomid", this.inNum.getText());
                session.write((Object)HexUtils.setStringHeader("b1020000" + HexUtils.Bytes2HexStringLower(this.sttEncoder.GetResualt().getBytes("UTF-8")) + "00"));
                Thread.sleep(3000L);
                this.sttEncoder.Clear();
                this.sttEncoder.AddItem("type", "roomrefresh");
                this.sttEncoder.AddItem("serialnum", "0");
                session.write((Object)HexUtils.setStringHeader("b1020000" + HexUtils.Bytes2HexStringLower(this.sttEncoder.GetResualt().getBytes("UTF-8")) + "00"));
                Thread.sleep(1000L);
                KeepLive keeplive = new KeepLive(session);
                Thread keepliveThread = new Thread(keeplive);
                keepliveThread.start();
            }
            catch (Exception e) {
                logger.info((Object)"\u533f\u540d\u7528\u6237\u6ce8\u518c\u5931\u8d25!");
            }
        }
    }
}

