/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class DeployManifestChecker {
    private static final String JARJNLP_SUFFIX = ".jarjnlp";
    private static final String JAR_SUFFIX = ".jar";

    private DeployManifestChecker() {
    }

    public static void verify(URL uRL, boolean bl, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            DeployManifestChecker.verify(uRL, jarFile.getManifest().getMainAttributes(), bl, appInfo);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    static void verify(URL uRL, Attributes attributes, boolean bl, AppInfo appInfo) {
        String string;
        if (appInfo != null && !appInfo.hasSignedJNLP()) {
            string = attributes.getValue("Application-Name");
            if (string == null) {
                Trace.println("Missing Application-Name: manifest attribute for: " + uRL);
                string = attributes.getValue(Attributes.Name.MAIN_CLASS);
            }
            appInfo.setTitle(string);
        }
        string = attributes.getValue("Permissions");
        if (appInfo != null) {
            appInfo.setPermissionAttr(string != null);
        }
        if (string == null) {
            if (SecuritySettings.isPermissionsManifestRequired()) {
                throw new SecurityException("Missing required Permissions manifest attribute for: " + uRL);
            }
            Trace.println("Missing Permissions manifest attribute for: " + uRL);
        } else if (string.equals("sandbox")) {
            if (bl) {
                throw new SecurityException("JAR manifest requested to run in sandbox only: " + uRL);
            }
        } else if (string.equals("all-permissions")) {
            if (!bl) {
                throw new SecurityException("JAR manifest requested to run in all-permissons only: " + uRL);
            }
        } else {
            throw new SecurityException("Invalid Permissions value: " + string);
        }
        string = attributes.getValue("Codebase");
        if (string == null) {
            Trace.println("Missing Codebase manifest attribute for: " + uRL);
        } else if (!DeployManifestChecker.verifyCodebase(uRL, string, false)) {
            throw new SecurityException("JAR manifest codebase mismatch for " + uRL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean verifyCodebase(URL uRL, String string, boolean bl) {
        String string2 = uRL.getHost();
        String string3 = uRL.getProtocol();
        int n = uRL.getDefaultPort();
        int n2 = uRL.getPort();
        String[] stringArray = string.split("\\s");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n3;
            String string4 = null;
            String string5 = null;
            URL uRL2 = null;
            try {
                uRL2 = new URL(stringArray[i]);
                string4 = uRL2.getHost();
                string5 = uRL2.getProtocol();
                n3 = uRL2.getPort();
            }
            catch (MalformedURLException malformedURLException) {
                string4 = stringArray[i];
                int n4 = string4.indexOf(":");
                if (n4 == -1) {
                    n3 = -1;
                }
                string4 = stringArray[i].substring(0, n4);
                n3 = Integer.parseInt(stringArray[i].substring(n4 + 1));
            }
            if (n3 == -1) {
                bl4 = true;
            } else if (n3 == n2) {
                bl4 = true;
            } else if (n3 == n && n2 == -1) {
                bl4 = true;
            }
            if (string5 != null) {
                if (string5.equals(string3)) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (string4.equals("*")) {
                bl3 = true;
            } else if (string4.indexOf("*") != -1) {
                if (!string4.startsWith("*.")) throw new SecurityException("Invalid Codebase value: " + stringArray[i]);
                String string6 = string4.substring(2);
                if (string2.endsWith(string6)) {
                    bl3 = true;
                }
            } else if (string4.equals(string2)) {
                bl3 = true;
            }
            if (bl2 && bl3 && bl4) {
                if (!bl || !"http".equals(uRL.getProtocol()) || "http".equals(string5)) return true;
                Trace.println("Javascript from a non secure page is accessing a privileged code. Consider using HTTPS protocol when using Javascript -> Liveconnect calls.", TraceLevel.SECURITY);
                return true;
            }
            bl3 = false;
            bl2 = false;
            bl4 = false;
        }
        return false;
    }

    public static boolean verifyMultiHost(URL uRL, AppInfo appInfo) {
        String string;
        if (!appInfo.isMultiHost()) {
            return true;
        }
        if (uRL.toString().endsWith(JARJNLP_SUFFIX)) {
            string = uRL.toString();
            try {
                uRL = new URL(string.substring(0, string.length() - JARJNLP_SUFFIX.length()) + JAR_SUFFIX);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
                return false;
            }
        }
        string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return true;
        }
        JarFile jarFile = resource.getJarFile();
        boolean bl = false;
        try {
            String string2 = jarFile.getManifest().getMainAttributes().getValue("Application-Library-Allowable-Codebase");
            if (string2 == null) {
                Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + uRL);
            }
            if (string2 != null && string2.trim().length() > 0) {
                URL[] uRLArray = appInfo.getMultiHostUrls();
                for (int i = 0; i < uRLArray.length && (bl = DeployManifestChecker.verifyCodebase(uRLArray[i], string2, false)); ++i) {
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return bl;
    }
}

