local assets =
{ 
    Asset("ANIM", "anim/armor_skeleton.zip"),

    Asset("ATLAS", "images/inventoryimages/superbonearmor.xml"),
    Asset("IMAGE", "images/inventoryimages/superbonearmor.tex"),
}

local prefabs = {}

local SHIELD_DURATION = 10 * FRAMES
local SHIELD_VARIATIONS = 3
local MAIN_SHIELD_CD = 1.2

local RESISTANCES =
{
    "_combat",
    "explosive",
    "quakedebris",
    "caveindebris",
}

for j = 0, 3, 3 do
    for i = 1, SHIELD_VARIATIONS do
        table.insert(prefabs, "shadow_shield"..tostring(j + i))
    end
end

local function PickShield(inst)
    local t = GetTime()
    local flipoffset = math.random() < .5 and SHIELD_VARIATIONS or 0

    --variation 3 is the main shield
    local dt = t - inst.lastmainshield
    if dt >= MAIN_SHIELD_CD then
        inst.lastmainshield = t
        return flipoffset + 3
    end

    local rnd = math.random()
    if rnd < dt / MAIN_SHIELD_CD then
        inst.lastmainshield = t
        return flipoffset + 3
    end

    return flipoffset + (rnd < dt / (MAIN_SHIELD_CD * 2) + .5 and 2 or 1)
end

local function OnShieldOver(inst, OnResistDamage)
    inst.task = nil
    for i, v in ipairs(RESISTANCES) do
        inst.components.resistance:RemoveResistance(v)
    end
    inst.components.resistance:SetOnResistDamageFn(OnResistDamage)
end

local function OnResistDamage(inst)--, damage)
    local owner = inst.components.inventoryitem:GetGrandOwner() or inst
    local fx = SpawnPrefab("shadow_shield"..tostring(PickShield(inst)))
    fx.entity:SetParent(owner.entity)

    if inst.task ~= nil then
        inst.task:Cancel()
    end
    inst.task = inst:DoTaskInTime(SHIELD_DURATION, OnShieldOver, OnResistDamage)
    inst.components.resistance:SetOnResistDamageFn(nil)

    inst.components.fueled:DoDelta(-TUNING.SUPER_BONE_ARMOR_DELTA_FEUL)
    if inst.components.cooldown.onchargedfn ~= nil then
        inst.components.cooldown:StartCharging()
    end
end

local function ShouldResistFn(inst)
    if not inst.components.equippable:IsEquipped() then
        return false
    end
    local owner = inst.components.inventoryitem.owner
    return owner ~= nil
        and not (owner.components.inventory ~= nil and
                owner.components.inventory:EquipHasTag("forcefield"))
end

local function OnChargedFn(inst)
    if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
        inst.components.resistance:SetOnResistDamageFn(OnResistDamage)
    end
    for i, v in ipairs(RESISTANCES) do
        inst.components.resistance:AddResistance(v)
    end
end

local function nofuel(inst)
    inst.components.cooldown.onchargedfn = nil
    inst.components.cooldown:FinishCharging()
end

local function ontakefuel(inst)
    if inst.components.equippable:IsEquipped() and
        not inst.components.fueled:IsEmpty() and
        inst.components.cooldown.onchargedfn == nil then
        inst.components.cooldown.onchargedfn = OnChargedFn
        inst.components.cooldown:StartCharging(TUNING.ARMOR_SKELETON_FIRST_COOLDOWN)
    end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "armor_skeleton", "swap_body")
    inst.lastmainshield = 0
    if not inst.components.fueled:IsEmpty() then
        inst.components.cooldown.onchargedfn = OnChargedFn
        inst.components.cooldown:StartCharging(math.max(TUNING.ARMOR_SKELETON_FIRST_COOLDOWN, inst.components.cooldown:GetTimeToCharged()))
    end
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst.components.cooldown.onchargedfn = nil
    if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
        inst.components.resistance:SetOnResistDamageFn(OnResistDamage)
    end
    for i, v in ipairs(RESISTANCES) do
        inst.components.resistance:RemoveResistance(v)
    end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("armor_skeleton")
    inst.AnimState:SetBuild("armor_skeleton")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("fossil")

    inst.foleysound = "dontstarve/movement/foley/bone"

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")

	-- add by zdw for test
    inst.components.inventoryitem.imagename = "superbonearmor"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/superbonearmor.xml"
	
    inst:AddComponent("resistance")
    inst.components.resistance:SetShouldResistFn(ShouldResistFn)
    inst.components.resistance:SetOnResistDamageFn(OnResistDamage)

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
	--[[midfied by zdw
    inst.components.fueled:InitializeFuelLevel(4 * TUNING.LARGE_FUEL)
	--]]
	inst.components.fueled:InitializeFuelLevel(TUNING.SUPER_BONE_ARMOR_MAX_FEUL)
	
    inst.components.fueled:SetDepletedFn(nofuel)
    inst.components.fueled:SetTakeFuelFn(ontakefuel)
    inst.components.fueled.accepting = true

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("cooldown")
	--modifed by zdw
    --inst.components.cooldown.cooldown_duration = TUNING.ARMOR_SKELETON_COOLDOWN
	inst.components.cooldown.cooldown_duration = TUNING.SUPER_BONE_ARMOR_COOLDOWN
	
    MakeHauntableLaunch(inst)

    inst.task = nil
    inst.lastmainshield = 0

    return inst
end

STRINGS.NAMES.SUPERBONEARMOR= "Super Bone Armor"
STRINGS.RECIPE_DESC.SUPERBONEARMOR= "a super bone armor made with Ancient technology."

STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WILLOW.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WENDY.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WX78.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WOODIE.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WATHGRITHR.DESCRIBE.SUPERBONEARMOR= "It will protect me."
STRINGS.CHARACTERS.WEBBER.DESCRIBE.SUPERBONEARMOR= "It will protect me."

return Prefab("common/inventory/superbonearmor", fn, assets, prefabs)
