
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {"redgem","spear","nightmarefuel","nightmarefuel","monstermeat"
}
 

-- Rain Damage
local function dorainsparks(inst, dt)
    if inst.components.moisture ~= nil and inst.components.moisture:GetMoisture() > 0 then
        local t = GetTime()

        -- Raining, no moisture-giving equipment on head, and moisture is increasing. Pro-rate damage based on waterproofness.
        if inst.components.inventory:GetEquippedMoistureRate(EQUIPSLOTS.HEAD) <= 0 and inst.components.moisture:GetRate() > 0 then
            local waterproofmult =
                (   inst.components.sheltered ~= nil and
                    inst.components.sheltered.sheltered and
                    inst.components.sheltered.waterproofness or 0
                ) +
                (   inst.components.inventory ~= nil and
                    inst.components.inventory:GetWaterproofness() or 0
                )
            if waterproofmult < 1 and t > inst.spark_time + inst.spark_time_offset + waterproofmult * 7 then
                inst.components.health:DoDelta(TUNING.WX78_MAX_MOISTURE_DAMAGE, false, "rain")
                inst.spark_time_offset = 3 + math.random() * 2
                inst.spark_time = t
                local x, y, z = inst.Transform:GetWorldPosition()
                y = y + 1 + math.random() * 1.5
                SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
            end
        elseif t > inst.spark_time + inst.spark_time_offset then -- We have moisture-giving equipment on our head or it is not raining and we are just passively wet (but drying off). Do full damage.
            inst.components.health:DoDelta(
                inst.components.moisture:GetRate() >= 0 and
                TUNING.WX78_MAX_MOISTURE_DAMAGE or
                TUNING.WX78_MOISTURE_DRYING_DAMAGE,
                false, "water")
            inst.spark_time_offset = 3 + math.random() * 2
            inst.spark_time = t
            local x, y, z = inst.Transform:GetWorldPosition()
            y = y + .25 + math.random() * 2
            SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
        end
    end
end

local function onisraining(inst, israining)
    if israining then
        if inst.spark_task == nil then
            inst.spark_task = inst:DoPeriodicTask(.1, dorainsparks, nil, .1)
        end
    elseif inst.spark_task ~= nil then
        inst.spark_task:Cancel()
        inst.spark_task = nil
    end
end

local function onbecamebot(inst)
    if not inst.watchingrain then
        inst.watchingrain = true
        inst:WatchWorldState("israining", onisraining)
        onisraining(inst, TheWorld.state.israining)
    end
end

local function onbecameghost(inst)
    if inst.spark_task ~= nil then
        inst.spark_task:Cancel()
        inst.spark_task = nil
    end

    if inst.watchingrain then
        inst.watchingrain = false
        inst:StopWatchingWorldState("israining", onisraining)
    end
end


	local function onattack(inst, data) --get sanity when killing enemies
   local victim = data.target
    if not inst.components.health:IsDead() and IsValidVictim(victim) then
        local sanitydelta = (victim.components.combat.defaultdamage * .17)
        inst.components.sanity:DoDelta(sanitydelta)
	end
end


-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 7
    inst.components.locomotor.runspeed = 7
	inst.components.health:SetMaxHealth(300)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "eagle_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	inst:AddTag("monster")
    inst:AddTag("woodcutter")
	inst:AddTag("insomniac")
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "eagle.tex" )
	
end


-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "eagle"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(300)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(100)
	inst.components.sanity.night_drain_mult = -2
	inst.components.sanity.neg_aura_mult = 1
    inst.components.combat.damagemultiplier = 2.5
	inst.components.temperature.maxtemp = 39
	inst.components.temperature.mintemp = 30
    inst.components.locomotor.walkspeed = 7
    inst.components.locomotor.runspeed = 7
	inst.components.eater.monsterimmune = true
	inst:AddComponent("eater")
    inst.components.eater:SetDiet({ FOODTYPE.ELEMENTAL, FOODTYPE.HORRIBLE, FOODTYPE.VEGGIE, FOODTYPE.INSECT, FOODTYPE.SEEDS, FOODTYPE.GENERIC, FOODTYPE.MEAT, FOODTYPE.WOOD, FOODTYPE.NIGHTMARE} )
	inst.components.eater.strongstomach = true
	inst.components.eater.ignoresspoilage = true
	inst.components.health.fire_damage_scale = TUNING.WILLOW_FIRE_DAMAGE
	inst.components.health.fire_timestart = TUNING.WILLOW_FIRE_IMMUNITY
	inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL * (-2)
	inst.components.health:StartRegen(1,2)

     
	 
	inst:AddComponent("shedder")
    inst.components.shedder.shedItemPrefab = "nightmarefuel"
    inst.components.shedder.shedHeight = .5
    inst.components.shedder:StartShedding(TUNING.BEARGER_SHED_INTERVAL * 10) 
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
		-- Fast Worker. SetActions Doesn't work
	inst:AddComponent("worker")
	inst.components.worker:SetAction(ACTIONS.DIG, 100)
	inst.components.worker:SetAction(ACTIONS.CHOP, 100)
	inst.components.worker:SetAction(ACTIONS.MINE, 100)
	inst.components.worker:SetAction(ACTIONS.HAMMER, 100)
	
	inst.components.temperature.inherentinsulation = TUNING.INSULATION_MED
	inst.components.temperature.hurtrate = 0 / TUNING.FREEZING_KILL_TIME * 0.1 --slower freezing
	inst.components.temperature.overheattemp = 80

	
	-- Rain code
	inst.charged_task = nil
    inst.charge_time = 0
    inst.spark_task = nil
    inst.spark_time = 0
    inst.spark_time_offset = 3
    inst.watchingrain = false
    inst:ListenForEvent("ms_respawnedfromghost", onbecamebot)
    inst:ListenForEvent("ms_becameghost", onbecameghost)
    onbecamebot(inst)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("eagle", prefabs, assets, common_postinit, master_postinit, start_inv)
