local assets =
{

	Asset("ANIM", "anim/skwcoin.zip"),
    Asset("ATLAS", "images/inventoryimages/skwcoin.xml"),
    Asset("IMAGE", "images/inventoryimages/skwcoin.tex"),
}

local prefabs =
{

}    





local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function skwcoin()
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	  inst.entity:AddNetwork()
	MakeInventoryPhysics(inst)
	

    local light = inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetRadius(0.4)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.7)
    inst.Light:SetColour(32/255,229/255,153/255)

    inst.AnimState:SetBank("skwcoin")
    inst.AnimState:SetBuild("skwcoin")
    inst.AnimState:PlayAnimation("idle")
	inst.entity:SetPristine()
	 if not TheWorld.ismastersim then
            return inst
        end

    inst:AddComponent("inspectable")
	inst:AddComponent("tradable")
    inst:AddComponent("inventoryitem")--t
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize=TUNING.STACK_SIZE_SMALLITEM
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    inst.components.inventoryitem.imagename = "skwcoin"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/skwcoin.xml"
	

    return inst
end

return Prefab( "common/inventory/skwcoin", skwcoin, assets, prefabs)