local brain = require "brains/skw_brain"

local assets =
{
	Asset("ANIM", "anim/player_basic.zip"),
        Asset("ANIM", "anim/player_idles_shiver.zip"),
        Asset("ANIM", "anim/player_actions.zip"),
        Asset("ANIM", "anim/player_actions_axe.zip"),
        Asset("ANIM", "anim/player_actions_pickaxe.zip"),
        Asset("ANIM", "anim/player_actions_shovel.zip"),
        Asset("ANIM", "anim/player_actions_blowdart.zip"),
        Asset("ANIM", "anim/player_actions_eat.zip"),
        Asset("ANIM", "anim/player_actions_item.zip"),
        Asset("ANIM", "anim/player_cave_enter.zip"),
        Asset("ANIM", "anim/player_actions_uniqueitem.zip"),
        Asset("ANIM", "anim/player_actions_bugnet.zip"),
        Asset("ANIM", "anim/player_actions_fishing.zip"),
        Asset("ANIM", "anim/player_actions_boomerang.zip"),
        Asset("ANIM", "anim/player_bush_hat.zip"),
        Asset("ANIM", "anim/player_attacks.zip"),
        Asset("ANIM", "anim/player_idles.zip"),
        Asset("ANIM", "anim/player_rebirth.zip"),
        Asset("ANIM", "anim/player_jump.zip"),
        Asset("ANIM", "anim/player_amulet_resurrect.zip"),
		Asset("ANIM", "anim/player_teleport.zip"),
        Asset("ANIM", "anim/wilson_fx.zip"),
        Asset("ANIM", "anim/player_one_man_band.zip"),
        Asset("ANIM", "anim/player_slurtle_armor.zip"),
        Asset("ANIM", "anim/player_staff.zip"),
		Asset("ANIM", "anim/wilton.zip"),
		Asset("ANIM", "anim/shadow_hands.zip"),
       Asset("SOUND", "sound/sfx.fsb"),
        Asset("SOUND", "sound/wilton.fsb"),
}

local prefabs =
{

}

local WEAPONS = {"cane","axe", "spear","multitool_axe_pickaxe","goldenaxe","shovel","goldenshovel","pickaxe","goldenpickaxe","boomerang","nightsword","torch","hammer","pitchfork"}
local ARMOR = {"armorwood","armorgrass","sweatervest","armormarble","armorsanity","armorwood","trunkvest_summer","trunkvest_winter","sweatervest"}
local HAT = {"strawhat","tophat","winterhat","beehat","beefalohat","flowerhat"}

local function ontalk(inst, script)
	if not inst:HasTag("cdlfss") then
	inst:AddTag("cdlfss")
	inst.SoundEmitter:PlaySound("dontstarve/characters/wilton/talk_LP","skw_sound")
	inst:DoTaskInTime(1.8, function()
	inst.SoundEmitter:KillSound("skw_sound")
	
    inst:RemoveTag("cdlfss")
    end)
	end
end



local function ShouldAcceptItem(inst, item)

   --[[ if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        return true
    end
	if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HANDS then
        return true
    end
	if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.BODY then
        return true
    end--]]
    if item.components.edible then
        
        if (item.components.edible.foodtype == "MEAT" or item.components.edible.foodtype == "HORRIBLE")
           and inst.components.follower.leader
           and inst.components.follower:GetLoyaltyPercent() > 0.9 then
            return false
        end
        
        if item.components.edible.foodtype == "VEGGIE" then
			local last_eat_time = inst.components.eater:TimeSinceLastEating()
			if last_eat_time and last_eat_time < TUNING.PIG_MIN_POOP_PERIOD then        
				return false
			end

            if inst.components.inventory:Has(item.prefab, 1) then
                return false
            end
		end
		
        return true
    end
end







local function OnGetItemFromPlayer(inst, giver, item)
    if item.components.edible then
        if item.components.edible.foodtype == "MEAT" or item.components.edible.foodtype == "HORRIBLE" then
            if inst.components.combat.target and inst.components.combat.target == giver then
                inst.components.combat:SetTarget(nil)
            elseif giver.components.leader and not inst:HasTag("guard") then
				inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
				giver.components.leader:AddFollower(inst)
                inst.components.follower:AddLoyaltyTime(5)
            end
        end
    end
    --[[if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current then
            inst.components.inventory:RemoveItem(current)
        end
        inst.components.inventory:Equip(item)
    end
	if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HANDS then
	    local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current then
            inst.components.inventory:RemoveItem(current)
        end
        inst.components.inventory:Equip(item)
    end
	if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.BODY then
	    local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current then
            inst.components.inventory:RemoveItem(current)
        end
        inst.components.inventory:Equip(item)
    end--]]
end

local function OnRefuseItem(inst, item)
    inst.sg:GoToState("refuse")
end




local function OnEat(inst, food)
    if food.components.edible
       and food.components.edible.foodtype == "MEAT" then
        if food.components.edible:GetHealth() < 0 then
				inst.components.skw_stages.current = inst.components.skw_stages.current+1
				
        end
    end
	if food.components.edible then
		inst.components.skw_stages:SetStageStats(inst)
    end
end


local function ondeath(inst,deadthing)
if inst == deadthing then
			local phrase = STRINGS.SKW_TALK_DEATH[math.random(#STRINGS.SKW_TALK_DEATH)]
			inst.components.talker:Say(phrase)


	SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition()) --the titular poof

	inst:DoTaskInTime(1, function() 
    local rabbit = SpawnPrefab("skeleton")
	
    rabbit.Transform:SetPosition(inst.Transform:GetWorldPosition())
	local lightning = SpawnPrefab("lightning")
	lightning.Transform:SetPosition(rabbit.Transform:GetWorldPosition())
	
	local dpt = inst.components.knownlocations:GetLocation("home") 

	local lightning = SpawnPrefab("lightning")
	lightning.Transform:SetPosition(dpt.x +math.random(-1,1), dpt.y, dpt.z+math.random(-1,1))
	local lightning = SpawnPrefab("lightning")
	lightning.Transform:SetPosition(dpt.x +math.random(-4,4), dpt.y, dpt.z+math.random(-4,4))
	local lightning = SpawnPrefab("lightning")
	lightning.Transform:SetPosition(dpt.x +math.random(-7,7), dpt.y, dpt.z+math.random(-7,7))
	
            inst:Remove()
		
		rabbit:Remove()

	
    end)
end--]]
end





local function OnAttacked(inst, data)
if math.random()<0.1 then
inst.components.skw_stages.current = inst.components.skw_stages.current+1
inst.components.skw_stages:SetStageStats(inst)
end
    if TheWorld.state.isnight then
		if inst.LightWatcher:GetLightValue() < 0.35 then

		inst.components.skw_build:giveitem(inst,"torch")


		end

    end


    local attacker = data.attacker

	if not inst:HasTag("cdlf") then
	inst:AddTag("cdlf")
	inst.components.combat:SetTarget(attacker)
	inst:DoTaskInTime(3, function() 
    inst:RemoveTag("cdlf")
    end)
	end
	if data.attacker ~= nil then
		if data.attacker.prefab=="moose" or data.attacker.prefab=="bearger"  then
			inst.components.skw_build:giveitem(inst,"axe")
		end
	
	end
end



local function updatedamage(skelet, phase)
	skelet.components.combat:GiveUp()
    if phase=="night" then
		skelet.components.skw_build:giveitem(skelet,"torch")
	end
end


local BUILDING = {"firepit","beebox","tent",
"slow_farmplot","fast_farmplot","treasurechest","treasurechest","treasurechest",
"homesign","birdcage","icebox","diviningrod",
"winterometer","rainometer","lightning_rod"}
local function applyupgrades(inst)
	local health_percent = inst.components.health:GetPercent()
	if inst.components.skw_stages then
		local skw_level=inst.components.skw_stages.current
		if skw_level<=60 then
			inst.components.health.maxhealth =200+skw_level*5
		else
			inst.components.health.maxhealth =500
		end
	
	end
	inst.components.health:SetPercent(health_percent)

end





local function skwbuild(inst,phase)
	if math.random()<0.6 then
		inst.components.skw_stages.current = inst.components.skw_stages.current+1
	end
	if phase=="day" then
		if inst.components.knownlocations and inst.components.knownlocations:GetLocation("home")  then
			local dpt = inst.components.knownlocations:GetLocation("home") 
			inst.Transform:SetPosition(dpt.x, 0, dpt.z)
		end
	end
	inst.components.skw_stages:SetStageStats(inst)
	if phase=="night" and inst.components.skw_stages.current>14 and math.random() <0.7 then
		if math.random()<0.2 then
			local dpt = Vector3(inst.Transform:GetWorldPosition())
			local trap = SpawnPrefab("skw_trap")
			trap.Transform:SetPosition(dpt.x+math.random(-2,2), 0, dpt.x+math.random(-2,2))
			inst.components.skw_stages.traps=inst.components.skw_stages.traps+1
		end	
	end
	if phase=="night" then
		local skw_stages=math.min(inst.components.skw_stages.current,60)
		if math.random() < .05+skw_stages/120 then
			inst.components.skw_build:build(inst,"get_random",0,0)
		elseif math.random() < .05+skw_stages/120 then
			inst.components.skw_build:build(inst,"get_random",0,true)
		elseif math.random() < .05+skw_stages/120 then
			inst.components.skw_build:build(inst,"get_random",0,0,0,true)
		end
	end
	applyupgrades(inst)


end



local function NormalRetargetFn(inst)
	if not TheWorld.state.isnight then
    return FindEntity(inst, TUNING.PIG_TARGET_DIST/2,
        function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() then---player
                return guy:HasTag("monster") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (inst.components.follower.leader ~= nil and guy:HasTag("abigail"))
            end
        end)
	else
    return FindEntity(inst, TUNING.PIG_TARGET_DIST/2,
        function(guy)
            if not guy.LightWatcher or guy.LightWatcher:IsInLight() then
                return guy:HasTag("player") and guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) and not 
                (inst.components.follower.leader ~= nil and guy:HasTag("abigail"))
            end
        end)
		
	end
end


local function NormalKeepTarget(inst, target)
    return inst.components.combat:CanTarget(target)
           and (not target.LightWatcher or target.LightWatcher:IsInLight())
           and not (target.sg and target.sg:HasStateTag("transform") )
end


local MAX_CHASEAWAY_DIST = 2
local function KeepTarget(inst, target)

    if (inst.components.follower and inst.components.follower.leader) then
        return true
    end

    local homePos = inst.components.knownlocations:GetLocation("home")
    local targetPos = Vector3(target.Transform:GetWorldPosition() )
    return homePos and distsq(homePos, targetPos) < MAX_CHASEAWAY_DIST*MAX_CHASEAWAY_DIST
end


local function onsave(inst, data)
	if inst.components.knownlocations:GetLocation("home") and inst.components.skw_stages.current>15 then
	local dpt = inst.components.knownlocations:GetLocation("home") 
		data.x1 = dpt.x
		data.z1 = dpt.z
	end
	data.leader=inst.leader or nil
	data.leaderid=inst.leaderid or nil
end

local function onload(inst, data)
	if data and data.x1 and data.z1 then
	inst.Transform:SetPosition(data.x1, 0, data.z1)
	end

end

local function onpreload(inst, data)
	if data then
		applyupgrades(inst)
		if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
		inst.components.health:DoDelta(0)
		if data.leaderid then  
			inst.leaderid=data.leaderid 
			if inst.ownerlist==nil then
				inst.ownerlist = {}
			end
			inst.ownerlist.master=inst.leaderid or nil
		end
	end
end
local function OnAttackOther(inst, data)
    if data.target ~= nil and data.target.prefab~="moose" and data.target.prefab~="bearger" then
		inst.components.skw_stages:SetStageStats(inst)
    end
end

local function MakeSkeleton(typeof,weapon,armor,hat)
    
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddDynamicShadow()
	inst.entity:AddNetwork()
	inst.entity:AddLightWatcher()
	inst.entity:SetCanSleep(false)

	inst.DynamicShadow:SetSize( 1.5, .75 )
    inst.Transform:SetFourFaced()
	
	
    inst.LightWatcher:SetLightThresh(.2)
    inst.LightWatcher:SetDarkThresh(.05)
	
    MakeCharacterPhysics(inst, 30, .3)

    inst:AddTag("monster")
    inst:AddTag("skw")
    inst:AddTag("scarytoprey")
	inst:AddTag("hostile")

	inst:AddTag("skw_friends")	
	inst:AddTag("skwstore")	
    inst:AddTag("norizes")
    inst.AnimState:SetBank("wilson")
    inst.AnimState:SetBuild("wilton")
    
    ------------------------------------------
    

            

    ------------------------------------------
    inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    inst.components.talker.fontsize = 37
    inst.components.talker.font = TALKINGFONT
    --inst.components.talker.colour = Vector3(133/255, 140/255, 167/255)
    inst.components.talker.offset = Vector3(0,-400,0)

	
	
	 inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("inspectable")
	inst:AddComponent("thief")
	inst:AddComponent("locomotor")
    inst:AddComponent("eater")
	inst.components.eater:SetCanEatHorrible()
    inst.components.eater.strongstomach = true -- can eat monster meat!
    inst.components.eater:SetOnEatFn(OnEat)


	inst:DoTaskInTime(3,function()
		if inst.ownerlist==nil then
			inst.ownerlist = {}
		end
		inst.ownerlist.master=inst.leaderid or nil
	end)
	
    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
    ------------------
	
	
    inst:AddComponent("health")
	inst.components.health.fire_damage_scale = 0
	inst.components.health:StartRegen(2, 1)
	
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = -TUNING.SANITYAURA_MED

	
	inst:AddComponent("skwshop")
	
	inst:DoPeriodicTask(1,function(inst) 
		if inst.components.skwshop.opener  then
			inst:AddTag("shopping")
		--	print("权限:"..inst.ownerlist.master)
			inst.components.locomotor.runspeed = 0
			inst.components.locomotor.walkspeed = 0
			inst:DoTaskInTime(2,function()
				inst.components.skwshop.opener=nil
			end)
		else
			inst:RemoveTag("shopping")
		--	print("权限:"..inst.ownerlist.master)
			inst.components.locomotor.runspeed = 8
			inst.components.locomotor.walkspeed = 6
		end
	end)
	
    ------------------
    inst:AddComponent("temperature")
	inst.components.temperature.hurtrate = 0

    inst:AddComponent("combat")
    --inst.components.combat.hiteffectsymbol = "pig_torso"
	inst.components.combat:SetDefaultDamage(20)
    inst.components.combat:SetAttackPeriod(1)
    inst.components.combat:SetRetargetFunction(3, NormalRetargetFn)
    inst.components.combat:SetKeepTargetFunction(NormalKeepTarget)
    inst.components.combat:SetRange(1.1,1.1)
    ------------------------------------------
	inst.components.locomotor.runspeed = 8
    inst.components.locomotor.walkspeed = 6
    inst.components.health:SetMaxHealth(200)
	
	
	
	
    inst:AddComponent("inventory")
----    inst.components.inventory.dropondeath = false

	
    inst:AddComponent("follower")
    inst.components.follower.maxfollowtime = 25
	inst.leader=nil
	inst.leaderid=nil
	inst:AddComponent("named")
	inst:DoTaskInTime(1, function()
		if inst.leader then
			inst.components.named:SetName(inst.leader.."的骷髅")
		end
	end)
    ------------------------------------------
	inst:DoTaskInTime(1, function()
		if inst.entity and inst.entity.AddLabel then
			inst.labelname = inst.entity:AddLabel()
				if inst.labelname then
					inst.labelname:SetFontSize(35)
					inst.labelname:SetFont(DEFAULTFONT)
					inst.labelname:SetWorldOffset(0,3,0)
					inst.labelname:SetColour(1, 0.5, 0.5)
					inst.labelname:Enable(true)
				end
		end
	end)
    ------------------------------------------

    ------------------------------------------
    inst.components.talker:StopIgnoringAll()
    ------------------------------------------
    ------------------------------------------
   
    inst:SetBrain(brain)



    inst:AddComponent("lootdropper")

    inst.AnimState:Hide("ARM_carry") 
    inst.AnimState:Show("ARM_normal") 


    inst:AddComponent("knownlocations")
    
   inst:DoTaskInTime(5*FRAMES, function() inst.components.knownlocations:RememberLocation("home", Vector3(inst.Transform:GetWorldPosition()) ) end)
    inst:AddComponent("skw_build")
    inst:AddComponent("skw_stages")

	


	
    inst:DoTaskInTime(5, function(inst)
		applyupgrades(inst)
		inst.components.skw_stages:SetStageStats(inst)
	end)
	

	
	inst:WatchWorldState("phase", skwbuild)

	
	
	
    inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent("onattackother", OnAttackOther)
    inst:WatchWorldState("phase", updatedamage)
	
    inst:ListenForEvent("entity_death", function(world, data) ondeath(inst, data.inst) end, TheWorld)

    inst:SetStateGraph("SGskw")--c_spawn("skw_builder").components.skw_stages.current=60
	
    inst.OnSave = onsave
    inst.OnLoad = onload
	inst.OnPreLoad = onpreload
	
    return inst
end

return Prefab("common/skw_builder", function() return MakeSkeleton(1,"pitchfork","trunkvest_summer","strawhat") end , assets, prefabs)
