local assets =
{
    Asset("ANIM", "anim/skeletons.zip"),
}

local prefabs =
{
    "boneshard",
    "collapse_small",
}

SetSharedLootTable('skeleton',
{
    {'boneshard',   1.00},
    {'boneshard',   1.00},
})

local function getdesc(inst, viewer)
    if inst.char ~= nil and not viewer:HasTag("playerghost") then
        local mod = GetGenderStrings(inst.char)
        local desc = GetDescription(viewer, inst, mod)
        local name = inst.playername or STRINGS.NAMES[string.upper(inst.char)]

        --no translations for player killer's name
        if inst.pkname ~= nil then
            return string.format(desc, name, inst.pkname)
        end

        --permanent translations for death cause
        if inst.cause == "unknown" then
            inst.cause = "shenanigans"
        elseif inst.cause == "moose" then
            inst.cause = math.random() < .5 and "moose1" or "moose2"
        end

        --viewer based temp translations for death cause
        local cause =
            inst.cause == "nil"
            and (viewer == "waxwell" and
                "charlie" or
                "darkness")
            or inst.cause

        return string.format(desc, name, STRINGS.NAMES[string.upper(cause)] or STRINGS.NAMES.SHENANIGANS)
    end
end

local function decay(inst)
    local x, y, z = inst.Transform:GetWorldPosition()
    inst:Remove()
    SpawnPrefab("ash").Transform:SetPosition(x, y, z)
    SpawnPrefab("collapse_small").Transform:SetPosition(x, y, z)
end

local function SetSkeletonDescription(inst, char, playername, cause, pkname)
    inst.char = char
    inst.playername = playername
    inst.pkname = pkname
    inst.cause = pkname == nil and cause:lower() or nil
    inst.components.inspectable.getspecialdescription = getdesc
end

local function SetSkeletonAvatarData(inst, client_obj)
    inst.components.playeravatardata:SetData(client_obj)
end

local function onhammered(inst)
    inst.components.lootdropper:DropLoot()
    local fx = SpawnPrefab("collapse_small")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    fx:SetMaterial("rock")
    inst:Remove()
end

local function onsave(inst, data)
    data.anim = inst.animnum
end

local function onload(inst, data)
    if data ~= nil and data.anim ~= nil then
        inst.animnum = data.anim
        inst.AnimState:PlayAnimation("idle"..tostring(inst.animnum))
    end
end

local function onsaveplayer(inst, data)
    onsave(inst, data)

    data.char = inst.char
    data.playername = inst.playername
    data.pkname = inst.pkname
    data.cause = inst.cause
    if inst.skeletonspawntime ~= nil then
        local time = GetTime()
        if time > inst.skeletonspawntime then
            data.age = time - inst.skeletonspawntime
        end
    end
end

local function onloadplayer(inst, data)
    onload(inst, data)

    if data ~= nil and data.char ~= nil and (data.cause ~= nil or data.pkname ~= nil) then
        inst.char = data.char
        inst.playername = data.playername --backward compatibility for nil playername
        inst.pkname = data.pkname --backward compatibility for nil pkname
        inst.cause = data.cause
        if inst.components.inspectable ~= nil then
            inst.components.inspectable.getspecialdescription = getdesc
        end
        if data.age ~= nil and data.age > 0 then
            inst.skeletonspawntime = -data.age
        end

        if data.avatar ~= nil then
            --Load legacy data
            inst.components.playeravatardata:OnLoad(data.avatar)
        end
    end
end

local function rize(inst,player)
	        local skwrise = SpawnPrefab("skw_builder")
            skwrise.Transform:SetPosition(inst.Transform:GetWorldPosition())
	        SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition()) --the titular poof
            skwrise.sg:GoToState("amulet_rebirth")
	        local pos = Vector3(inst.Transform:GetWorldPosition())
            TheWorld:PushEvent("ms_sendlightningstrike", pos)
			TheWorld:PushEvent("ms_forceprecipitation", true)
		    inst:Remove()
			if player then
				skwrise.leader=player.name
				skwrise.leaderid=player.userid
			end
			local phrase = STRINGS.SKW_TALK_RIZE[math.random(#STRINGS.SKW_TALK_RIZE)]

	skwrise:DoTaskInTime(1.8, function()
	skwrise.components.talker:Say(phrase)
    end)
end

local function ondeath2(inst,  phase)
    local x,y,z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x,y,z, 15,{"player"})

	if phase=="night" or phase=="dusk" then
		for k,v in pairs(ents) do
			if v.components.health and not v.components.health:IsDead() and v~=inst then
				rize(inst,v)
				break
			end
		end
	end
end

local function trader(inst, giver, item)
	if not TheWorld.state.isfullmoon then
		giver.components.talker:Say("只能月圆的时候才能召唤活骷髅")
		local _item = SpawnPrefab(item.prefab)
		giver.components.inventory:GiveItem(_item)

		return
	end
	local x,y,z =inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x,y,z, 9000,"skw")
	local skw_num=0
	local skw_playernum=0
	for k,v in pairs(ents) do
        if v.prefab == "skw_builder" or v.prefab == "teleportato_base" then
			if v.leaderid  and v.leaderid==giver.userid then
				skw_playernum=skw_playernum+1
			end
			skw_num=skw_num+1
		end
	end
	if skw_playernum>=TUNING.skw_player then
		giver.components.talker:Say("目前你拥有的骷髅为"..skw_playernum.."个，超过了每人"..TUNING.skw_player.."个的上限")
		local _item = SpawnPrefab(item.prefab)
		giver.components.inventory:GiveItem(_item)
		return
	end
	if skw_num>=TUNING.skw_number then
		giver.components.talker:Say("目前该世界的骷髅数目为"..skw_num..",超过了"..TUNING.skw_number.."个")
		local _item = SpawnPrefab(item.prefab)
		giver.components.inventory:GiveItem(_item)
		return
	end
	if item and item.prefab=="shadowheart" then
		rize(inst,giver)
	end
end
local function AcceptTest(inst, item)
    return item.prefab == "shadowheart"--c_give("shadowheart") c_spawn("skw_builder",7)
end
local function OnRefuseItem(inst, giver, item)
	if item then
		giver.components.talker:Say("只有在月圆的时候接受暗影之心才能召唤活骷髅")
	end
end
local function common_fn(custom_init)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    inst.entity:AddSoundEmitter()

    MakeSmallObstaclePhysics(inst, 0.25)

    inst.AnimState:SetBank("skeleton")
    inst.AnimState:SetBuild("skeletons")

    if custom_init ~= nil then
        custom_init(inst)
    end

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    --not going to use the spear skeleton until anim to take spear is made
    inst.animnum = math.random(6)
    inst.AnimState:PlayAnimation("idle"..tostring(inst.animnum))

    inst:AddComponent("inspectable")
    inst.components.inspectable:RecordViews()
	
	inst:AddComponent("trader")
    inst.components.trader.onaccept = trader
	inst.components.trader:SetAcceptTest(AcceptTest)
	inst.components.trader.onrefuse = OnRefuseItem
	
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('skeleton')
	
	--inst:WatchWorldState("phase", ondeath2)
	
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
    inst.components.workable:SetOnFinishCallback(onhammered)

    return inst
end

local function fn()
    local inst = common_fn()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.OnLoad = onload
    inst.OnSave = onsave

    return inst
end

local function player_custominit(inst)
    inst:AddTag("playerskeleton")

    inst:AddComponent("playeravatardata")
    inst.components.playeravatardata:AddPlayerData(true)
end

local function fnplayer()
    local inst = common_fn(player_custominit)

    if not TheWorld.ismastersim then
        return inst
    end

    inst.OnLoad = onloadplayer
    inst.OnSave = onsaveplayer
    inst.SetSkeletonDescription = SetSkeletonDescription
    inst.SetSkeletonAvatarData = SetSkeletonAvatarData
    inst.Decay = decay
    inst.skeletonspawntime = GetTime()
    TheWorld:PushEvent("ms_skeletonspawn", inst)

    return inst
end

return Prefab("skeleton", fn, assets, prefabs),
    Prefab("skeleton_player", fnplayer, assets, prefabs)
