require "behaviours/wander"
require "behaviours/follow"
require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/doaction"
--require "behaviours/choptree"
require "behaviours/findlight"
require "behaviours/panic"
require "behaviours/chattynode"
require "behaviours/leash"


local MIN_FOLLOW_DIST = 2
local TARGET_FOLLOW_DIST = 5
local MAX_FOLLOW_DIST = 9
local MAX_WANDER_DIST = 20

local LEASH_RETURN_DIST = 10
local LEASH_MAX_DIST = 30

local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8
local START_RUN_DIST = 3
local STOP_RUN_DIST = 5
local MAX_CHASE_TIME = 10
local MAX_CHASE_DIST = 30
local SEE_LIGHT_DIST = 20
local TRADE_DIST = 20
local SEE_TREE_DIST = 15
local SEE_TARGET_DIST = 20
local SEE_FOOD_DIST = 10

local KEEP_CHOPPING_DIST = 10

local RUN_AWAY_DIST = 5
local STOP_RUN_AWAY_DIST = 8

local GO_HOME_DIST = 75

local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    if target and not target:HasTag("notarget") then
        return target
    end
end

local function KeepFaceTargetFn(inst, target)
    return inst:IsNear(target, KEEP_FACE_DIST) and not target:HasTag("notarget")
end

local function ShouldRunAway(inst, target)
    return not inst.components.trader:IsTryingToTradeWithMe(target)
end

local function GetTraderFn(inst)
    return FindEntity(inst, TRADE_DIST, function(target) return inst.components.trader:IsTryingToTradeWithMe(target) end, {"player"})
end

local function KeepTraderFn(inst, target)
    return inst.components.trader:IsTryingToTradeWithMe(target)
end

local function FindFoodAction(inst)
    local target = nil

	if inst.sg:HasStateTag("busy") then
		return
	end
    
    if inst.components.inventory and inst.components.eater then
        target = inst.components.inventory:FindItem(function(item) return inst.components.eater:CanEat(item) end)
    end
    
    local time_since_eat = inst.components.eater:TimeSinceLastEating()
    local noveggie = time_since_eat and time_since_eat < TUNING.PIG_MIN_POOP_PERIOD*4
    
    if not target and (not time_since_eat or time_since_eat > TUNING.PIG_MIN_POOP_PERIOD*2) then
        target = FindEntity(inst, SEE_FOOD_DIST, function(item) 
				if item:GetTimeAlive() < 8 then return false end
				if item.prefab == "mandrake" then return false end
				if noveggie and item.components.edible and item.components.edible.foodtype ~= "MEAT" then
					return false
				end
				if not item:IsOnValidGround() then
					return false
				end
				return inst.components.eater:CanEat(item) 
			end)
    end
    if target then
        return BufferedAction(inst, target, ACTIONS.EAT)
    end

    if not target and (not time_since_eat or time_since_eat > TUNING.PIG_MIN_POOP_PERIOD*2) then
        target = FindEntity(inst, SEE_FOOD_DIST, function(item) 
                if not item.components.shelf then return false end
                if not item.components.shelf.itemonshelf or not item.components.shelf.cantakeitem then return false end
                if noveggie and item.components.shelf.itemonshelf.components.edible and item.components.shelf.itemonshelf.components.edible.foodtype ~= "MEAT" then
                    return false
                end
                if not item:IsOnValidGround() then
                    return false
                end
                return inst.components.eater:CanEat(item.components.shelf.itemonshelf) 
            end)
    end

    if target then
        return BufferedAction(inst, target, ACTIONS.TAKEITEM)
    end

end


--------------------------------------------------------------
local SEE_DIST = 15
local TOOCLOSE = 2

local function StealAction(inst)
	local stage = inst.components.skw_stages.current
    local myPos = Vector3(inst.Transform:GetWorldPosition() )
    local homePos = inst.components.knownlocations:GetLocation("home")
	
if stage<15 then
    homePos = myPos
end
	if math.random()<0.4 then inst.components.skw_build:mainweapon(inst) end
	
---print("stealing... Num items in inv:."..inst.components.inventory:NumItems()..".   Random #  "..math.random(500))
    if inst.components.inventory:NumItems() < 10 then
	  if homePos and distsq(homePos, myPos) > GO_HOME_DIST*GO_HOME_DIST/2  then
		--print("seeking for steal")
		local player = ThePlayer
		local target = FindEntity(inst, SEE_DIST, function(item) 
			if item.components.inventoryitem and 
				item.components.inventoryitem.canbepickedup and 
				not item.components.inventoryitem:IsHeld() and
				item:IsOnValidGround() and 
				not item:HasTag("irreplaceable") and
				not item:HasTag("prey") and
				not item:HasTag("bird") then
				
					return player and player:GetDistanceSqToInst(item) > TOOCLOSE*TOOCLOSE
				end
			end)
	    
		if target then
			return BufferedAction(inst, target, ACTIONS.PICKUP)
		end
	  end
	elseif inst.components.inventory:NumItems() >= 10 and stage>15 then
	--print("pull items to base")
				if	distsq(homePos, myPos) < 4 then
				--	print("dropping")
					inst.components.inventory:DropEverything(false, true)
					if inst.components.skw_stages.traps<stage/5 then
						local dpt = inst.components.knownlocations:GetLocation("home") 
						local trap = SpawnPrefab("skw_trap")
						trap.Transform:SetPosition(dpt.x+math.random(-2,2), 0, dpt.x+math.random(-2,2))
						inst.components.skw_stages.traps=inst.components.skw_stages.traps+1
						--print("========PLACING TRAP # "..inst.components.skw_stages.traps)
					end	
				end	
		if homePos and distsq(homePos, myPos) > 7 and not inst.components.combat.target then
		--	print("has full invent")
			return BufferedAction(inst, nil, ACTIONS.WALKTO, nil, homePos, nil, 0.2)
		end

	end
end


local function EmptyChest(inst)
 if math.random()<0.7 then
    if not inst.components.inventory:IsFull() then
		local player = ThePlayer
		local target = FindEntity(inst, SEE_DIST, function(item) 
			if item.prefab == "treasurechest" and 
				item.components.container and
				not item.components.container:IsEmpty() then
					return player and player:GetDistanceSqToInst(item) > TOOCLOSE*TOOCLOSE
				end
			end)
		if target then
			return BufferedAction(inst, target, ACTIONS.HAMMER)
		end
	end
 end
end








-------SPECIAL RANDOM DOING



local function KeepDoingAction(inst)
    local keep_doing = (not TheWorld.state.isnight and not inst.components.inventory:IsFull()) and math.random()<0.99
    local target = FindEntity(inst, 5, function(item)
        return item.prefab~="rock_ice" and item.prefab == "deciduoustree" and item.monster and item.components.workable and (--[[item.components.workable.action == ACTIONS.DIG or--]] item.components.workable.action == ACTIONS.CHOP or item.components.workable.action == ACTIONS.MINE) 
    end)    
    if inst.tree_target ~= nil then target = inst.tree_target end

    return (keep_doing or target ~= nil)
end

local function StartDoingCondition(inst)
 --if not (inst:HasTag("mine") or inst:HasTag("chop")) then
 			if inst.components.skw_stages.current>7 then

    local start_doing = (not TheWorld.state.isnight and not inst.components.inventory:IsFull()) and math.random()<0.9
    local target = FindEntity(inst, 5, function(item) 
        return item.prefab~="rock_ice" and item.prefab == "deciduoustree" and item.monster and item.components.workable and (--[[item.components.workable.action == ACTIONS.DIG or--]] item.components.workable.action == ACTIONS.CHOP or item.components.workable.action == ACTIONS.MINE) 
    end)
    if inst.tree_target ~= nil then target = inst.tree_target end
    
    return (start_doing or target ~= nil)
	end
 ---end
end


local function FindDoingAction(inst)
    local target = FindEntity(inst, 9, function(item) return item.components.workable and (--[[item.components.workable.action == ACTIONS.DIG or--]] item.components.workable.action == ACTIONS.CHOP or item.components.workable.action == ACTIONS.MINE)  end)
    if target then
        local decid_monst_target = FindEntity(inst, 5, function(item)
            return item.prefab~="rock_ice" and item.prefab == "deciduoustree" and item.monster and item.components.workable and (--[[item.components.workable.action == ACTIONS.DIG or--]] item.components.workable.action == ACTIONS.CHOP or item.components.workable.action == ACTIONS.MINE) 
        end)
        if decid_monst_target ~= nil then 
            target = decid_monst_target 
        end
        if inst.tree_target then 
            target = inst.tree_target
            inst.tree_target = nil 
        end
		--[[if target.components.workable.action == ACTIONS.DIG then
		inst.components.skw_build:giveitem(inst,"shovel")
        return BufferedAction(inst, target, ACTIONS.DIG)--]]
		if target.components.workable.action == ACTIONS.CHOP then
		inst.components.skw_build:giveitem(inst,"axe")
        return BufferedAction(inst, target, ACTIONS.CHOP)
		elseif target.components.workable.action == ACTIONS.MINE then
		inst.components.skw_build:giveitem(inst,"pickaxe")
        return BufferedAction(inst, target, ACTIONS.MINE)
		end
    end
end

----------END




------------------------------------------------------

local function HasValidHome(inst)
    return inst.components.homeseeker and 
       inst.components.homeseeker.home and 
       inst.components.homeseeker.home:IsValid()
end

local function GoHomeAction(inst)
    if not inst.components.combat.target then
	  -- 	print("go home!!!")
    local homePos = inst.components.knownlocations:GetLocation("home")
	if not homePos then return end
        return BufferedAction(inst, nil, ACTIONS.WALKTO, nil, homePos, nil, 0.2)
    end
end



local function ShouldGoHome(inst)
	if inst.components.skw_stages.current>15 then

	--print("go home pref")

    if (inst.components.follower and inst.components.follower.leader) then
        return false
    end
	local dist_to_go = false
    local homePos = inst.components.knownlocations:GetLocation("home")
    local myPos = Vector3(inst.Transform:GetWorldPosition() )
	if homePos and distsq(homePos, myPos) > GO_HOME_DIST*GO_HOME_DIST then
		--print("dist to home go")
		dist_to_go=true
	end
    return dist_to_go or TheWorld.state.isnight
	
	end
end





local function GetLeader(inst)
    return inst.components.follower.leader 
end

local function GetHomePos(inst)
    return HasValidHome(inst) and inst.components.homeseeker:GetHomePos()
end

local function GetNoLeaderHomePos(inst)
    if GetLeader(inst) then
        return nil
    end
    return GetHomePos(inst)
end

local function GetFaceTargetFn(inst)
    return inst.components.follower.leader
end

local function KeepFaceTargetFn(inst, target)
    return inst.components.follower.leader == target
end

local skw_brain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function skw_brain:OnStart()
    --print(self.inst, "PigBrain:OnStart")
    --local clock = GetClock()
    local wander_dist = 40+self.inst.components.skw_stages.current/2
	
	local stealnode = PriorityNode(
	{
		DoAction(self.inst, function() return StealAction(self.inst) end, "steal", true ),        
		DoAction(self.inst, function() return EmptyChest(self.inst) end, "emptychest", true )
	}, 2)

	
	
	
    local day = WhileNode( function() return  not TheWorld.state.isnight end, "IsDay",
        PriorityNode{
            ChattyNode(self.inst, STRINGS.SKW_TALK_OTHER,
                DoAction(self.inst, FindFoodAction )),
            ----------------------------------------------------
            IfNode(function() return StartDoingCondition(self.inst) end, "chop", 
                WhileNode(function() return KeepDoingAction(self.inst) end, "keep chopping",
                    LoopNode{                         
                            DoAction(self.inst, FindDoingAction )})),--]]
			----------------------------------------------------
            ChattyNode(self.inst, STRINGS.SKW_TALK_OTHER, 
                Follow(self.inst, GetLeader, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST)),
            IfNode(function() return GetLeader(self.inst) end, "has leader",
				ChattyNode(self.inst, STRINGS.SKW_TALK_OTHER,
					FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn ))),

            Leash(self.inst, GetNoLeaderHomePos, LEASH_MAX_DIST, LEASH_RETURN_DIST),

           --[[ ChattyNode(self.inst, STRINGS.SKW_TALK_FIGHT,
                RunAway(self.inst, "player", START_RUN_DIST, STOP_RUN_DIST)),--]]
            ChattyNode(self.inst, STRINGS.SKW_TALK_RUNAWAY_WILSON,
                FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn)),
				
			WhileNode(function() return ShouldGoHome(self.inst) end, "ShouldGoHome",
            DoAction(self.inst, GoHomeAction, "Go Home", true )),
				
				
            Wander(self.inst, GetNoLeaderHomePos, wander_dist)
			
        },.5)
        
    
    local night = WhileNode( function() return TheWorld.state.isnight end, "IsNight",
        PriorityNode{

            ChattyNode(self.inst, STRINGS.SKW_TALK_RUNAWAY_WILSON,
                RunAway(self.inst, "spider", 4, 8)),
            RunAway(self.inst, "player", START_RUN_DIST, STOP_RUN_DIST, function(target) return ShouldRunAway(self.inst, target) end ),
        WhileNode(function() return ShouldGoHome(self.inst) end, "ShouldGoHome",
            DoAction(self.inst, GoHomeAction, "Go Home", true )),
            --[[ChattyNode(self.inst, STRINGS.PIG_TALK_FIND_LIGHT,
                FindLight(self.inst)),
            ChattyNode(self.inst, STRINGS.PIG_TALK_PANIC,
                Panic(self.inst)),--]]
        },1)
    
    
    local root = 
        PriorityNode(
        {	 WhileNode(function() return self.inst:HasTag("shopping") end, "shop",
				ChattyNode(self.inst, "来一场愉快的py建议吧！",
                FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn))),
            WhileNode(function() return self.inst.components.health.takingfiredamage end, "OnFire",
				ChattyNode(self.inst, STRINGS.SKW_TALK_PANICFIRE,
					Panic(self.inst))),
            ChattyNode(self.inst, STRINGS.SKW_TALK_FIND_LIGHT,
                WhileNode( function() return self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown() end, "AttackMomentarily",
                    ChaseAndAttack(self.inst, MAX_CHASE_TIME, MAX_CHASE_DIST) )),
			stealnode,				
            ChattyNode(self.inst, STRINGS.SKW_TALK_FIND_LIGHT,
                WhileNode( function() return self.inst.components.combat.target and self.inst.components.combat:InCooldown() end, "Dodge",
                    RunAway(self.inst, function() return self.inst.components.combat.target end, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST) )),
            RunAway(self.inst, function(guy) return guy:HasTag("pig") and guy.components.combat and guy.components.combat.target == self.inst end, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST ),
            ChattyNode(self.inst, STRINGS.SKW_TALK_FIND_LIGHT,
                FaceEntity(self.inst, GetTraderFn, KeepTraderFn)),
            day,
            night
        }, .5)
    
    self.bt = BT(self.inst, root)
    
end

return skw_brain


