local assets =
{
    Asset("ANIM", "anim/ruins_bat.zip"),
    Asset("ANIM", "anim/swap_ruins_bat.zip"),
}

local prefabs =
{
    "shadowtentacle",
}



local function NoHoles(pt)
    return not TheWorld.Map:IsPointNearHole(pt)
end




--local mdzz = inst.greenCount
--获取添加的物品
local function OnGetItemFromPlayer(inst, giver, item, player)
	local currentperc = inst.components.finiteuses:GetPercent()
	local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
	if not zerolevel then
		if currentperc<0.03 then
			inst.components.weapon:SetDamage(0)
		else
			inst.components.weapon:SetDamage(45+30/TUNING.green_bat*inst.greenCount)
		end
	else
		if currentperc<0.03 then
			inst.components.weapon:SetDamage(0)
		else
			inst.components.weapon:SetDamage(59.5)
		end
	end
	if item  then
		if  item.prefab == "greengem" then
			if inst.greenCount<TUNING.green_bat then
				inst.greenCount = inst.greenCount+1
				inst.components.weapon:SetDamage(45+30/TUNING.green_bat*inst.greenCount)
				giver.components.talker:Say("绿宝石数量:"..inst.greenCount.."/"..TUNING.green_bat)
			else
				giver.components.talker:Say("绿宝石已满")
			end
		end
		if  item.prefab =="yellowgem" then
			if inst.yellowCount<TUNING.yellow_bat then
				inst.yellowCount = inst.yellowCount+1
				inst.components.finiteuses:SetMaxUses(150+inst.yellowCount*600/TUNING.yellow_bat)
				giver.components.talker:Say("黄宝石数量:"..inst.yellowCount.."/"..TUNING.yellow_bat)
			else
				giver.components.talker:Say("黄宝石已满")
			end
		end
		if  item.prefab =="orangegem" then
			if inst.orangeCount<TUNING.orange_bat then
				inst.orangeCount = inst.orangeCount+1
				giver.components.talker:Say("橙宝石数量:"..inst.orangeCount.."/"..TUNING.orange_bat.."\n当前冰霜:"..(0.75/TUNING.orange_bat*inst.orangeCount))
			else
				giver.components.talker:Say("橙宝石已满")
			end
		end
		if item.prefab == "thulecite" then
			currentperc=currentperc + 0.40
		end
		if item.prefab == "thulecite_pieces" then
			currentperc=currentperc + 0.06
		end
		if item.prefab == "redgem" or  item.prefab == "bluegem" then
			currentperc=currentperc + 0.1
		end
		if item.prefab == "purplegem" then
			currentperc=currentperc + 0.2
		end
	end
	if inst.greenCount >= TUNING.green_bat and inst.yellowCount >=TUNING.yellow_bat   and inst.orangeCount >=  TUNING.orange_bat then
	     inst.components.finiteuses:SetMaxUses(10000000000000000000000000000000)
	end
	if currentperc>=1 then
		currentperc=1
	end
	inst.components.finiteuses:SetPercent(currentperc)
end
local function onattack(inst, owner, target)
    if math.random() < .2 then
        local pt
        if target ~= nil and target:IsValid() then
            pt = target:GetPosition()
        else
            pt = owner:GetPosition()
            target = nil
        end
        local offset = FindWalkableOffset(pt, math.random() * 2 * PI, 2, 3, false, true, NoHoles)
        if offset ~= nil then
            inst.SoundEmitter:PlaySound("dontstarve/common/shadowTentacleAttack_1")
            inst.SoundEmitter:PlaySound("dontstarve/common/shadowTentacleAttack_2")
            local tentacle = SpawnPrefab("shadowtentacle")
            if tentacle ~= nil then
                tentacle.Transform:SetPosition(pt.x + offset.x, 0, pt.z + offset.z)
                tentacle.components.combat:SetTarget(target)
            end
        end
    end
	local currentperc = inst.components.finiteuses:GetPercent()
	if target and target.components.freezable and currentperc>=0.03 and math.random() <(0.75/TUNING.orange_bat*inst.orangeCount) then
	    target.components.freezable:AddColdness(0.6)
        target.components.freezable:SpawnShatterFX()
		local prefab = "icespike_fx_"..math.random(1,4)
		local fx = SpawnPrefab(prefab)
		fx.Transform:SetScale(1, 0.8, 1)
		fx.Transform:SetPosition(target:GetPosition():Get())
	end
end
local function onequip(inst, owner)
	OnGetItemFromPlayer(inst)
    owner.AnimState:OverrideSymbol("swap_object", "swap_ruins_bat", "swap_ruins_bat")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
--加载
local function onpreload(inst, data)

	if data then
		if data.greenCount then
			inst.greenCount = data.greenCount
		end
		if data.yellowCount then
			inst.yellowCount = data.yellowCount
		end
		if data.orangeCount then
			inst.orangeCount = data.orangeCount
		end
		 if data.current ~= nil then
        inst.components.finiteuses.current=data.current
		end
		OnGetItemFromPlayer(inst)
	local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
	if  not zerolevel then
		inst.components.weapon:SetDamage(45+30/TUNING.green_bat*inst.greenCount)
	end
	if inst.greenCount >= TUNING.green_bat and inst.yellowCount >=TUNING.yellow_bat   and inst.orangeCount >=  TUNING.orange_bat then
		inst.components.finiteuses:SetMaxUses(10000000000000000000000000000000)
	else
		inst.components.finiteuses:SetMaxUses(150+inst.yellowCount*600/TUNING.yellow_bat)
	end
	end
end
--保存数据
local function onsave(inst, data)
	data.greenCount = inst.greenCount
	data.yellowCount = inst.yellowCount
	data.orangeCount = inst.orangeCount
	data.current = inst.components.finiteuses.current

end	

--加载
--local function OnLoad(inst, data)
   -- inst.components.armor:InitCondition(inst.yellowCount, inst.orangeCount)
	--inst.components.equippable.walkspeedmult = inst.greenCount
	   --[[if data.condition ~= nil then
        inst:SetCondition(data.condition)
    end--]]
	--inst.components.armor:SetCondition(inst.currentperc0*inst.components.armor.maxcondition)
--end
--设置给予不是指定物品就显示装备属性
local function OnRefuseItem(inst, giver, item)
	if item then
		giver.components.talker:Say("铥矿棒".."\n绿:"..inst.greenCount.."/"..TUNING.green_bat.."\n黄:"..inst.yellowCount.."/"..TUNING.yellow_bat.."\n橙:"..inst.orangeCount.."/"..TUNING.orange_bat)
	end
end
--设置限制加入的物品名称
local function AcceptTest(inst, item)
    return item.prefab == "greengem" or item.prefab == "yellowgem" or item.prefab == "orangegem" or 
	item.prefab == "thulecite" or item.prefab == "thulecite_pieces" or item.prefab == "bluegem"
	or item.prefab == "purplegem" or item.prefab == "redgem"
end
local function onfinished(inst) 
	inst.components.weapon:SetDamage(0)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ruins_bat")
    inst.AnimState:SetBank("ruins_bat")
    inst.AnimState:SetBuild("ruins_bat")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst.greenCount = 0
	inst.yellowCount = 0
	inst.orangeCount = 0
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(59.5)
    inst.components.weapon:SetOnAttack(onattack)

    -------

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
	if  TUNING.disappear  then
		inst.components.finiteuses:SetOnFinished(inst.Remove)
	else
		inst.components.finiteuses:SetOnFinished( onfinished)
	end
	
    inst:AddComponent("inspectable")
	inst:AddComponent("named")
	inst.components.named:SetName("铥矿棒\n  加入物品强化\n《绿宝石》加伤害\n《黄宝石》加耐久\n《橙宝石》加冰霜几率\n《铥矿蓝红紫宝石》可修复\n其他物品查看属性值")
    inst:AddComponent("inventoryitem")

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    --inst.components.equippable.walkspeedmult = 1.1
		inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(AcceptTest)
	inst.components.trader.onaccept = OnGetItemFromPlayer
	inst.components.trader.onrefuse = OnRefuseItem
	
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("ruins_bat", fn, assets, prefabs)
