require("prefabs/amulet")

local assets =
{
    Asset("ANIM", "anim/armor_ruins.zip"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end


--获取添加的物品
local function OnGetItemFromPlayer(inst, giver, item, player)
	local currentperc = inst.components.armor:GetPercent()
	local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
	if not TUNING.disappear and not zerolevel then
		if currentperc<0.03 then
			inst.components.equippable.walkspeedmult=1
			inst.components.armor:InitCondition(TUNING.ARMORRUINS+inst.yellowCount*(TUNING.ARMORRUINS*4/TUNING.yellow_armor), 0)
			inst.components.armor:SetCondition(0)
		else
			inst.components.equippable.walkspeedmult=1+0.01*math.ceil(inst.greenCount/(TUNING.green_armor/25))
			inst.components.armor:InitCondition(TUNING.ARMORRUINS+inst.yellowCount*(TUNING.ARMORRUINS*4/TUNING.yellow_armor), 0.65+inst.orangeCount*(0.3/TUNING.yellow_armor))
		end
	elseif not TUNING.disappear and zerolevel then
		if currentperc<0.03 then
			inst.components.equippable.walkspeedmult=1
			inst.components.armor:InitCondition(TUNING.ARMORRUINS, 0)
			inst.components.armor:SetCondition(0)
		else
			inst.components.equippable.walkspeedmult=1
			inst.components.armor:InitCondition(TUNING.ARMORRUINS, 0.90)
		end
	end
	
	if item  then
		if  item.prefab == "greengem" then
			if inst.greenCount<TUNING.green_armor then
				inst.greenCount = inst.greenCount+1
				inst.components.equippable.walkspeedmult =1+0.01*math.ceil(inst.greenCount/(TUNING.green_armor/25))
				giver.components.talker:Say("绿宝石数量:"..inst.greenCount.."/"..TUNING.green_armor)
			else
				giver.components.talker:Say("绿宝石已满")
			end
		end
		if  item.prefab =="yellowgem" then
			if inst.yellowCount<TUNING.yellow_armor then
				inst.yellowCount = inst.yellowCount+1
				inst.components.armor:InitCondition(TUNING.ARMORRUINS+inst.yellowCount*(TUNING.ARMORRUINS*4/TUNING.yellow_armor), 0.65+inst.orangeCount*(0.3/TUNING.yellow_armor))
				giver.components.talker:Say("黄宝石数量:"..inst.yellowCount.."/"..TUNING.yellow_armor)
			else
				giver.components.talker:Say("黄宝石已满")
			end
		end
		if  item.prefab =="orangegem" then
			if inst.orangeCount<TUNING.yellow_armor then
				inst.orangeCount = inst.orangeCount+1
				inst.components.armor:SetAbsorption(0.65+inst.orangeCount*(0.3/TUNING.yellow_armor))
				giver.components.talker:Say("橙宝石数量:"..inst.orangeCount.."/"..TUNING.yellow_armor)
			else
				giver.components.talker:Say("橙宝石已满")
			end
		end
		if item.prefab == "thulecite" then
			currentperc=currentperc + 0.40
		end
		if item.prefab == "thulecite_pieces" then
			currentperc=currentperc + 0.06
		end
		if item.prefab == "redgem" or  item.prefab == "bluegem" then
			currentperc=currentperc + 0.1
		end
		if item.prefab == "purplegem" then
			currentperc=currentperc + 0.2
		end

	end
	if inst.greenCount >= TUNING.green_armor and inst.yellowCount >=TUNING.yellow_armor   and inst.orangeCount >=  TUNING.yellow_armor then
		inst:AddComponent("insulator")
		inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)
	end
	inst.components.armor:SetPercent(currentperc)
end
local function onequip(inst, owner) 
    OnGetItemFromPlayer(inst)
    owner.AnimState:OverrideSymbol("swap_body", "armor_ruins", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
	
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	
end

local function onpreload(inst, data)
	if data then
		if data.greenCount then
			inst.greenCount = data.greenCount
		end
		if data.yellowCount then
			inst.yellowCount = data.yellowCount
		end
		if data.orangeCount then
			inst.orangeCount = data.orangeCount
		end
		OnGetItemFromPlayer(inst)
		local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
		if not zerolevel then
			inst.components.armor:InitCondition(TUNING.ARMORRUINS+inst.yellowCount*(TUNING.ARMORRUINS*4/TUNING.yellow_armor), 0.65+inst.orangeCount*(0.3/TUNING.yellow_armor))
		end
			inst.components.equippable.walkspeedmult=1+0.01*math.ceil(inst.greenCount/(TUNING.green_armor/25))
	end
end

local function onsave(inst, data)
	data.greenCount = inst.greenCount
	data.yellowCount = inst.yellowCount
	data.orangeCount = inst.orangeCount

end	


local function OnRefuseItem(inst, giver, item)
	if item then
		giver.components.talker:Say("远古盔甲".."\n绿:"..inst.greenCount.."/"..TUNING.green_armor.."\n黄:"..inst.yellowCount.."/"..TUNING.yellow_armor.."\n橙:"..inst.orangeCount.."/"..TUNING.yellow_armor)
	end
end

local function AcceptTest(inst, item)
    return item.prefab == "greengem" or item.prefab == "yellowgem" or item.prefab == "orangegem" or 
	item.prefab == "thulecite" or item.prefab == "thulecite_pieces" or item.prefab == "bluegem"
	or item.prefab == "purplegem" or item.prefab == "redgem"
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("armor_ruins")
    inst.AnimState:SetBuild("armor_ruins")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("ruins")
    inst:AddTag("metal")

	--宝石添加的数量
	

    inst.foleysound = "dontstarve/movement/foley/metalarmour"

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	inst.greenCount = 0
	inst.yellowCount = 0
	inst.orangeCount = 0
	
    inst:AddComponent("inspectable")
	inst:AddComponent("named")
	inst.components.named:SetName("铥矿甲\n  加入物品强化\n《绿宝石》加移速\n《黄宝石》加耐久\n《橙宝石》加防御\n《铥矿蓝红紫宝石》可修复\n其他物品查看属性值")
	--inst.keyima = zbos
	
    inst:AddComponent("inventoryitem")

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORRUINS, 0.90)
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_MED
	--inst.components.equippable.walkspeedmult = 1.10
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	if not TUNING.disappear  then
		inst:DoPeriodicTask(2, function()
			local currentperc = inst.components.armor:GetPercent()
			local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
			if not zerolevel then
				if currentperc<0.03 then
					inst.components.equippable.walkspeedmult=1
					inst.components.armor:InitCondition(TUNING.ARMORRUINS+inst.yellowCount*(TUNING.ARMORRUINS*4/TUNING.yellow_armor), 0)
					inst.components.armor:SetCondition(0.01)
				end
			end
		end)
	end
	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(AcceptTest)
	inst.components.trader.onaccept = OnGetItemFromPlayer
	inst.components.trader.onrefuse = OnRefuseItem


	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("armorruins", fn, assets)
