local SpawnPrefab=GLOBAL.SpawnPrefab  
local TUNING=GLOBAL.TUNING
local TheWorld=GLOBAL.TheWorld
 

TUNING.disappear= GetModConfigData("disappear")  

TUNING.green_armor= GetModConfigData("green_armor")  
TUNING.yellow_armor= GetModConfigData("yellow_armor")  
TUNING.orange_armor= GetModConfigData("orange_armor")  
  
TUNING.green_hat= GetModConfigData("green_hat")  
TUNING.yellow_hat= GetModConfigData("yellow_hat")  
TUNING.orange_hat= GetModConfigData("orange_hat")  

TUNING.green_bat= GetModConfigData("green_bat")  
TUNING.yellow_bat= GetModConfigData("yellow_bat")  
TUNING.orange_bat= GetModConfigData("orange_bat")    
  
  
local function ruinshat_fxanim(inst)
	inst._fx.AnimState:PlayAnimation("hit")
	inst._fx.AnimState:PushAnimation("idle_loop")
end

local function ruinshat_oncooldown(inst)
    inst._task = nil
end

local function ruinshat_unproc(inst)
    if inst:HasTag("forcefield") and  inst.greenCount then
        inst:RemoveTag("forcefield")
        if inst._fx ~= nil then
            inst._fx:kill_fx()
            inst._fx = nil
        end
		inst:RemoveEventCallback("armordamaged", ruinshat_fxanim)
        inst.components.armor:SetAbsorption(inst.greenCount*0.3/TUNING.green_hat+0.65)
        inst.components.armor.ontakedamage = nil

        if inst._task ~= nil then
            inst._task:Cancel()
        end
        inst._task = inst:DoTaskInTime(5, ruinshat_oncooldown)
    end
end

local function ruinshat_proc(inst, owner)
    inst:AddTag("forcefield")
    if inst._fx ~= nil then
        inst._fx:kill_fx()
    end
    inst._fx = SpawnPrefab("forcefieldfx")
    inst._fx.entity:SetParent(owner.entity)
    inst._fx.Transform:SetPosition(0, 0.2, 0)
    inst:ListenForEvent("armordamaged", ruinshat_fxanim)
    inst.components.armor:SetAbsorption(TUNING.FULL_ABSORPTION)
    inst.components.armor.ontakedamage = function(inst, damage_amount)
		if owner ~= nil and owner.components.sanity ~= nil then
			owner.components.sanity:DoDelta(-damage_amount * TUNING.ARMOR_RUINSHAT_DMG_AS_SANITY, false)
		end
    end

    if inst._task ~= nil then
        inst._task:Cancel()
    end
        inst._task = inst:DoTaskInTime(3, ruinshat_unproc)
end

local function tryproc(inst, owner, data)
	if  inst.components.armor then
	local currentperc = inst.components.armor:GetPercent()
		
    if inst._task == nil and
        not data.redirected and currentperc>=0.03 and
        math.random() < 0.2+75/TUNING.orange_hat*inst.orangeCount*0.006 then
        ruinshat_proc(inst, owner)
    end
	end
end



local function ruins_custom_init(inst)
    inst:AddTag("metal")
end

local function ruins_onremove(inst)
	if inst._fx ~= nil then
        inst._fx:kill_fx()
        inst._fx = nil
    end
end


--获取添加的物品
local function OnGetItemFromPlayer(inst, giver, item, player)
	local currentperc = inst.components.armor:GetPercent()
	local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
    if not TUNING.disappear and not zerolevel then
		if currentperc<0.03 then
			inst.components.armor:InitCondition(inst.yellowCount*840*4/TUNING.yellow_hat+840, 0)
			inst.components.armor:SetCondition(0)
		else  
			inst.components.armor:InitCondition(inst.yellowCount*840*4/TUNING.yellow_hat+840, inst.greenCount*0.3/TUNING.green_hat+0.65)
		end
	elseif not TUNING.disappear and  zerolevel then
		if currentperc<0.03 then
			inst.components.armor:InitCondition(840, 0)
			inst.components.armor:SetCondition(0)
		else 
			inst.components.armor:InitCondition(840, 0.90)
		end
	end
	if item  then
		if  item.prefab == "greengem" then
			if inst.greenCount<TUNING.green_hat then
				inst.greenCount = inst.greenCount+1
				inst.components.armor:InitCondition(inst.yellowCount*840*4/TUNING.yellow_hat+840, inst.greenCount*0.3/TUNING.green_hat+0.65)
				giver.components.talker:Say("绿宝石数量:"..inst.greenCount.."/"..TUNING.green_hat)
			else
				giver.components.talker:Say("绿宝石已满")
			end
		end
		if  item.prefab =="yellowgem" then
			if inst.yellowCount<TUNING.yellow_hat then
				inst.yellowCount = inst.yellowCount+1
				inst.components.armor:InitCondition(inst.yellowCount*840*4/TUNING.yellow_hat+840, inst.greenCount*0.3/TUNING.green_hat+0.65)
				giver.components.talker:Say("黄宝石数量:"..inst.yellowCount.."/"..TUNING.yellow_hat)
			else
				giver.components.talker:Say("黄宝石已满")
			end
		end
		if  item.prefab =="orangegem" then
			if inst.orangeCount<TUNING.orange_hat then
				inst.orangeCount = inst.orangeCount+1
				giver.components.talker:Say("橙宝石数量:"..inst.orangeCount.."/"..TUNING.orange_hat.."\n当前免伤几率:"..(0.2+75/TUNING.orange_hat*inst.orangeCount*0.006))
			else
				giver.components.talker:Say("橙宝石已满")
			end
		end
		if item.prefab == "thulecite" then
			currentperc=currentperc + 0.40
		end
		if item.prefab == "thulecite_pieces" then
			currentperc=currentperc + 0.06
		end
		if item.prefab == "redgem" or  item.prefab == "bluegem" then
			currentperc=currentperc + 0.1
		end
		if item.prefab == "purplegem" then
			currentperc=currentperc + 0.2
		end
	end
	if inst.greenCount >= TUNING.green_hat and inst.yellowCount >=TUNING.yellow_hat   and inst.orangeCount >=  TUNING.orange_hat then
	    if inst.components.waterproofer==nil then
			inst:AddComponent("waterproofer")
			inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_ABSOLUTE)
		end
	end
	if currentperc>=1 then
		currentperc=1
	end
	inst.components.armor:SetPercent(currentperc)
end



local function onpreload(inst, data)

	if data then
		if data.greenCount then
			inst.greenCount = data.greenCount
		end
		if data.yellowCount then
			inst.yellowCount = data.yellowCount
		end
		if data.orangeCount then
			inst.orangeCount = data.orangeCount
		end

		OnGetItemFromPlayer(inst)
	if data.condition ~= nil then
        inst:SetCondition(data.condition)
    end
	local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
	if not zerolevel then
		inst.components.armor:InitCondition(inst.yellowCount*840*4/TUNING.yellow_hat+840, inst.greenCount*0.3/TUNING.green_hat+0.65)
	end
	end
end

local function onsave(inst, data)
	data.greenCount = inst.greenCount
	data.yellowCount = inst.yellowCount
	data.orangeCount = inst.orangeCount

end	


local function OnRefuseItem(inst, giver, item)
	if item then
		giver.components.talker:Say("铥矿头盔".."\n绿:"..inst.greenCount.."/"..TUNING.green_hat.."\n黄:"..inst.yellowCount.."/"..TUNING.yellow_hat.."\n橙:"..inst.orangeCount.."/"..TUNING.orange_hat)
	end
end

local function AcceptTest(inst, item)
    return item.prefab == "greengem" or item.prefab == "yellowgem" or item.prefab == "orangegem" or 
	item.prefab == "thulecite" or item.prefab == "thulecite_pieces" or item.prefab == "bluegem"
	or item.prefab == "purplegem" or item.prefab == "redgem"
end
AddPrefabPostInit("ruinshat",function(inst)

	inst.greenCount = 0
	inst.yellowCount =0
	inst.orangeCount = 0
    inst.components.armor:InitCondition(840, 0.90)

    inst:ListenForEvent("equipped",OnGetItemFromPlayer)
	inst:AddComponent("named")
	inst.components.named:SetName("远古铥矿头盔\n  加入物品强化\n《绿宝石》加护甲\n《黄宝石》加耐久\n《橙宝石》加免伤几率\n《铥矿蓝红紫宝石》可修复\n其他物品查看属性值")

    inst.OnRemoveEntity = ruins_onremove

    inst._fx = nil
    inst._task = nil
    inst._owner = nil
    inst.procfn = function(owner, data) tryproc(inst, owner, data) end
    inst.onattach = function(owner)
        if inst._owner ~= nil then
            inst:RemoveEventCallback("attacked", inst.procfn, inst._owner)
            inst:RemoveEventCallback("onremove", inst.ondetach, inst._owner)
        end
        inst:ListenForEvent("attacked", inst.procfn, owner)
        inst:ListenForEvent("onremove", inst.ondetach, owner)
        inst._owner = owner
        inst._fx = nil
    end
    inst.ondetach = function()
        ruinshat_unproc(inst)
        if inst._owner ~= nil then
            inst:RemoveEventCallback("attacked", inst.procfn, inst._owner)
            inst:RemoveEventCallback("onremove", inst.ondetach, inst._owner)
            inst._owner = nil
            inst._fx = nil
        end
    end

	inst:DoPeriodicTask(10, function()
		local currentperc = inst.components.armor:GetPercent()
		local zerolevel= inst.greenCount==0 and inst.yellowCount==0 and inst.orangeCount==0
		if not zerolevel then
			inst.components.armor:SetPercent(currentperc+0.01)
		end
	end)

	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(AcceptTest)
	inst.components.trader.onaccept = OnGetItemFromPlayer
	inst.components.trader.onrefuse = OnRefuseItem
	if not TUNING.disappear  then
		inst:DoPeriodicTask(2, function()
			local currentperc = inst.components.armor:GetPercent()
			if currentperc<0.03 then

				inst.components.armor:SetCondition(0.01)--c_spawn("ruinshat").components.armor:SetCondition(0.01)

			end
		end)
	end
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
end)






local function ArmorPostInit(inst)

		function inst:SetCondition(amount)
		self.condition = math.min(amount, self.maxcondition)
		self.inst:PushEvent("percentusedchange", { percent = self:GetPercent() })

		if self.condition <= 0 then
			self.condition = 0
			GLOBAL.ProfileStatsSet("armor_broke_"..self.inst.prefab, true)
			GLOBAL.ProfileStatsSet("armor", self.inst.prefab)

			if self.onfinished ~= nil then
				self.onfinished()
			end
			if self.inst.prefab ~="armorruins" and self.inst.prefab ~="ruinshat"   then
				self.inst:Remove()
			end
		
		end
	end
end
if not TUNING.disappear  then
	AddComponentPostInit("armor", ArmorPostInit)
end