
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
	Asset("ANIM", "anim/war.zip"),
	Asset("ANIM", "anim/ghost_war_build.zip"),
}
local prefabs = {
"war_shadow"
}
local start_inv = {}


-- For vision changes
local WAR_COLOURCUBES =
{
    day = "images/colour_cubes/day05_cc.tex",
    dusk = "images/colour_cubes/dusk03_cc.tex",
    night = "images/colour_cubes/insane_night_cc.tex",
    full_moon = "images/colour_cubes/purple_moon_cc.tex"
}

local function KOTest() return false end

-- When the character is revived, re-apply some of those perks
local function onbecamehuman(inst)
	--inst.AnimState:Hide("ARM_NORMAL")
	inst.components.skinner:ClearAllClothing()
	
    inst.components.grogginess:SetKnockOutTest(KOTest)
    inst.components.debuffable:Enable(false)
    --inst.components.sanity.ignore = false -- Useless
	inst.components.moisture:ForceDry(true)
end
--local function onbecameghost(inst) end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    --inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end

	-- Always force attack
	if inst == ThePlayer then
		local _IsControlPressed = TheInput.IsControlPressed
		TheInput.IsControlPressed = function(self, control)
			if control == CONTROL_FORCE_ATTACK then
				return true
			end
			return _IsControlPressed(self, control)
		end
	end
end

--------------------------------------------------


local TARGET_DIST = 30

local max_height = 2.0
local min_height = 1.5
local going_up = true
local function MotorVelRecalc(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	if y > max_height then
		going_up = false
	elseif y < min_height then
		going_up = true
	end
	local mx, my, mz = inst.Physics:GetMotorVel()
	if going_up then	
		inst.Physics:SetMotorVel(mx, 2, mz)
	else
		inst.Physics:SetMotorVel(mx, 0, mz)
	end
	inst.war_shadow.Transform:SetPosition(x, 0, z)
end

--[[local function oncollide(inst, other)
	if other then
		inst:DoTaskInTime(1 * FRAMES, function(inst)
			if other and other.components.workable and other.components.workable:CanBeWorked() then
				SpawnPrefab("collapse_small").Transform:SetPosition(other:GetPosition():Get())
				other.components.workable:Destroy(inst)
			end
		end)
	end
end]]

local function drop(inst, data)
	inst:DoTaskInTime(0, function(inst)
		inst.components.inventory:GiveItem(data.item)
	end)
end

local function AutomaticDigging(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x, y, z, 5, nil, {"FX", "NOCLICK", "DECOR", "INLIMBO"})
	for i, other in ipairs(ents) do
		if other.components.workable and other.components.workable:CanBeWorked() then
			--oncollide(inst, other)
			inst:DoTaskInTime(1 * FRAMES, function(inst)
				SpawnPrefab("collapse_small").Transform:SetPosition(other:GetPosition():Get())
				other.components.workable:Destroy(inst)
			end)
		end
	end
end

----------------------------------------------------------

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "war.tex" )
	
	if inst.replica.talker then
		inst.replica.talker.Say = inst.replica.talker.ShutUp
	end
	
	-- Have constant night vision, but insanity hue
	inst.components.playervision:ForceNightVision(true)
	inst.components.playervision:SetCustomCCTable(WAR_COLOURCUBES)
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- Tag
	inst:AddTag("war")
	inst:AddTag("epic")
	-- Can't use stuff to sleep
	inst:AddTag("insomniac")
	inst:AddTag("pyromaniac")
	inst:AddTag("flight")
	
	inst.components.builder.science_bonus = 5

	-- choose which sounds this character will play
	inst.soundsname = "wes"
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	-- Shadow of War
	inst.DynamicShadow:SetSize(0, 0)
	inst.DynamicShadow:Enable(false)
	inst.war_shadow = SpawnPrefab("war_shadow")
	inst.floatingtask = inst:DoPeriodicTask(0.5, MotorVelRecalc)

	-- Nothing really affects this guy
	local health_SetVal = inst.components.health.SetVal
	inst.components.health.SetVal = function(self, amount, ...)
		return health_SetVal(self, 9999, ...)
	end

	-- Extra McLargeHuge health out of stock, made synchronisation awful
	inst.components.health:SetMaxHealth(9999)
	-- Can't burn or catch on fire
	inst.components.health.fire_damage_scale = 0

	-- Nullify delta functions of stats
	inst.components.hunger.redirect = function() end
	inst.components.sanity.redirect = function() end
	
	-- These get set elsewhere because of ghost shenanigans
    --inst.components.debuffable:Enable(false)
	--inst.components.grogginess:SetKnockOutTest(KOTest)

    --inst.components.moisture:ForceDry(true)
	-- These get set elsewhere because of ghost shenanigans
	
	--local moisture_DoDelta = inst.components.moisture.DoDelta
	--inst.components.moisture.DoDelta = function(self, num)
	--	return moisture_DoDelta(self, 0)
	--end

	-- Can't overheat or freeze
	inst.components.temperature.maxtemp = 40
	inst.components.temperature.current = 30
	inst.components.temperature.mintemp = 20

	inst.components.freezable.AddColdness = function() end

	-- Can eat horrible food
	inst.components.eater:SetCanEatHorrible()
	inst.components.eater:SetCanEatRaw()

	-- Map reveal bonus
	if inst.components.farseer then
		inst.components.farseer:AddBonus("war_bonus", 5)
	end

	-- Make War unequip items he equips
	inst:ListenForEvent("equip", drop)

	-- Make war silent
	if inst.components.talker then
		inst.components.talker.Say = inst.components.talker.ShutUp
	end

	-- Physics variables so he doesn't stomp with his shadow TODO wait what
	local war_mass = 200
	local war_mass_radius = 3

	MakeCharacterPhysics(inst, war_mass, war_mass_radius)

	-- War destroys its path
	--inst.Physics:SetCollisionCallback(oncollide)
	inst:DoPeriodicTask(0.2, AutomaticDigging)

	-- This is where the floating magic happens TODO compatible with Movement Prediction?
	-- Locomotor hacks to float
	local locomotor_OnUpdate = inst.components.locomotor.OnUpdate
	inst.components.locomotor.OnUpdate = function(self, dt)
		local ret = locomotor_OnUpdate(self, dt)
		MotorVelRecalc(self.inst)
		return ret
	end
	local locomotor_WalkForward = inst.components.locomotor.WalkForward
	inst.components.locomotor.WalkForward = function(self, ...)
		local ret = locomotor_WalkForward(self, ...)
		MotorVelRecalc(self.inst)
		return ret
	end
	local locomotor_RunForward = inst.components.locomotor.RunForward
	inst.components.locomotor.RunForward = function(self, ...)
		local ret = locomotor_RunForward(self, ...)
		MotorVelRecalc(self.inst)
		return ret
	end

	-- Movement speed
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8

	-- Roads don't affect War
	inst.components.locomotor.fasteronroad = false

	-- Spider webs don't affect War either
	inst.components.locomotor:SetTriggersCreep(false)
	
	-- Three extra inventory slots
	--inst.components.inventory.maxslots = inst.components.inventory.maxslots + 3

	-- Enemies that only trigger War's hurt animation have the "epic" tag, so basically, giants
	-- Others just get their damage reduced to 0
	local _GetAttacked = inst.components.combat.GetAttacked
	inst.components.combat.GetAttacked = function(self, attacker, damage, ...)
		if attacker and attacker:HasTag("epic") then
			inst.sg:GoToState("hit")
		end
		return _GetAttacked(self, attacker, 0, ...)
	end
	
	-- Attack area of effect
	inst.components.combat.defaultdamage = 500
	inst.components.combat:SetAreaDamage(5, 0.8)
	inst.components.combat:SetRange(8)

	-- War is a weapon himself, with range, not anymore because you can just increase attack range, geez
	--[[inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(1000)
	inst.components.weapon:SetRange(8)
	inst.components.combat.GetWeapon = function(self)
		return self.inst
	end]]
	
	-- Insulated from electricity
	inst.components.inventory.IsInsulated = function(self)
		return true
	end

	-- Eat it, eat it all!
	local function JustEatIt(self, food)
		if food and food.components.edible then
			return true
		end
	end
	inst.components.eater.TestFood = JustEatIt
	inst.components.eater.PrefersToEat = JustEatIt -- Because of fruitcake hack
	
	for k, v in pairs(FOODTYPE) do
		if not inst:HasTag(v .."_eater") then
			table.insert(inst.components.eater.preferseating, v)
			table.insert(inst.components.eater.caneat, v)
			inst:AddTag(v .."_eater")
		end
	end

	-- Eat > Murder TODO HUGE HACK
	--ACTIONS.EAT.priority = 1

	-- Murder sounds of the eaten TODO is that even ever the case?
	--[[inst.components.eater.oneatfn = function(inst, food)
		if food and food.components.health and food.components.health.murdersound then
			inst.SoundEmitter:PlaySound(food.components.health.murdersound)
		end
	end]]

	-- Not affected by ink
	--[[if inst.components.locomotor.AddSpeedModifier_Mult then
		local _AddSpeedModifier_Mult = inst.components.locomotor.AddSpeedModifier_Mult
		inst.components.locomotor.AddSpeedModifier_Mult = function(self, key, mod, timer)
			if key == "INK" then
				return
			end
			return _AddSpeedModifier_Mult(self, key, mod, timer)
		end
	end]]
end

return MakePlayerCharacter("war", prefabs, assets, common_postinit, master_postinit, start_inv)
