PrefabFiles = {
	"war",
	"war_shadow",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/war.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/war.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/war.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/war.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/war_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/war_silho.xml" ),

    Asset( "IMAGE", "bigportraits/war.tex" ),
    Asset( "ATLAS", "bigportraits/war.xml" ),
	
	Asset( "IMAGE", "images/map_icons/war.tex" ),
	Asset( "ATLAS", "images/map_icons/war.xml" ),

	Asset( "IMAGE", "images/avatars/avatar_war.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_war.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_war.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_war.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_war.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_war.xml" ),
	
	Asset( "IMAGE", "images/names_war.tex" ),
    Asset( "ATLAS", "images/names_war.xml" ),
	
    Asset( "IMAGE", "bigportraits/war_none.tex" ),
    Asset( "ATLAS", "bigportraits/war_none.xml" ),
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

STRINGS.CHARACTER_TITLES.war = "The Unstoppable"
STRINGS.CHARACTER_NAMES.war = "War"
STRINGS.CHARACTER_DESCRIPTIONS.war = "*Does not speak\n*Does not die\n*Does not know the definition of insanity"
STRINGS.CHARACTER_QUOTES.war = "..."

STRINGS.NAMES.WAR = "War"

STRINGS.CHARACTERS.WAR = require "speech_war"


AddMinimapAtlas("images/map_icons/war.xml")
-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, PLURAL and ATTACKHELICOPTER.
AddModCharacter("war", "NEUTRAL")


-- War stategraph hacks
local function WarPostInit1(sg)
	-- No funny idling, no bowing to bee queens
	local idle_ontimeout = sg.states.idle.ontimeout
	sg.states.idle.ontimeout = function(inst)
		if inst.prefab ~= "war" then
			return idle_ontimeout(inst)
		end
	end
	local idle_onenter = sg.states.idle.onenter
	sg.states.idle.onenter = function(inst, pushanim)
		if inst.prefab == "war" then
			inst.components.locomotor:Stop()
            inst.components.locomotor:Clear()
			inst.AnimState:PlayAnimation("idle_loop", true)
		else
			return idle_onenter(inst, pushanim)
		end
	end
	-- No long actions, only "quickpick"
	local dolongaction_onenter = sg.states.dolongaction.onenter
	sg.states.dolongaction.onenter = function(inst)
		if inst.prefab == "war" then
			inst.sg:GoToState("doshortaction")
			return
		else
			return dolongaction_onenter(inst)
		end
	end
	-- Run while you look you stand still
	local run_onenter = sg.states.run.onenter
	sg.states.run.onenter = function(inst)
		if inst.prefab == "war" then
			inst.components.locomotor:RunForward()
			inst.AnimState:PlayAnimation("idle_loop")
            inst.sg:SetTimeout(inst.AnimState:GetCurrentAnimationLength())
		else
			return run_onenter(inst)
		end
	end
	-- Always quick eat, never eat, ignore preferences
	local eat_deststate = sg.actionhandlers[GLOBAL.ACTIONS.EAT].deststate
	sg.actionhandlers[GLOBAL.ACTIONS.EAT].deststate = function(inst, action)
		if inst.prefab == "war" then
            if inst.sg:HasStateTag("busy") then
                return
            end
            local obj = action.target or action.invobject
            if obj == nil or obj.components.edible == nil then
                return
            end
            return "quickeat"
        else
			return eat_deststate(inst, action)
		end
	end
	-- Say goodbye to the eating noise
	local quickeat_onenter = sg.states.quickeat.onenter
	sg.states.quickeat.onenter = function(inst)
		quickeat_onenter(inst)
		if inst.prefab == "war" then
			--GLOBAL.TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/sanity_up")
			inst.SoundEmitter:KillSound("eating")
		end
	end
	-- No talking head bobbing
	local ontalk_deststate = sg.events.ontalk.fn
	sg.events.ontalk.fn = function(inst, data)
		if inst.prefab ~= "war" then
			return ontalk_deststate(inst, data)
		end
	end
	-- No emotion getting expressed
	local emote_deststate = sg.events.emote.fn
	sg.events.emote.fn = function(inst, data)
		if inst.prefab ~= "war" then
			return emote_deststate(inst, data)
		end
	end
	-- No wakeup animation (shouldn't ever happen anways)
	local wakeup_onenter = sg.states.wakeup.onenter
	sg.states.wakeup.onenter = function(inst, data)
		if inst.prefab == "war" then
			inst.sg:GoToState("idle")
			return
		end
		return wakeup_onenter(inst, data)
	end
end
AddStategraphPostInit("wilson", WarPostInit1)
-- War stategraph hacks for client
local function WarPostInit2(sg)
	-- No funny idling
	local idle_onenter = sg.states.idle.onenter
	sg.states.idle.onenter = function(inst, pushanim)
		if inst.prefab == "war" then
			inst.components.locomotor:Stop()
            inst.components.locomotor:Clear()
			inst.AnimState:PlayAnimation("idle_loop", true)
			
			if pushanim == "cancel" then
                return
            elseif inst:HasTag("nopredict") or inst:HasTag("pausepredict") then
                inst:ClearBufferedAction()
                return
            elseif pushanim == "noanim" then
                inst.sg:SetTimeout(TIMEOUT)
                return
            end
		else
			return idle_onenter(inst, pushanim)
		end
	end
	-- Run while you look you stand still
	local run_onenter = sg.states.run.onenter
	sg.states.run.onenter = function(inst)
		if inst.prefab == "war" then
			inst.components.locomotor:RunForward()
			inst.AnimState:PlayAnimation("idle_loop")
            inst.sg:SetTimeout(inst.AnimState:GetCurrentAnimationLength())
		else
			return run_onenter(inst)
		end
	end
	-- Always quick eat, never eat, ignore preferences
	local eat_deststate = sg.actionhandlers[GLOBAL.ACTIONS.EAT].deststate
	sg.actionhandlers[GLOBAL.ACTIONS.EAT].deststate = function(inst, action)
		if inst.prefab == "war" then
            if inst.sg:HasStateTag("busy") or inst:HasTag("busy") then
                return
            end
            local obj = action.target or action.invobject
            if obj == nil or obj.components.edible == nil then
                return
			end
            for k, v in pairs(FOODTYPE) do
                if obj:HasTag("edible_"..v) then
                    return "quickeat"
                end
            end
        else
			return eat_deststate(inst, action)
		end
	end
end
AddStategraphPostInit("wilson_client", WarPostInit2)


-- No step sounds
if GLOBAL.PlayFootstep then
	local _PlayFootstep = GLOBAL.PlayFootstep
	GLOBAL.PlayFootstep = function(inst, volume)
		if inst.prefab ~= "war" then
			return _PlayFootstep(inst, volume)
		end
	end
end

-- Invisible stat badges, and health badge repositioning
local function NoStatusDisplays(self)
	if not self.owner or not self.owner:HasTag("war") then
		return
	end
	self.brain:Hide()
	self.brain.Show = self.brain.Hide
	self.stomach:Hide()
	self.stomach.Show = self.stomach.Hide
	self.moisturemeter:Hide()
	self.moisturemeter.Show = self.moisturemeter.Hide
	self.heart:SetPosition(0, 0, 0)
end
AddClassPostConstruct("widgets/statusdisplays", NoStatusDisplays)

-- Removed equip slots
local function NoEquipSlots(self)
	if not self.owner or not self.owner:HasTag("war") then
		return
	end
	self.OnItemEquip = function(self, item, slot) end
	self.equipslotinfo = {}
	self.rebuild_pending = true
end
AddClassPostConstruct("widgets/inventorybar", NoEquipSlots)

-- Hack for equippable items, instruments, etc.; no more unwanted actions
-- Mostly a copy of the existing function, but excluding certain actions for War.
AddComponentPostInit("playeractionpicker", function(self)
	local _SortActionList = self.SortActionList
	function self:SortActionList(actions, target, useitem)
		if self.inst.prefab == "war" then
			for i=#actions,1,-1 do
			--for i, v in ipairs(actions) do --do not delete while iterating
				if actions[i] == GLOBAL.ACTIONS.EQUIP
				or actions[i] == GLOBAL.ACTIONS.UNEQUIP
				or actions[i] == GLOBAL.ACTIONS.PLAY
				or actions[i] == GLOBAL.ACTIONS.CASTSPELL
				or actions[i] == GLOBAL.ACTIONS.CHANGEIN
				or actions[i] == GLOBAL.ACTIONS.SLEEPIN then
					table.remove(actions, i)
				end
			end
			
			local ret = _SortActionList(self, actions, target, useitem)
			
			-- Eat is higher priority
			for i = 1, #ret do
				if ret[i].action == GLOBAL.ACTIONS.EAT then
					local _eat = ret[i]
					table.remove(ret, i)
					table.insert(ret, 1, _eat)
					break
				end
			end
			
			return ret			
		else
			return _SortActionList(self, actions, target, useitem)
		end
	end
end)

-- Edible hack
--[[local function AlwaysEdible(self)
	local _CollectInventoryActions = self.CollectInventoryActions
	self.CollectInventoryActions = function(self, doer, actions, right)
		if doer and doer.prefab == "war" then
			right = true
		end
		return _CollectInventoryActions(self, doer, actions, right)
	end
end
AddComponentPostInit("edible", AlwaysEdible)]]

-- What isn't edible, is now edible
GLOBAL.FOODTYPE.WARTYPE = "WARTYPE"
local function TurnEdible(inst)
	if inst.components.inventoryitem and not inst.components.edible and not inst:HasTag("irreplacable") then
		inst:AddComponent("edible")
		inst.components.edible.foodtype = GLOBAL.FOODTYPE.WARTYPE
	end
end
AddPrefabPostInitAny(TurnEdible)

-- Disable sleepy Mandrake scream TODO what exactly does this even do?
--[[local function MandrakeDoAreaEffect(inst, user, range, time, knockout)
	local x, y, z = user.Transform:GetWorldPosition()
	local ents = GLOBAL.TheSim:FindEntities(x, y, z, range)
	for k, v in pairs(ents) do
		if v.components.sleeper then
			v.components.sleeper:AddSleepiness(10, time)
		end
	end
end
local function MandrakeOnEaten(inst, eater)
	eater.SoundEmitter:PlaySound("dontstarve/creatures/mandrake/death")
	eater:DoTaskInTime(0.5, function()
		MandrakeDoAreaEffect(inst, eater, GLOBAL.TUNING.MANDRAKE_SLEEP_RANGE_COOKED, GLOBAL.TUNING.MANDRAKE_SLEEP_TIME, true)
	end)
end
local function MandrakeOnCooked(inst, cooker, chef)
	chef.SoundEmitter:PlaySound("dontstarve/creatures/mandrake/death")
	chef:DoTaskInTime(0.5, function()
		MandrakeDoAreaEffect(inst, chef, GLOBAL.TUNING.MANDRAKE_SLEEP_RANGE_COOKED, GLOBAL.TUNING.MANDRAKE_SLEEP_TIME, true)
	end)
end
local function FixMandrake(inst)
	if GLOBAL.GetPlayer().prefab == "war" then
		inst.components.edible:SetOnEatenFn(MandrakeOnEaten)
		inst.components.cookable:SetOnCookedFn(MandrakeOnCooked)
	end
end
local function FixCookedMandrake(inst)
	if GLOBAL.GetPlayer().prefab == "war" then
		inst.components.edible:SetOnEatenFn(MandrakeOnEaten)
	end
end
AddPrefabPostInit("mandrake", FixMandrake)
AddPrefabPostInit("cookedmandrake", FixCookedMandrake)]]

-- Moved force-attack to prefab

-- War immune to monkey projectiles TODO really necessary?
AddPrefabPostInit("monkeyprojectile", function(inst)
	local _OnHit = inst.components.projectile.onhit
	local function OnHit(inst, owner, target)
		if target and target.prefab == "war" then
			local poop = GLOBAL.SpawnPrefab("poop")
			poop.Transform:SetPosition(inst.Transform:GetWorldPosition())
			poop.components.inventoryitem:OnHitGround()
			inst.SoundEmitter:PlaySound("dontstarve/creatures/monkey/poopsplat")
			inst:Remove()
			return
		end
		return _OnHit(inst, owner, target)
	end
	inst.components.projectile:SetOnHitFn(OnHit)
end)
