local assets=
{
	Asset("ANIM", "anim/lty_wing.zip"),
	Asset("ANIM", "anim/lty_wing_build.zip"),
  Asset("ATLAS", "images/inventoryimages/lty_wing.xml"),
  Asset("IMAGE", "images/inventoryimages/lty_wing.tex")

}

--------------



local function onequip(inst, owner) 

    owner.AnimState:OverrideSymbol("swap_body", "lty_wing", "swap_body")


end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    owner.AnimState:ClearOverrideSymbol("backpack")

end


local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	MakeInventoryPhysics(inst)  

    inst.AnimState:SetBank("lty_wing_build")
    inst.AnimState:SetBuild("lty_wing_build")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddTag("metal")

	    inst:AddTag("backpack")
	inst:AddTag("waterproofer")


			


    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "lty_wing"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/lty_wing.xml"

	
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.2)


	
    inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(240)


 -------------------------   
    inst:AddComponent("armor")
	inst.components.armor:InitCondition(1000, 0.85)
 
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip( onequip )
	
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.walkspeedmult = 1.20
	

    return inst
end

return Prefab( "common/inventory/lty_wing", fn, assets) 
