local assets =
{
    Asset("ANIM", "anim/lty_eyebone.zip"),
    Asset("ATLAS", "images/inventoryimages/lty_eyebone.xml"),
	Asset("IMAGE", "images/inventoryimages/lty_eyebone.tex"),
}
  
local SPAWN_DIST = 30
  
local function GetSpawnPoint(pt)
    local theta = math.random() * 2 * PI
    local radius = SPAWN_DIST

	local offset = FindWalkableOffset(pt, theta, radius, 12, true)
	if offset then
		return pt+offset
	end
end
  
local function Spawndogoo(inst)

	    local pt = Vector3(inst.Transform:GetWorldPosition())
        
    local spawn_pt = GetSpawnPoint(pt)
    if spawn_pt then
        --trace("    at", spawn_pt)
        local dogoo = SpawnPrefab("lty_dogoo")
        if dogoo then
           dogoo.Physics:Teleport(spawn_pt:Get())
           dogoo:FacePoint(pt.x, pt.y, pt.z)

            return dogoo
        end

    else
        --trace("griffin_tiny - SpawnGriffin: Couldn't find a suitable spawn point for griffin")
    end
end
local function StopRespawn(inst)
    --print("dogoo_eyebone - StopRespawn")
    if inst.respawntask ~= nil then
        inst.respawntask:Cancel()
        inst.respawntask = nil
        inst.respawntime = nil
    end
end
local function Rebinddogoo(inst, dogoo)
    dogoo = dogoo or TheSim:FindFirstEntityWithTag("lty_dogoo")
    if dogoo then

        inst.AnimState:PlayAnimation("idle", true)
        --inst.components.inventoryitem:ChangeImageName(inst.openEye)
        inst:ListenForEvent("death", function() inst:OnDogooDeath() end, dogoo)

        if dogoo.components.follower.leader ~= inst then
            dogoo.components.follower:SetLeader(inst)
        end
        return true
    end
end
local function Respawndogoo(inst)
    StopRespawn(inst)

    local dogoo = TheSim:FindFirstEntityWithTag("lty_dogoo")
    if not dogoo then
        dogoo = Spawndogoo(inst)
    end
    Rebinddogoo(inst, dogoo)
end
local function StartRespawn (inst, time)
    StopRespawn(inst)
  
    local respawntime = time or 0
	if respawntime then
    inst.respawntask = inst:DoTaskInTime(respawntime, function()Respawndogoo(inst) end)
    inst.respawntime = GetTime() + respawntime
	inst.AnimState:PlayAnimation("idle")
    end
end


 

local function Fixdogoo(inst)
    inst.fixtask = nil
    --take an existing dogoo if there is one
    if not Rebinddogoo(inst) then
		inst.AnimState:PlayAnimation("idle")

          
        if inst.components.inventoryitem.owner ~= nil then
            local time_remaining = 0
            local time = GetTime()
            if inst.respawntime and inst.respawntime > time then
                time_remaining = inst.respawntime - time        
            end
            StartRespawn(inst, time_remaining)
        end
    end
end
  
local function OnPutInInventory(inst)
    if inst.fixtask == nil then
        inst.fixtask = inst:DoTaskInTime(1, function() Fixdogoo(inst) end)
    end
end
  
  
  local function OnSave(inst, data)

    local time = GetTime()
    if inst.respawntime and inst.respawntime > time then
        data.respawntimeremaining = inst.respawntime - time
    end
end
local function OnLoad(inst, data)
    if data and data.respawntimeremaining then
		inst.respawntime = data.respawntimeremaining + GetTime()
	end
end
  
  
local function GetStatus(inst)
    --print("smallbird - GetStatus")
    if inst.respawntask ~= nil then
        return "WAITING"
    end
end
local function OnDogooDeath(inst)
    StartRespawn(inst, TUNING.CHESTER_RESPAWN_TIME)
end
local function fn()
    local inst = CreateEntity()
  
    inst.entity:AddTransform()
    inst.entity:AddAnimState()


  
    MakeInventoryPhysics(inst)
  
    inst:AddTag("lty_eyebone")
	inst:AddTag("chester_eyebone")
    inst:AddTag("irreplaceable")
    inst:AddTag("nonpotatable")
    inst:AddTag("follower_leash")      
    --inst:AddTag("_named")
  
    inst.AnimState:SetBank("lty_eyebone")
    inst.AnimState:SetBuild("lty_eyebone")
    inst.AnimState:PlayAnimation("idle",true)
  

      
    -- dogoo will not be saved normally. He is saved with the player.
    --inst.persists = false
  
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "lty_eyebone"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lty_eyebone.xml"
    inst.components.inventoryitem:SetOnPutInInventoryFn(OnPutInInventory)



  
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus
	inst.components.inspectable:RecordViews()
  
    inst:AddComponent("leader")
      
      
    --inst:AddComponent("named")
  
  --  MakeHauntableLaunch(inst)
  

  
    inst.OnLoad = OnLoad
    inst.OnSave = OnSave
    inst.OnDogooDeath = OnDogooDeath
	inst.fixtask = inst:DoTaskInTime(1, function() Fixdogoo(inst) end) 
  
    return inst
end
  
return Prefab("common/inventory/lty_eyebone", fn, assets)